/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzh;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzai
implements zzaq {
    private final Double zza;

    public final int hashCode() {
        return this.zza.hashCode();
    }

    @Override
    public final zzaq zza(String string, zzh zzh2, List<zzaq> list) {
        if ("toString".equals(string)) {
            return new zzas(this.zzf());
        }
        throw new IllegalArgumentException(String.format("%s.%s is not a function.", this.zzf(), string));
    }

    @Override
    public final zzaq zzc() {
        return new zzai(this.zza);
    }

    @Override
    public final Boolean zzd() {
        return !Double.isNaN(this.zza) && this.zza != 0.0;
    }

    @Override
    public final Double zze() {
        return this.zza;
    }

    @Override
    public final String zzf() {
        if (Double.isNaN(this.zza)) {
            return "NaN";
        }
        if (Double.isInfinite(this.zza)) {
            if (this.zza > 0.0) {
                return "Infinity";
            }
            return "-Infinity";
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(this.zza);
        BigDecimal bigDecimal2 = bigDecimal.signum() == 0 ? new BigDecimal(BigInteger.ZERO, 0) : bigDecimal.stripTrailingZeros();
        DecimalFormat decimalFormat = new DecimalFormat("0E0");
        ((NumberFormat)decimalFormat).setRoundingMode(RoundingMode.HALF_UP);
        ((NumberFormat)decimalFormat).setMinimumFractionDigits(bigDecimal2.scale() > 0 ? bigDecimal2.precision() - 1 : bigDecimal2.scale() - 1);
        String string = decimalFormat.format(bigDecimal2);
        int n = string.indexOf("E");
        if (n > 0) {
            int n2 = Integer.parseInt(string.substring(n + 1));
            string = n2 < 0 && n2 > -7 || n2 >= 0 && n2 < 21 ? bigDecimal2.toPlainString() : string.replace("E-", "e-").replace("E", "e+");
        }
        return string;
    }

    public final String toString() {
        return this.zzf();
    }

    @Override
    public final @Nullable Iterator<zzaq> zzh() {
        return null;
    }

    public zzai(@Nullable Double d) {
        if (d == null) {
            this.zza = Double.NaN;
            return;
        }
        this.zza = d;
    }

    public final boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof zzai)) {
            return false;
        }
        zzai zzai2 = (zzai)object;
        return this.zza.equals(zzai2.zza);
    }
}

