/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzkp;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

abstract class zzw {
    final String zzb;
    final int zzc;
    Boolean zzd;
    Boolean zze;
    Long zzf;
    Long zzg;

    zzw(String string, int n) {
        this.zzb = string;
        this.zzc = n;
    }

    abstract int zza();

    abstract boolean zzb();

    abstract boolean zzc();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    static Boolean zze(Boolean bl, boolean bl2) {
        boolean bl3;
        if (bl == null) {
            return null;
        }
        if (bl != bl2) {
            bl3 = true;
            return bl3;
        }
        bl3 = false;
        return bl3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static Boolean zzf(String string, zzex object, zzem zzem2) {
        ArrayList<String> arrayList;
        Preconditions.checkNotNull((Object)object);
        if (string == null) {
            return null;
        }
        if (!((zzex)((Object)object)).zza()) return null;
        if (((zzex)((Object)object)).zzb() == zzew.zza) {
            return null;
        }
        if (((zzex)((Object)object)).zzb() == zzew.zzg) {
            if (((zzex)((Object)object)).zzh() == 0) return null;
        } else if (!((zzex)((Object)object)).zzc()) {
            return null;
        }
        zzew zzew2 = ((zzex)((Object)object)).zzb();
        boolean bl = ((zzex)((Object)object)).zzf();
        String string2 = bl || zzew2 == zzew.zzb || zzew2 == zzew.zzg ? ((zzex)((Object)object)).zzd() : ((zzex)((Object)object)).zzd().toUpperCase(Locale.ENGLISH);
        if (((zzex)((Object)object)).zzh() == 0) {
            object = null;
        } else {
            object = ((zzex)((Object)object)).zzg();
            if (!bl) {
                arrayList = new ArrayList<String>(object.size());
                object = object.iterator();
                while (object.hasNext()) {
                    arrayList.add(((String)object.next()).toUpperCase(Locale.ENGLISH));
                }
                object = Collections.unmodifiableList(arrayList);
            }
        }
        if (zzew2 == zzew.zzb) {
            arrayList = string2;
            return zzw.zzd(string, zzew2, bl, string2, (List<String>)object, arrayList, zzem2);
        }
        arrayList = null;
        return zzw.zzd(string, zzew2, bl, string2, (List<String>)object, arrayList, zzem2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Boolean zzd(String object, zzew zzew2, boolean bl, String string, List<String> list, String string2, zzem zzem2) {
        if (zzew2 == zzew.zzg) {
            if (list == null) return null;
            if (list.size() == 0) {
                return null;
            }
        } else if (string == null) {
            return null;
        }
        if (!bl && zzew2 != zzew.zzb) {
            object = ((String)object).toUpperCase(Locale.ENGLISH);
        }
        switch (zzew2.ordinal()) {
            case 6: {
                if (list != null) return list.contains(object);
                return null;
            }
            case 5: {
                return ((String)object).equals(string);
            }
            case 4: {
                return ((String)object).contains(string);
            }
            case 3: {
                return ((String)object).endsWith(string);
            }
            case 2: {
                return ((String)object).startsWith(string);
            }
            case 1: {
                if (string2 == null) {
                    return null;
                }
                int n = true != bl ? 66 : 0;
                return Pattern.compile(string2, n).matcher((CharSequence)object).matches();
            }
        }
        return null;
        catch (PatternSyntaxException patternSyntaxException) {
            if (zzem2 == null) return null;
            zzem2.zze().zzb("Invalid regular expression in REGEXP audience filter. expression", (Object)string2);
            return null;
        }
    }

    static Boolean zzg(long l, zzeq object) {
        try {
            BigDecimal bigDecimal = new BigDecimal(l);
            object = zzw.zzj(bigDecimal, object, 0.0);
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static Boolean zzh(double d, zzeq object) {
        try {
            BigDecimal bigDecimal = new BigDecimal(d);
            object = zzw.zzj(bigDecimal, object, Math.ulp(d));
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static Boolean zzi(String object, zzeq zzeq2) {
        if (!zzkp.zzl((String)object)) {
            return null;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal((String)object);
            object = zzw.zzj(bigDecimal, zzeq2, 0.0);
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static Boolean zzj(BigDecimal comparable, zzeq object, double d) {
        boolean bl;
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        Preconditions.checkNotNull((Object)object);
        if (!((zzeq)((Object)object)).zza()) return null;
        if (((zzeq)((Object)object)).zzb() == zzep.zza) {
            return null;
        }
        if (((zzeq)((Object)object)).zzb() == zzep.zze) {
            if (!((zzeq)((Object)object)).zzg()) return null;
            if (!((zzeq)((Object)object)).zzi()) return null;
        } else if (!((zzeq)((Object)object)).zze()) {
            return null;
        }
        zzep zzep2 = ((zzeq)((Object)object)).zzb();
        if (((zzeq)((Object)object)).zzb() == zzep.zze) {
            if (!zzkp.zzl(((zzeq)((Object)object)).zzh())) return null;
            if (!zzkp.zzl(((zzeq)((Object)object)).zzj())) {
                return null;
            }
            bigDecimal2 = new BigDecimal(((zzeq)((Object)object)).zzh());
            bigDecimal = new BigDecimal(((zzeq)((Object)object)).zzj());
            object = null;
        }
        if (!zzkp.zzl(((zzeq)((Object)object)).zzf())) {
            return null;
        }
        try {
            bigDecimal2 = new BigDecimal(((zzeq)((Object)object)).zzf());
            object = bigDecimal2;
            bigDecimal2 = null;
            bigDecimal = null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (zzep2 == zzep.zze ? bigDecimal2 == null : object == null) {
            return null;
        }
        switch (zzep2.ordinal()) {
            default: {
                return null;
            }
            case 1: {
                boolean bl2;
                if (object == null) {
                    return null;
                }
                if (((BigDecimal)comparable).compareTo((BigDecimal)object) < 0) {
                    bl2 = true;
                    return bl2;
                }
                bl2 = false;
                return bl2;
            }
            case 4: {
                if (bigDecimal2 == null) {
                    return null;
                }
                boolean bl3 = ((BigDecimal)comparable).compareTo(bigDecimal2) >= 0 ? ((BigDecimal)comparable).compareTo(bigDecimal) <= 0 : false;
                return bl3;
            }
            case 3: {
                if (object == null) {
                    return null;
                }
                if (d != 0.0) {
                    bigDecimal2 = new BigDecimal(d);
                    bigDecimal = new BigDecimal(2);
                    boolean bl4 = ((BigDecimal)comparable).compareTo(((BigDecimal)object).subtract(bigDecimal2.multiply(bigDecimal))) > 0 ? ((BigDecimal)comparable).compareTo(((BigDecimal)object).add((bigDecimal2 = new BigDecimal(d)).multiply(bigDecimal = new BigDecimal(2)))) < 0 : false;
                    return bl4;
                }
                boolean bl5 = ((BigDecimal)comparable).compareTo((BigDecimal)object) == 0;
                return bl5;
            }
            case 2: 
        }
        if (object == null) {
            return null;
        }
        if (((BigDecimal)comparable).compareTo((BigDecimal)object) > 0) {
            bl = true;
            return bl;
        }
        bl = false;
        return bl;
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

