/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzg;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzjv;
import com.google.android.gms.measurement.internal.zzkd;
import com.google.android.gms.measurement.internal.zzkk;

public final class zzjt
extends zzjv {
    private final AlarmManager zzb;
    private zzal zzc;
    private Integer zzd;

    protected zzjt(zzkd zzkd2) {
        super(zzkd2);
        this.zzb = (AlarmManager)this.zzx.zzaw().getSystemService("alarm");
    }

    private final zzal zzf() {
        if (this.zzc == null) {
            zzjs zzjs2 = new zzjs(this, (zzgg)this.zza.zzR());
            this.zzc = zzjs2;
        }
        return this.zzc;
    }

    @Override
    protected final boolean zzaz() {
        AlarmManager alarmManager = this.zzb;
        if (alarmManager != null) {
            alarmManager.cancel(this.zzj());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzh();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzh() {
        JobScheduler jobScheduler = (JobScheduler)this.zzx.zzaw().getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.cancel(this.zzi());
            return;
        }
    }

    public final void zzc(long l) {
        this.zzX();
        this.zzx.zzas();
        Context context = this.zzx.zzaw();
        if (!zzfb.zza((Context)context)) {
            this.zzx.zzat().zzj().zza("Receiver not registered/enabled");
        }
        if (!zzkk.zzP((Context)context, (boolean)false)) {
            this.zzx.zzat().zzj().zza("Service not registered/enabled");
        }
        this.zzd();
        this.zzx.zzat().zzk().zzb("Scheduling upload, millis", (Object)l);
        long l2 = this.zzx.zzax().elapsedRealtime() + l;
        this.zzx.zzc();
        if (l < Math.max(0L, (Long)zzdw.zzw.zzb(null)) && !this.zzf().zzc()) {
            this.zzf().zzb(l);
        }
        this.zzx.zzas();
        if (Build.VERSION.SDK_INT >= 24) {
            context = this.zzx.zzaw();
            ComponentName componentName = new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = this.zzi();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo.Builder builder = new JobInfo.Builder(n, componentName);
            zzg.zza(context, builder.setMinimumLatency(l).setOverrideDeadline(l + l).setExtras(persistableBundle).build(), "com.google.android.gms", "UploadAlarm");
            return;
        }
        context = this.zzb;
        if (context != null) {
            this.zzx.zzc();
            context.setInexactRepeating(2, l2, Math.max((Long)zzdw.zzr.zzb(null), l), this.zzj());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int zzi() {
        if (this.zzd == null) {
            String string = String.valueOf(this.zzx.zzaw().getPackageName());
            String string2 = "measurement";
            string = string.length() != 0 ? string2.concat(string) : new String(string2);
            this.zzd = string.hashCode();
        }
        return this.zzd;
    }

    public final void zzd() {
        this.zzX();
        this.zzx.zzat().zzk().zza("Unscheduling upload");
        AlarmManager alarmManager = this.zzb;
        if (alarmManager != null) {
            alarmManager.cancel(this.zzj());
        }
        this.zzf().zzd();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzh();
            return;
        }
    }

    private final PendingIntent zzj() {
        zzjt zzjt2 = zzjt2.zzx.zzaw();
        Intent intent = new Intent();
        return PendingIntent.getBroadcast((Context)zzjt2, (int)0, (Intent)intent.setClassName((Context)zzjt2, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD"), (int)0);
    }
}

