/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.net.ConnectivityManager;
import android.os.Build;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzjv;
import com.google.android.gms.measurement.internal.zzkd;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public final class zzeo
extends zzjv {
    private final SSLSocketFactory zzb;

    /*
     * Enabled aggressive block sorting
     */
    public zzeo(zzkd zzkd2) {
        super(zzkd2);
        if (Build.VERSION.SDK_INT < 19) {
            super(HttpsURLConnection.getDefaultSSLSocketFactory());
        } else {
            zzkd2 = null;
        }
        this.zzb = zzkd2;
    }

    @Override
    protected final boolean zzaz() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzb() {
        zzeo2.zzX();
        zzeo zzeo2 = (ConnectivityManager)zzeo2.zzx.zzaw().getSystemService("connectivity");
        if (zzeo2 == null) return false;
        try {
            zzeo2 = zzeo2.getActiveNetworkInfo();
        }
        catch (SecurityException securityException) {
            return false;
        }
        if (zzeo2 == null) return false;
        if (!zzeo2.isConnected()) return false;
        return true;
    }

    @VisibleForTesting
    @WorkerThread
    protected final HttpURLConnection zzc(URL object) throws IOException {
        if (!((object = ((URL)object).openConnection()) instanceof HttpURLConnection)) {
            Object object2 = new IOException("Failed to obtain HTTP connection");
            throw object2;
        }
        SSLSocketFactory sSLSocketFactory = object2.zzb;
        if (sSLSocketFactory != null && object instanceof HttpsURLConnection) {
            ((HttpsURLConnection)object).setSSLSocketFactory(sSLSocketFactory);
        }
        object = (HttpURLConnection)object;
        ((URLConnection)object).setDefaultUseCaches(false);
        object2.zzx.zzc();
        ((URLConnection)object).setConnectTimeout(60000);
        object2.zzx.zzc();
        ((URLConnection)object).setReadTimeout(61000);
        ((HttpURLConnection)object).setInstanceFollowRedirects(false);
        ((URLConnection)object).setDoInput(true);
        return object;
    }
}

