/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzs;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class zzhs
extends zzjm {
    public zzhs(zzjp zzjp2) {
        super(zzjp2);
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzai zzai2, @Size(min=1L) String string) {
        this.zzd();
        this.zzw.zzae();
        Preconditions.checkNotNull((Object)zzai2);
        Preconditions.checkNotEmpty((String)string);
        if (!this.zzt().zze(string, zzak.zzbl)) {
            this.zzr().zzw().zza("Generating ScionPayload disabled. packageName", (Object)string);
            return new byte[0];
        }
        if (!"_iap".equals(zzai2.zza) && !"_iapx".equals(zzai2.zza)) {
            this.zzr().zzw().zza("Generating a payload for this event is not available. package_name, event_name", (Object)string, (Object)zzai2.zza);
            return null;
        }
        zzbr.zzf.zza zza2 = zzbr.zzf.zzb();
        this.zzi().zzf();
        try {
            long l;
            long l2;
            zzae zzae2;
            long l3;
            zzae zzae3;
            zzf zzf2 = this.zzi().zzb(string);
            if (zzf2 == null) {
                this.zzr().zzw().zza("Log and bundle not available. package_name", (Object)string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzf2.zzp()) {
                this.zzr().zzw().zza("Log and bundle disabled. package_name", (Object)string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            zzbr.zzg.zza zza3 = zzbr.zzg.zzbe().zza(1).zza("android");
            if (!TextUtils.isEmpty((CharSequence)zzf2.zzb())) {
                zza3.zzf(zzf2.zzb());
            }
            if (!TextUtils.isEmpty((CharSequence)zzf2.zzl())) {
                zza3.zze(zzf2.zzl());
            }
            if (!TextUtils.isEmpty((CharSequence)zzf2.zzj())) {
                zza3.zzg(zzf2.zzj());
            }
            if (zzf2.zzk() != Integer.MIN_VALUE) {
                zza3.zzg((int)zzf2.zzk());
            }
            zza3.zzf(zzf2.zzm()).zzk(zzf2.zzo());
            if (!TextUtils.isEmpty((CharSequence)zzf2.zzd())) {
                zza3.zzk(zzf2.zzd());
            } else if (!TextUtils.isEmpty((CharSequence)zzf2.zze())) {
                zza3.zzo(zzf2.zze());
            }
            zza3.zzh(zzf2.zzn());
            if (this.zzw.zzab() && zzs.zzy() && this.zzt().zzd(zza3.zzj())) {
                zza3.zzj();
                if (!TextUtils.isEmpty(null)) {
                    zza3.zzn(null);
                }
            }
            Pair pair = this.zzs().zza(zzf2.zzb());
            if (zzf2.zzad() && pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                try {
                    zza3.zzh(zzhs.zza((String)pair.first, Long.toString(zzai2.zzd)));
                }
                catch (SecurityException securityException) {
                    this.zzr().zzw().zza("Resettable device id encryption failed", (Object)securityException.getMessage());
                    byte[] byArray = new byte[]{};
                    this.zzi().zzh();
                    return byArray;
                }
                if (pair.second != null) {
                    zza3.zza((Boolean)pair.second);
                }
            }
            this.zzl().zzaa();
            zzbr.zzg.zza zza4 = zza3.zzc(Build.MODEL);
            this.zzl().zzaa();
            zza4.zzb(Build.VERSION.RELEASE).zze((int)this.zzl().zzf()).zzd(this.zzl().zzg());
            try {
                zza3.zzi(zzhs.zza(zzf2.zzc(), Long.toString(zzai2.zzd)));
            }
            catch (SecurityException securityException) {
                this.zzr().zzw().zza("app instance id encryption failed", (Object)securityException.getMessage());
                byte[] byArray = new byte[]{};
                this.zzi().zzh();
                return byArray;
            }
            if (!TextUtils.isEmpty((CharSequence)zzf2.zzg())) {
                zza3.zzl(zzf2.zzg());
            }
            zzf zzf3 = zzf2;
            zzhs zzhs2 = this;
            String string2 = zzf3.zzb();
            List<zzjy> list = zzhs2.zzi().zza(string2);
            zzjy zzjy2 = null;
            for (zzjy zzjy3 : list) {
                if (!"_lte".equals(zzjy3.zzc)) continue;
                zzjy2 = zzjy3;
                break;
            }
            if (zzjy2 == null || zzjy2.zze == null) {
                zzjy2 = new zzjy(string2, "auto", "_lte", zzhs2.zzm().currentTimeMillis(), (Object)0L);
                list.add(zzjy2);
                zzhs2.zzi().zza(zzjy2);
            }
            if (zzhs2.zzt().zze(string2, zzak.zzbg)) {
                List<zzjy> list2 = list;
                zzf zzf4 = zzf3;
                zzjt zzjt2 = zzhs2.zzg();
                zzjt2.zzr().zzx().zza("Checking account type status for ad personalization signals");
                if (zzjt2.zzl().zzj()) {
                    String string3 = zzf4.zzb();
                    if (zzf4.zzad() && ((zzjn)zzjt2).zzj().zze(string3)) {
                        zzjy zzjy4;
                        zzjt2.zzr().zzw().zza("Turning off ad personalization due to account type");
                        Iterator<zzjy> iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            zzjy4 = iterator.next();
                            if (!"_npa".equals(zzjy4.zzc)) continue;
                            iterator.remove();
                            break;
                        }
                        zzjy4 = new zzjy(string3, "auto", "_npa", zzjt2.zzm().currentTimeMillis(), (Object)1L);
                        list2.add(zzjy4);
                    }
                }
            }
            zzbr.zzk[] zzkArray = new zzbr.zzk[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                zzbr.zzk.zza zza5 = zzbr.zzk.zzj().zza(list.get((int)i).zzc).zza(list.get((int)i).zzd);
                zzhs2.zzg().zza(zza5, list.get((int)i).zze);
                zzkArray[i] = (zzbr.zzk)((zzfd)zza5.zzu());
            }
            zza3.zzb(Arrays.asList(zzkArray));
            Bundle bundle = zzai2.zzb.zzb();
            bundle.putLong("_c", 1L);
            this.zzr().zzw().zza("Marking in-app purchase as real-time");
            bundle.putLong("_r", 1L);
            bundle.putString("_o", zzai2.zzc);
            if (this.zzp().zzf(zza3.zzj())) {
                this.zzp().zza(bundle, "_dbg", (Object)1L);
                this.zzp().zza(bundle, "_r", (Object)1L);
            }
            if ((zzae3 = this.zzi().zza(string, zzai2.zza)) == null) {
                l3 = 0L;
                zzae2 = new zzae(string, zzai2.zza, 0L, 0L, zzai2.zzd, 0L, null, null, null, null);
            } else {
                l3 = zzae3.zzf;
                zzae2 = zzae3.zza(zzai2.zzd);
            }
            this.zzi().zza(zzae2);
            zzaf zzaf2 = new zzaf(this.zzw, zzai2.zzc, string, zzai2.zza, zzai2.zzd, l3, bundle);
            zzbr.zzc.zza zza6 = zzbr.zzc.zzj().zza(zzaf2.zzc).zza(zzaf2.zzb).zzb(zzaf2.zzd);
            for (String string4 : zzaf2.zze) {
                zzbr.zze.zza zza7 = zzbr.zze.zzh().zza(string4);
                Object object = zzaf2.zze.zza(string4);
                this.zzg().zza(zza7, object);
                zza6.zza(zza7);
            }
            zza3.zza(zza6).zza(zzbr.zzh.zza().zza(zzbr.zzd.zza().zza(zzae2.zzc).zza(zzai2.zza)));
            zza3.zzc(this.e_().zza(zzf2.zzb(), Collections.emptyList(), zza3.zzd(), (Long)zza6.zze()));
            if (zza6.zzd()) {
                zza3.zzb(zza6.zze()).zzc(zza6.zze());
            }
            if ((l2 = zzf2.zzi()) != 0L) {
                zza3.zze(l2);
            }
            if ((l = zzf2.zzh()) != 0L) {
                zza3.zzd(l);
            } else if (l2 != 0L) {
                zza3.zzd(l2);
            }
            zzf2.zzt();
            zza3.zzf((int)zzf2.zzq()).zzg(this.zzt().zzf()).zza(this.zzm().currentTimeMillis()).zzb(Boolean.TRUE);
            zza2.zza(zza3);
            zzf2.zza(zza3.zzf());
            zzf2.zzb(zza3.zzg());
            this.zzi().zza(zzf2);
            this.zzi().b_();
        }
        finally {
            this.zzi().zzh();
        }
        try {
            return this.zzg().zzc(((zzbr.zzf)((zzfd)zza2.zzu())).zzbh());
        }
        catch (IOException iOException) {
            this.zzr().zzf().zza("Data loss. Failed to bundle and serialize. appId", zzej.zza((String)string), (Object)iOException);
            return null;
        }
    }

    private static String zza(String string, String string2) {
        throw new SecurityException("This implementation should not be used.");
    }
}

