/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.measurement.zzn;
import com.google.android.gms.internal.measurement.zzp;
import com.google.android.gms.internal.measurement.zzq;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.internal.measurement.zzx;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzl;
import java.util.Map;

@DynamiteApi
public class AppMeasurementDynamiteService
extends zzn {
    @VisibleForTesting
    zzfn zza = null;
    private Map<Integer, zzgr> zzb = new ArrayMap();

    private final void zza() {
        if (this.zza == null) {
            throw new IllegalStateException("Attempting to perform action before initialize.");
        }
    }

    public void initialize(IObjectWrapper iObjectWrapper, zzx zzx2, long l) throws RemoteException {
        Context context = (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        if (this.zza == null) {
            this.zza = zzfn.zza((Context)context, (zzx)zzx2);
            return;
        }
        this.zza.zzr().zzi().zza("Attempting to initialize multiple times");
    }

    public void logEvent(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(string, string2, bundle, bl, bl2, l);
    }

    public void setUserProperty(String string, String string2, IObjectWrapper iObjectWrapper, boolean bl, long l) throws RemoteException {
        this.zza();
        Object object = ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza.zzh().zza(string, string2, object, bl, l);
    }

    public void setUserId(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(null, "_id", (Object)string, true, l);
    }

    public void setCurrentScreen(IObjectWrapper iObjectWrapper, String string, String string2, long l) throws RemoteException {
        this.zza();
        this.zza.zzv().zza((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), string, string2);
    }

    public void setMeasurementEnabled(boolean bl, long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(bl);
    }

    public void resetAnalyticsData(long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zzd(l);
    }

    public void setMinimumSessionDuration(long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zza(l);
    }

    public void setSessionTimeoutDuration(long l) throws RemoteException {
        this.zza();
        this.zza.zzh().zzb(l);
    }

    public void getMaxUserProperties(String string, zzp zzp2) throws RemoteException {
        this.zza();
        this.zza.zzh();
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        string2 = zzp2;
        this.zza.zzi().zza((zzp)string2, 25);
    }

    public void getCurrentScreenName(zzp zzp2) throws RemoteException {
        this.zza();
        this.zza(zzp2, this.zza.zzh().zzaj());
    }

    public void getCurrentScreenClass(zzp zzp2) throws RemoteException {
        this.zza();
        this.zza(zzp2, this.zza.zzh().zzak());
    }

    public void getCachedAppInstanceId(zzp zzp2) throws RemoteException {
        this.zza();
        this.zza(zzp2, this.zza.zzh().zzah());
    }

    public void getAppInstanceId(zzp zzp2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzh(this, zzp2));
    }

    public void getGmpAppId(zzp zzp2) throws RemoteException {
        this.zza();
        this.zza(zzp2, this.zza.zzh().zzal());
    }

    public void generateEventId(zzp zzp2) throws RemoteException {
        this.zza();
        long l = this.zza.zzi().zzg();
        zzp zzp3 = zzp2;
        this.zza.zzi().zza(zzp3, l);
    }

    public void beginAdUnitExposure(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzz().zza(string, l);
    }

    public void endAdUnitExposure(String string, long l) throws RemoteException {
        this.zza();
        this.zza.zzz().zzb(string, l);
    }

    public void initForTests(Map map) throws RemoteException {
        this.zza();
    }

    public void logEventAndBundle(String string, String string2, Bundle bundle, zzp zzp2, long l) throws RemoteException {
        this.zza();
        Preconditions.checkNotEmpty((String)string2);
        String string3 = "app";
        (bundle != null ? new Bundle(bundle) : new Bundle()).putString("_o", string3);
        zzai zzai2 = new zzai(string2, new zzah(bundle), string3, l);
        this.zza.zzq().zza((Runnable)new zzj(this, zzp2, zzai2, string));
    }

    public void onActivityStarted(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhm zzhm2 = this.zza.zzh().zza;
        if (zzhm2 != null) {
            this.zza.zzh().zzab();
            zzhm2.onActivityStarted((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityStopped(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhm zzhm2 = this.zza.zzh().zza;
        if (zzhm2 != null) {
            this.zza.zzh().zzab();
            zzhm2.onActivityStopped((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityCreated(IObjectWrapper iObjectWrapper, Bundle bundle, long l) throws RemoteException {
        this.zza();
        zzhm zzhm2 = this.zza.zzh().zza;
        if (zzhm2 != null) {
            this.zza.zzh().zzab();
            zzhm2.onActivityCreated((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
    }

    public void onActivityDestroyed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhm zzhm2 = this.zza.zzh().zza;
        if (zzhm2 != null) {
            this.zza.zzh().zzab();
            zzhm2.onActivityDestroyed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityPaused(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhm zzhm2 = this.zza.zzh().zza;
        if (zzhm2 != null) {
            this.zza.zzh().zzab();
            zzhm2.onActivityPaused((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityResumed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zza();
        zzhm zzhm2 = this.zza.zzh().zza;
        if (zzhm2 != null) {
            this.zza.zzh().zzab();
            zzhm2.onActivityResumed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivitySaveInstanceState(IObjectWrapper iObjectWrapper, zzp zzp2, long l) throws RemoteException {
        this.zza();
        zzhm zzhm2 = this.zza.zzh().zza;
        Bundle bundle = new Bundle();
        if (zzhm2 != null) {
            this.zza.zzh().zzab();
            zzhm2.onActivitySaveInstanceState((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
        try {
            zzp2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza.zzr().zzi().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public void performAction(Bundle bundle, zzp zzp2, long l) throws RemoteException {
        this.zza();
        zzp2.zza(null);
    }

    public void getUserProperties(String string, String string2, boolean bl, zzp zzp2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzi(this, zzp2, string, string2, bl));
    }

    public void logHealthData(int n, String string, IObjectWrapper iObjectWrapper, IObjectWrapper iObjectWrapper2, IObjectWrapper iObjectWrapper3) throws RemoteException {
        this.zza();
        Object object = iObjectWrapper == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        Object object2 = iObjectWrapper2 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
        Object object3 = iObjectWrapper3 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
        this.zza.zzr().zza(n, true, false, string, object, object2, object3);
    }

    public void setEventInterceptor(zzq zzq2) throws RemoteException {
        this.zza();
        zzb zzb2 = new zzb(zzq2);
        zzgt zzgt2 = this.zza.zzh();
        zzgt2.zzb();
        zzgt2.zzw();
        zzgt2.zzq().zza((Runnable)new zzhb(zzgt2, (zzgo)zzb2));
    }

    public void registerOnMeasurementEventListener(zzq zzq2) throws RemoteException {
        this.zza();
        zzgr zzgr2 = this.zzb.get(zzq2.zza());
        if (zzgr2 == null) {
            zzgr2 = new zza(zzq2);
            this.zzb.put(zzq2.zza(), zzgr2);
        }
        this.zza.zzh().zza(zzgr2);
    }

    public void unregisterOnMeasurementEventListener(zzq zzq2) throws RemoteException {
        this.zza();
        zzgr zzgr2 = this.zzb.remove(zzq2.zza());
        if (zzgr2 == null) {
            zzgr2 = new zza(zzq2);
        }
        this.zza.zzh().zzb(zzgr2);
    }

    public void setInstanceIdProvider(zzv zzv2) throws RemoteException {
        this.zza();
    }

    public void setConditionalUserProperty(Bundle bundle, long l) throws RemoteException {
        this.zza();
        if (bundle == null) {
            this.zza.zzr().zzf().zza("Conditional user property must not be null");
            return;
        }
        this.zza.zzh().zza(bundle, l);
    }

    public void clearConditionalUserProperty(String string, String string2, Bundle bundle) throws RemoteException {
        this.zza();
        this.zza.zzh().zzc(string, string2, bundle);
    }

    public void getConditionalUserProperties(String string, String string2, zzp zzp2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzl(this, zzp2, string, string2));
    }

    public void getTestFlag(zzp zzp2, int n) throws RemoteException {
        this.zza();
        switch (n) {
            case 0: {
                this.zza.zzi().zza(zzp2, this.zza.zzh().zzad());
                return;
            }
            case 1: {
                this.zza.zzi().zza(zzp2, this.zza.zzh().zzae().longValue());
                return;
            }
            case 2: {
                double d = this.zza.zzh().zzag();
                zzp zzp3 = zzp2;
                zzjx zzjx2 = this.zza.zzi();
                Bundle bundle = new Bundle();
                bundle.putDouble("r", d);
                try {
                    zzp3.zza(bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    zzjx2.zzw.zzr().zzi().zza("Error returning double value to wrapper", (Object)remoteException);
                    return;
                }
            }
            case 3: {
                this.zza.zzi().zza(zzp2, this.zza.zzh().zzaf().intValue());
                return;
            }
            case 4: {
                this.zza.zzi().zza(zzp2, this.zza.zzh().zzac().booleanValue());
            }
        }
    }

    private final void zza(zzp zzp2, String string) {
        this.zza.zzi().zza(zzp2, string);
    }

    public void setDataCollectionEnabled(boolean bl) throws RemoteException {
        this.zza();
        this.zza.zzh().zzb(bl);
    }

    public void isDataCollectionEnabled(zzp zzp2) throws RemoteException {
        this.zza();
        this.zza.zzq().zza((Runnable)new zzk(this, zzp2));
    }

    final class zzb
    implements zzgo {
        private zzq zza;

        zzb(zzq zzq2) {
            this.zza = zzq2;
        }

        public final void interceptEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zza.zzr().zzi().zza("Event interceptor threw exception", (Object)remoteException);
                return;
            }
        }
    }

    final class zza
    implements zzgr {
        private zzq zza;

        zza(zzq zzq2) {
            this.zza = zzq2;
        }

        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zza.zza(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zza.zzr().zzi().zza("Event listener threw exception", (Object)remoteException);
                return;
            }
        }
    }
}

