/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.measurement.zzn;
import com.google.android.gms.internal.measurement.zzp;
import com.google.android.gms.internal.measurement.zzq;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.internal.measurement.zzx;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzl;
import java.util.Map;

@DynamiteApi
public class AppMeasurementDynamiteService
extends zzn {
    @VisibleForTesting
    zzfj zzj = null;
    private Map<Integer, zzgn> zzdk = new ArrayMap();

    private final void zzbi() {
        if (this.zzj == null) {
            throw new IllegalStateException("Attempting to perform action before initialize.");
        }
    }

    public void initialize(IObjectWrapper iObjectWrapper, zzx zzx2, long l) throws RemoteException {
        Context context = (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        if (this.zzj == null) {
            this.zzj = zzfj.zza((Context)context, (zzx)zzx2);
            return;
        }
        this.zzj.zzab().zzgn().zzao("Attempting to initialize multiple times");
    }

    public void logEvent(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) throws RemoteException {
        this.zzbi();
        this.zzj.zzq().logEvent(string, string2, bundle, bl, bl2, l);
    }

    public void setUserProperty(String string, String string2, IObjectWrapper iObjectWrapper, boolean bl, long l) throws RemoteException {
        this.zzbi();
        Object object = ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zzj.zzq().zza(string, string2, object, bl, l);
    }

    public void setUserId(String string, long l) throws RemoteException {
        this.zzbi();
        this.zzj.zzq().zza(null, "_id", (Object)string, true, l);
    }

    public void setCurrentScreen(IObjectWrapper iObjectWrapper, String string, String string2, long l) throws RemoteException {
        this.zzbi();
        this.zzj.zzt().setCurrentScreen((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), string, string2);
    }

    public void setMeasurementEnabled(boolean bl, long l) throws RemoteException {
        this.zzbi();
        this.zzj.zzq().setMeasurementEnabled(bl);
    }

    public void resetAnalyticsData(long l) throws RemoteException {
        this.zzbi();
        this.zzj.zzq().resetAnalyticsData(l);
    }

    public void setMinimumSessionDuration(long l) throws RemoteException {
        this.zzbi();
        this.zzj.zzq().setMinimumSessionDuration(l);
    }

    public void setSessionTimeoutDuration(long l) throws RemoteException {
        this.zzbi();
        this.zzj.zzq().setSessionTimeoutDuration(l);
    }

    public void getMaxUserProperties(String string, zzp zzp2) throws RemoteException {
        this.zzbi();
        this.zzj.zzq();
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        string2 = zzp2;
        this.zzj.zzz().zza((zzp)string2, 25);
    }

    public void getCurrentScreenName(zzp zzp2) throws RemoteException {
        this.zzbi();
        this.zza(zzp2, this.zzj.zzq().getCurrentScreenName());
    }

    public void getCurrentScreenClass(zzp zzp2) throws RemoteException {
        this.zzbi();
        this.zza(zzp2, this.zzj.zzq().getCurrentScreenClass());
    }

    public void getCachedAppInstanceId(zzp zzp2) throws RemoteException {
        this.zzbi();
        this.zza(zzp2, this.zzj.zzq().zzi());
    }

    public void getAppInstanceId(zzp zzp2) throws RemoteException {
        this.zzbi();
        this.zzj.zzaa().zza((Runnable)new zzh(this, zzp2));
    }

    public void getDeepLink(zzp zzp2) throws RemoteException {
        zzdu zzdu2;
        this.zzbi();
        zzp zzp3 = zzp2;
        zzgp zzgp2 = this.zzj.zzq();
        zzgp2.zzo();
        zzdu zzdu3 = zzdu2 = zzak.zzjc;
        if (!zzgp2.zzad().zzd(null, zzdu3)) {
            zzgp2.zzz().zzb(zzp3, "");
            return;
        }
        if (zzgp2.zzac().zzme.get() > 0L) {
            zzgp2.zzz().zzb(zzp3, "");
            return;
        }
        zzgp2.zzac().zzme.set(zzgp2.zzx().currentTimeMillis());
        zzgp2.zzj.zza(zzp3);
    }

    public void getGmpAppId(zzp zzp2) throws RemoteException {
        this.zzbi();
        this.zza(zzp2, this.zzj.zzq().getGmpAppId());
    }

    public void generateEventId(zzp zzp2) throws RemoteException {
        this.zzbi();
        long l = this.zzj.zzz().zzjv();
        zzp zzp3 = zzp2;
        this.zzj.zzz().zza(zzp3, l);
    }

    public void beginAdUnitExposure(String string, long l) throws RemoteException {
        this.zzbi();
        this.zzj.zzp().beginAdUnitExposure(string, l);
    }

    public void endAdUnitExposure(String string, long l) throws RemoteException {
        this.zzbi();
        this.zzj.zzp().endAdUnitExposure(string, l);
    }

    public void initForTests(Map map) throws RemoteException {
        this.zzbi();
    }

    public void logEventAndBundle(String string, String string2, Bundle bundle, zzp zzp2, long l) throws RemoteException {
        this.zzbi();
        Preconditions.checkNotEmpty((String)string2);
        String string3 = "app";
        (bundle != null ? new Bundle(bundle) : new Bundle()).putString("_o", string3);
        zzai zzai2 = new zzai(string2, new zzah(bundle), string3, l);
        this.zzj.zzaa().zza((Runnable)new zzj(this, zzp2, zzai2, string));
    }

    public void onActivityStarted(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzbi();
        zzhj zzhj2 = this.zzj.zzq().zzpu;
        if (zzhj2 != null) {
            this.zzj.zzq().zzif();
            zzhj2.onActivityStarted((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityStopped(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzbi();
        zzhj zzhj2 = this.zzj.zzq().zzpu;
        if (zzhj2 != null) {
            this.zzj.zzq().zzif();
            zzhj2.onActivityStopped((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityCreated(IObjectWrapper iObjectWrapper, Bundle bundle, long l) throws RemoteException {
        this.zzbi();
        zzhj zzhj2 = this.zzj.zzq().zzpu;
        if (zzhj2 != null) {
            this.zzj.zzq().zzif();
            zzhj2.onActivityCreated((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
    }

    public void onActivityDestroyed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzbi();
        zzhj zzhj2 = this.zzj.zzq().zzpu;
        if (zzhj2 != null) {
            this.zzj.zzq().zzif();
            zzhj2.onActivityDestroyed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityPaused(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzbi();
        zzhj zzhj2 = this.zzj.zzq().zzpu;
        if (zzhj2 != null) {
            this.zzj.zzq().zzif();
            zzhj2.onActivityPaused((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityResumed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzbi();
        zzhj zzhj2 = this.zzj.zzq().zzpu;
        if (zzhj2 != null) {
            this.zzj.zzq().zzif();
            zzhj2.onActivityResumed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivitySaveInstanceState(IObjectWrapper iObjectWrapper, zzp zzp2, long l) throws RemoteException {
        this.zzbi();
        zzhj zzhj2 = this.zzj.zzq().zzpu;
        Bundle bundle = new Bundle();
        if (zzhj2 != null) {
            this.zzj.zzq().zzif();
            zzhj2.onActivitySaveInstanceState((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
        try {
            zzp2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzj.zzab().zzgn().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public void performAction(Bundle bundle, zzp zzp2, long l) throws RemoteException {
        this.zzbi();
        zzp2.zzb(null);
    }

    public void getUserProperties(String string, String string2, boolean bl, zzp zzp2) throws RemoteException {
        this.zzbi();
        this.zzj.zzaa().zza((Runnable)new zzi(this, zzp2, string, string2, bl));
    }

    public void logHealthData(int n, String string, IObjectWrapper iObjectWrapper, IObjectWrapper iObjectWrapper2, IObjectWrapper iObjectWrapper3) throws RemoteException {
        this.zzbi();
        Object object = iObjectWrapper == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        Object object2 = iObjectWrapper2 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
        Object object3 = iObjectWrapper3 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
        this.zzj.zzab().zza(n, true, false, string, object, object2, object3);
    }

    public void setEventInterceptor(zzq zzq2) throws RemoteException {
        this.zzbi();
        zzb zzb2 = new zzb(zzq2);
        zzgp zzgp2 = this.zzj.zzq();
        zzgp2.zzm();
        zzgp2.zzbi();
        zzgp2.zzaa().zza((Runnable)new zzgu(zzgp2, (zzgk)zzb2));
    }

    public void registerOnMeasurementEventListener(zzq zzq2) throws RemoteException {
        this.zzbi();
        zzgn zzgn2 = this.zzdk.get(zzq2.id());
        if (zzgn2 == null) {
            zzgn2 = new zza(zzq2);
            this.zzdk.put(zzq2.id(), zzgn2);
        }
        this.zzj.zzq().zza(zzgn2);
    }

    public void unregisterOnMeasurementEventListener(zzq zzq2) throws RemoteException {
        this.zzbi();
        zzgn zzgn2 = this.zzdk.remove(zzq2.id());
        if (zzgn2 == null) {
            zzgn2 = new zza(zzq2);
        }
        this.zzj.zzq().zzb(zzgn2);
    }

    public void setInstanceIdProvider(zzv zzv2) throws RemoteException {
        this.zzbi();
    }

    public void setConditionalUserProperty(Bundle bundle, long l) throws RemoteException {
        this.zzbi();
        if (bundle == null) {
            this.zzj.zzab().zzgk().zzao("Conditional user property must not be null");
            return;
        }
        this.zzj.zzq().setConditionalUserProperty(bundle, l);
    }

    public void clearConditionalUserProperty(String string, String string2, Bundle bundle) throws RemoteException {
        this.zzbi();
        this.zzj.zzq().clearConditionalUserProperty(string, string2, bundle);
    }

    public void getConditionalUserProperties(String string, String string2, zzp zzp2) throws RemoteException {
        this.zzbi();
        this.zzj.zzaa().zza((Runnable)new zzl(this, zzp2, string, string2));
    }

    public void getTestFlag(zzp zzp2, int n) throws RemoteException {
        this.zzbi();
        switch (n) {
            case 0: {
                this.zzj.zzz().zzb(zzp2, this.zzj.zzq().zzih());
                return;
            }
            case 1: {
                this.zzj.zzz().zza(zzp2, this.zzj.zzq().zzii().longValue());
                return;
            }
            case 2: {
                double d = this.zzj.zzq().zzik();
                zzp zzp3 = zzp2;
                zzjs zzjs2 = this.zzj.zzz();
                Bundle bundle = new Bundle();
                bundle.putDouble("r", d);
                try {
                    zzp3.zzb(bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    zzjs2.zzj.zzab().zzgn().zza("Error returning double value to wrapper", (Object)remoteException);
                    return;
                }
            }
            case 3: {
                this.zzj.zzz().zza(zzp2, this.zzj.zzq().zzij().intValue());
                return;
            }
            case 4: {
                this.zzj.zzz().zza(zzp2, this.zzj.zzq().zzig().booleanValue());
            }
        }
    }

    private final void zza(zzp zzp2, String string) {
        this.zzj.zzz().zzb(zzp2, string);
    }

    public void setDataCollectionEnabled(boolean bl) throws RemoteException {
        this.zzbi();
        this.zzj.zzq().zza(bl);
    }

    public void isDataCollectionEnabled(zzp zzp2) throws RemoteException {
        this.zzbi();
        this.zzj.zzaa().zza((Runnable)new zzk(this, zzp2));
    }

    final class zzb
    implements zzgk {
        private zzq zzdo;

        zzb(zzq zzq2) {
            this.zzdo = zzq2;
        }

        public final void interceptEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zzdo.onEvent(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zzj.zzab().zzgn().zza("Event interceptor threw exception", (Object)remoteException);
                return;
            }
        }
    }

    final class zza
    implements zzgn {
        private zzq zzdo;

        zza(zzq zzq2) {
            this.zzdo = zzq2;
        }

        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zzdo.onEvent(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zzj.zzab().zzgn().zza("Event listener threw exception", (Object)remoteException);
                return;
            }
        }
    }
}

