/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.api;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import java.util.List;
import java.util.Map;

@KeepForSdk
@ShowFirstParty
public class AppMeasurementSdk {
    private final zzdy zza;

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        return this.zza.zza(string);
    }

    @KeepForSdk
    public long generateEventId() {
        return this.zza.zza();
    }

    @KeepForSdk
    @Nullable
    public Bundle performActionWithResponse(@NonNull Bundle bundle) {
        return this.zza.zza(bundle, true);
    }

    @ShowFirstParty
    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @NonNull
    public static AppMeasurementSdk getInstance(@NonNull Context context) {
        return zzdy.zza(context).zzb();
    }

    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @NonNull
    public static AppMeasurementSdk getInstance(@NonNull Context context, @NonNull String string, @NonNull String string2, @Nullable String string3, @NonNull Bundle bundle) {
        return zzdy.zza(context, string, string2, string3, bundle).zzb();
    }

    @KeepForSdk
    @Nullable
    public String getAppIdOrigin() {
        return this.zza.zzd();
    }

    @Nullable
    @KeepForSdk
    public String getAppInstanceId() {
        return this.zza.zzf();
    }

    @Nullable
    @KeepForSdk
    public String getCurrentScreenClass() {
        return this.zza.zzg();
    }

    @Nullable
    @KeepForSdk
    public String getCurrentScreenName() {
        return this.zza.zzh();
    }

    @Nullable
    @KeepForSdk
    public String getGmpAppId() {
        return this.zza.zzi();
    }

    @KeepForSdk
    @WorkerThread
    @NonNull
    public List<Bundle> getConditionalUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=23L) String string2) {
        return this.zza.zza(string, string2);
    }

    @KeepForSdk
    @WorkerThread
    @NonNull
    public Map<String, Object> getUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=24L) String string2, boolean bl) {
        return this.zza.zza(string, string2, bl);
    }

    public AppMeasurementSdk(zzdy zzdy2) {
        this.zza = zzdy2;
    }

    @KeepForSdk
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zza.zzb(string);
    }

    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zza.zza(string, string2, bundle);
    }

    @KeepForSdk
    public void endAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zza.zzc(string);
    }

    @KeepForSdk
    public void logEvent(@NonNull String string, @NonNull String string2, @Nullable Bundle bundle) {
        this.zza.zzb(string, string2, bundle);
    }

    @KeepForSdk
    public void logEventNoInterceptor(@NonNull String string, @NonNull String string2, @Nullable Bundle bundle, long l) {
        this.zza.zza(string, string2, bundle, l);
    }

    @KeepForSdk
    public void performAction(@NonNull Bundle bundle) {
        this.zza.zza(bundle, false);
    }

    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(@NonNull OnEventListener onEventListener) {
        this.zza.zza(onEventListener);
    }

    @KeepForSdk
    public void setConditionalUserProperty(@NonNull Bundle bundle) {
        this.zza.zza(bundle);
    }

    @KeepForSdk
    public void setConsent(@NonNull Bundle bundle) {
        this.zza.zzb(bundle);
    }

    @KeepForSdk
    public void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        this.zza.zza(activity, string, string2);
    }

    public final void zza(boolean bl) {
        this.zza.zza(bl);
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(@NonNull EventInterceptor eventInterceptor) {
        this.zza.zza(eventInterceptor);
    }

    @KeepForSdk
    public void setMeasurementEnabled(@Nullable Boolean bl) {
        this.zza.zza(bl);
    }

    @KeepForSdk
    public void setMeasurementEnabled(boolean bl) {
        this.zza.zza((Boolean)bl);
    }

    @KeepForSdk
    public void setUserProperty(@NonNull String string, @NonNull String string2, @NonNull Object object) {
        Object object2 = object;
        String string3 = string2;
        this.zza.zza(string, string3, object2, true);
    }

    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(@NonNull OnEventListener onEventListener) {
        this.zza.zzb(onEventListener);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzjl {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(@NonNull String var1, @NonNull String var2, @NonNull Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzjm {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(@NonNull String var1, @NonNull String var2, @NonNull Bundle var3, long var4);
    }

    @KeepForSdk
    public static final class ConditionalUserProperty {
        @KeepForSdk
        @NonNull
        public static final String ORIGIN = "origin";
        @KeepForSdk
        @NonNull
        public static final String NAME = "name";
        @KeepForSdk
        @NonNull
        public static final String VALUE = "value";
        @KeepForSdk
        @NonNull
        public static final String TRIGGER_EVENT_NAME = "trigger_event_name";
        @KeepForSdk
        @NonNull
        public static final String TRIGGER_TIMEOUT = "trigger_timeout";
        @KeepForSdk
        @NonNull
        public static final String TIMED_OUT_EVENT_NAME = "timed_out_event_name";
        @KeepForSdk
        @NonNull
        public static final String TIMED_OUT_EVENT_PARAMS = "timed_out_event_params";
        @KeepForSdk
        @NonNull
        public static final String TRIGGERED_EVENT_NAME = "triggered_event_name";
        @KeepForSdk
        @NonNull
        public static final String TRIGGERED_EVENT_PARAMS = "triggered_event_params";
        @KeepForSdk
        @NonNull
        public static final String TIME_TO_LIVE = "time_to_live";
        @KeepForSdk
        @NonNull
        public static final String EXPIRED_EVENT_NAME = "expired_event_name";
        @KeepForSdk
        @NonNull
        public static final String EXPIRED_EVENT_PARAMS = "expired_event_params";
        @KeepForSdk
        @NonNull
        public static final String CREATION_TIMESTAMP = "creation_timestamp";
        @KeepForSdk
        @NonNull
        public static final String ACTIVE = "active";
        @KeepForSdk
        @NonNull
        public static final String TRIGGERED_TIMESTAMP = "triggered_timestamp";

        private ConditionalUserProperty() {
        }
    }
}

