/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.NetworkOnMainThreadException;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzbx;
import com.google.android.gms.internal.measurement.zzbz;
import com.google.android.gms.internal.measurement.zzcb;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzci;
import com.google.android.gms.internal.measurement.zzcn;
import com.google.android.gms.internal.measurement.zzco;
import com.google.android.gms.internal.measurement.zzcp;
import com.google.android.gms.internal.measurement.zzcq;
import com.google.android.gms.internal.measurement.zzcr;
import com.google.android.gms.internal.measurement.zzcs;
import com.google.android.gms.internal.measurement.zzct;
import com.google.android.gms.internal.measurement.zzcu;
import com.google.android.gms.internal.measurement.zzcv;
import com.google.android.gms.internal.measurement.zzcw;
import com.google.android.gms.internal.measurement.zzcx;
import com.google.android.gms.internal.measurement.zzcy;
import com.google.android.gms.internal.measurement.zzcz;
import com.google.android.gms.internal.measurement.zzda;
import com.google.android.gms.internal.measurement.zzdb;
import com.google.android.gms.internal.measurement.zzdc;
import com.google.android.gms.internal.measurement.zzdd;
import com.google.android.gms.internal.measurement.zzde;
import com.google.android.gms.internal.measurement.zzdf;
import com.google.android.gms.internal.measurement.zzdg;
import com.google.android.gms.internal.measurement.zzdh;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzdk;
import com.google.android.gms.internal.measurement.zzdl;
import com.google.android.gms.internal.measurement.zzdm;
import com.google.android.gms.internal.measurement.zzdn;
import com.google.android.gms.internal.measurement.zzdo;
import com.google.android.gms.internal.measurement.zzdp;
import com.google.android.gms.internal.measurement.zzdq;
import com.google.android.gms.internal.measurement.zzdr;
import com.google.android.gms.internal.measurement.zzds;
import com.google.android.gms.internal.measurement.zzdt;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzdv;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzio;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class zzef {
    private static volatile zzef zzc;
    private final String zzd;
    protected final Clock zza;
    protected final ExecutorService zzb;
    private final AppMeasurementSdk zze;
    @GuardedBy(value="listenerList")
    private final List zzf;
    private int zzg;
    private boolean zzh;
    private final String zzi;
    private volatile zzcc zzj;

    public final int zza(String string) {
        zzbz zzbz2 = new zzbz();
        zzef zzef2 = n;
        zzef2.zzV(new zzdj(zzef2, string, zzbz2));
        Integer n = (Integer)zzbz.zzf((Bundle)zzbz2.zzb(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long zzb() {
        Object object = new zzbz();
        zzef zzef2 = this;
        zzef2.zzV(new zzdc(zzef2, (zzbz)object));
        object = object.zzc(500L);
        if (object != null) return (Long)object;
        return new Random(System.nanoTime() ^ this.zza.currentTimeMillis()).nextLong() + (long)(++this.zzg);
    }

    public final Bundle zzc(Bundle bundle, boolean bl) {
        zzbz zzbz2 = new zzbz();
        zzef zzef2 = this;
        zzef2.zzV(new zzdh(zzef2, bundle, zzbz2));
        if (bl) {
            return zzbz2.zzb(5000L);
        }
        return null;
    }

    public final AppMeasurementSdk zzd() {
        return this.zze;
    }

    static /* bridge */ /* synthetic */ zzcc zze(zzef zzef2) {
        return zzef2.zzj;
    }

    protected final zzcc zzf(Context context, boolean bl) {
        try {
            context = DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService");
            zzef zzef2 = zzcb.asInterface((IBinder)context);
            return zzef2;
        }
        catch (DynamiteModule.LoadingException loadingException) {
            zzef2.zzT((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzef zzg(Context context, String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzc != null) return zzc;
        Class<zzef> clazz = zzef.class;
        synchronized (clazz) {
            zzef zzef2 = zzc;
            if (zzef2 != null) return zzc;
            zzc = new zzef(context, string, string2, string3, bundle);
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final Long zzh() {
        zzbz zzbz2 = new zzbz();
        zzef zzef2 = this;
        zzef2.zzV(new zzdl(zzef2, zzbz2));
        return zzbz2.zzc(120000L);
    }

    public final Object zzi(int n) {
        zzbz zzbz2 = new zzbz();
        zzef zzef2 = this;
        zzef2.zzV(new zzdm(zzef2, zzbz2, n));
        return zzbz.zzf((Bundle)zzbz2.zzb(15000L), Object.class);
    }

    static /* bridge */ /* synthetic */ String zzj(zzef zzef2) {
        return zzef2.zzd;
    }

    public final String zzk() {
        return this.zzi;
    }

    @WorkerThread
    public final String zzl() {
        zzbz zzbz2 = new zzbz();
        zzef zzef2 = this;
        zzef2.zzV(new zzdk(zzef2, zzbz2));
        return zzbz2.zzd(120000L);
    }

    public final String zzm() {
        zzbz zzbz2 = new zzbz();
        zzef zzef2 = this;
        zzef2.zzV(new zzdb(zzef2, zzbz2));
        return zzbz2.zzd(50L);
    }

    public final String zzn() {
        zzbz zzbz2 = new zzbz();
        zzef zzef2 = this;
        zzef2.zzV(new zzde(zzef2, zzbz2));
        return zzbz2.zzd(500L);
    }

    public final String zzo() {
        zzbz zzbz2 = new zzbz();
        zzef zzef2 = this;
        zzef2.zzV(new zzdd(zzef2, zzbz2));
        return zzbz2.zzd(500L);
    }

    public final String zzp() {
        zzbz zzbz2 = new zzbz();
        zzef zzef2 = this;
        zzef2.zzV(new zzda(zzef2, zzbz2));
        return zzbz2.zzd(500L);
    }

    public final List zzq(String string, String string2) {
        zzbz zzbz2 = new zzbz();
        zzef zzef2 = list;
        zzef2.zzV(new zzcp(zzef2, string, string2, zzbz2));
        List list = (List)zzbz.zzf((Bundle)zzbz2.zzb(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final Map zzr(String hashMap, String object, boolean bl) {
        Object object2 = new zzbz();
        zzef zzef2 = zzef3;
        zzef2.zzV(new zzdf(zzef2, (String)((Object)hashMap), (String)object, bl, (zzbz)object2));
        zzef zzef3 = object2.zzb(5000L);
        if (zzef3 == null || zzef3.size() == 0) {
            return Collections.emptyMap();
        }
        hashMap = new HashMap<String, zzbz>(zzef3.size());
        for (String string : zzef3.keySet()) {
            object2 = zzef3.get(string);
            if (!(object2 instanceof Double) && !(object2 instanceof Long) && !(object2 instanceof String)) continue;
            hashMap.put(string, (zzbz)object2);
        }
        return hashMap;
    }

    static /* bridge */ /* synthetic */ void zzs(zzef zzef2, zzcc zzcc2) {
        zzef2.zzj = zzcc2;
    }

    static /* bridge */ /* synthetic */ void zzt(zzef zzef2, Exception exception, boolean bl, boolean bl2) {
        zzef2.zzT(exception, bl, bl2);
    }

    static /* bridge */ /* synthetic */ void zzu(zzef zzef2, zzdu zzdu2) {
        zzef2.zzV(zzdu2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected zzef(Context context, String object, String string, String string2, Bundle bundle) {
        block8: {
            block7: {
                this.zzd = object == null || !this.zzW(string, string2) ? "FA" : object;
                this.zza = DefaultClock.getInstance();
                zzbx.zza();
                object = new zzdi(this);
                ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)object);
                threadPoolExecutor.allowCoreThreadTimeOut(true);
                this.zzb = Executors.unconfigurableExecutorService(threadPoolExecutor);
                this.zze = new AppMeasurementSdk(this);
                this.zzf = new ArrayList();
                try {
                    object = zzfv.zza((Context)context);
                    object = zzio.zzc((Context)context, (String)"google_app_id", (String)object);
                }
                catch (IllegalStateException illegalStateException) {}
                if (object != null && !this.zzS()) {
                    this.zzi = null;
                    this.zzh = true;
                    Log.w((String)this.zzd, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
                    return;
                }
                if (this.zzW(string, string2)) break block7;
                this.zzi = "fa";
                if (string != null && string2 != null) {
                    Log.v((String)this.zzd, (String)"Deferring to Google Analytics for Firebase for event data collection. https://firebase.google.com/docs/analytics");
                    break block8;
                } else {
                    boolean bl;
                    boolean bl2 = string == null;
                    if (bl2 ^ (bl = string2 == null)) {
                        Log.w((String)this.zzd, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
                    }
                }
                break block8;
            }
            this.zzi = string;
        }
        zzef zzef2 = this;
        zzef2.zzV(new zzcx(zzef2, string, string2, context, bundle));
        context = (Application)context.getApplicationContext();
        if (context == null) {
            Log.w((String)this.zzd, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzee(this));
    }

    private final void zzT(Exception exception, boolean bl, boolean bl2) {
        this.zzh |= bl;
        if (bl) {
            Log.w((String)this.zzd, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zzB(5, string, exception, null, null);
        }
        Log.w((String)this.zzd, (String)string, (Throwable)exception);
    }

    public final void zzv(String string) {
        zzef zzef2 = this;
        zzef2.zzV(new zzcy(zzef2, string));
    }

    public final void zzw(String string, String string2, Bundle bundle) {
        zzef zzef2 = this;
        zzef2.zzV(new zzco(zzef2, string, string2, bundle));
    }

    public final void zzx(String string) {
        zzef zzef2 = this;
        zzef2.zzV(new zzcz(zzef2, string));
    }

    public final void zzy(@NonNull String string, Bundle bundle) {
        this.zzU(null, string, bundle, false, true, null);
    }

    public final void zzz(String string, String string2, Bundle bundle) {
        this.zzU(string, string2, bundle, true, true, null);
    }

    public final void zzA(String string, String string2, Bundle bundle, long l) {
        this.zzU(string, string2, bundle, true, false, l);
    }

    private final void zzU(String string, String string2, Bundle bundle, boolean bl, boolean bl2, Long l) {
        zzef zzef2 = this;
        zzef2.zzV(new zzds(zzef2, l, string, string2, bundle, bl, bl2));
    }

    public final void zzB(int n, String string, Object object, Object object2, Object object3) {
        zzef zzef2 = this;
        zzef2.zzV(new zzdg(zzef2, false, 5, string, object, null, null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzC(zzhe zzhe2) {
        int n;
        Preconditions.checkNotNull((Object)zzhe2);
        List list = this.zzf;
        // MONITORENTER : list
        for (int i = 0; i < (n = this.zzf.size()); ++i) {
            n = zzhe2.equals(((Pair)this.zzf.get((int)i)).first) ? 1 : 0;
            if (n == 0) continue;
            Log.w((String)this.zzd, (String)"OnEventListener already registered.");
            // MONITOREXIT : list
            return;
        }
        zzdw zzdw2 = new zzdw(zzhe2);
        this.zzf.add(new Pair((Object)zzhe2, (Object)zzdw2));
        // MONITOREXIT : list
        if (this.zzj != null) {
            try {
                this.zzj.registerOnMeasurementEventListener((zzci)zzdw2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to register event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzef zzef2 = this;
        zzef2.zzV(new zzdq(zzef2, zzdw2));
    }

    public final void zzD() {
        zzef zzef2 = this;
        zzef2.zzV(new zzcv(zzef2));
    }

    private final void zzV(zzdu zzdu2) {
        this.zzb.execute(zzdu2);
    }

    public final void zzE(Bundle bundle) {
        zzef zzef2 = this;
        zzef2.zzV(new zzcn(zzef2, bundle));
    }

    public final void zzF(Bundle bundle) {
        zzef zzef2 = this;
        zzef2.zzV(new zzct(zzef2, bundle));
    }

    public final void zzG(Bundle bundle) {
        zzef zzef2 = this;
        zzef2.zzV(new zzcu(zzef2, bundle));
    }

    public final void zzH(Activity activity, String string, String string2) {
        zzef zzef2 = this;
        zzef2.zzV(new zzcr(zzef2, activity, string, string2));
    }

    public final void zzI(boolean bl) {
        zzef zzef2 = this;
        zzef2.zzV(new zzdn(zzef2, bl));
    }

    public final void zzJ(Bundle bundle) {
        zzef zzef2 = this;
        zzef2.zzV(new zzdo(zzef2, bundle));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzK(zzhd zzhd2) {
        zzdv zzdv2 = new zzdv(zzhd2);
        if (this.zzj != null) {
            try {
                this.zzj.setEventInterceptor((zzci)zzdv2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to set event interceptor on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzef zzef2 = this;
        zzef2.zzV(new zzdp(zzef2, zzdv2));
    }

    public final void zzL(Boolean bl) {
        zzef zzef2 = this;
        zzef2.zzV(new zzcs(zzef2, bl));
    }

    public final void zzM(long l) {
        zzef zzef2 = this;
        zzef2.zzV(new zzcw(zzef2, l));
    }

    public final void zzN(String string) {
        zzef zzef2 = this;
        zzef2.zzV(new zzcq(zzef2, string));
    }

    public final void zzO(String string, String string2, Object object, boolean bl) {
        zzef zzef2 = this;
        zzef2.zzV(new zzdt(zzef2, string, string2, object, bl));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzP(zzhe object) {
        block8: {
            int n;
            Preconditions.checkNotNull((Object)object);
            List list = this.zzf;
            // MONITORENTER : list
            for (int i = 0; i < (n = this.zzf.size()); ++i) {
                n = object.equals(((Pair)this.zzf.get((int)i)).first) ? 1 : 0;
                if (n == 0) continue;
                object = (Pair)this.zzf.get(i);
                break block8;
            }
            object = null;
        }
        if (object == null) {
            Log.w((String)this.zzd, (String)"OnEventListener had not been registered.");
            // MONITOREXIT : list
            return;
        }
        this.zzf.remove(object);
        object = (zzdw)((Object)object.second);
        // MONITOREXIT : list
        if (this.zzj != null) {
            try {
                this.zzj.unregisterOnMeasurementEventListener((zzci)object);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to unregister event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzef zzef2 = this;
        zzef2.zzV(new zzdr(zzef2, (zzdw)((Object)object)));
    }

    static /* bridge */ /* synthetic */ boolean zzQ(zzef zzef2) {
        return zzef2.zzh;
    }

    static /* bridge */ /* synthetic */ boolean zzR(zzef zzef2, String string, String string2) {
        return zzef2.zzW(string, string2);
    }

    private final boolean zzW(String string, String string2) {
        return string2 != null && string != null && !this.zzS();
    }

    protected final boolean zzS() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

