/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjh;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzag
extends zzja {
    private @Nullable Boolean zza;
    private @Nullable String zzb;
    private zzai zzc = new zzaf();
    private @MonotonicNonNull Boolean zzd;

    @WorkerThread
    public final double zza(@Nullable String string, zzfz<Double> zzfz2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzfz2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzfz2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfz2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzfz2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfz2.zza(null);
        }
    }

    final int zza(@Size(min=1L) String string) {
        return this.zza(string, zzbh.zzaj, 500, 2000);
    }

    final int zza(@Nullable String string, boolean bl) {
        if (bl) {
            return this.zza(string, zzbh.zzat, 100, 500);
        }
        return 500;
    }

    final int zzb(@Nullable String string, boolean bl) {
        return Math.max(this.zza(string, bl), 256);
    }

    public final int zzc() {
        if (((zzja)this).zzq().zza(201500000, true)) {
            return 100;
        }
        return 25;
    }

    public final int zzb(@Size(min=1L) String string) {
        return this.zza(string, zzbh.zzak, 25, 100);
    }

    @WorkerThread
    public final int zzc(@Size(min=1L) String string) {
        return this.zzb(string, zzbh.zzo);
    }

    @WorkerThread
    public final int zzb(@Nullable String string, zzfz<Integer> zzfz2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzfz2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzfz2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfz2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzfz2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfz2.zza(null);
        }
    }

    @WorkerThread
    public final int zza(@Nullable String string, zzfz<Integer> zzfz2, int n, int n2) {
        return Math.max(Math.min(this.zzb(string, zzfz2), n2), n);
    }

    @WorkerThread
    final long zzd(String string) {
        return this.zzc(string, zzbh.zza);
    }

    public static long zzg() {
        return zzbh.zzd.zza(null);
    }

    public static long zzh() {
        return ((Integer)zzbh.zzk.zza(null)).intValue();
    }

    public static long zzm() {
        return zzbh.zzae.zza(null);
    }

    @WorkerThread
    public final long zzc(@Nullable String string, zzfz<Long> zzfz2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzfz2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzfz2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfz2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzfz2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfz2.zza(null);
        }
    }

    public static long zzn() {
        return zzbh.zzz.zza(null);
    }

    @VisibleForTesting
    private final @Nullable Bundle zzaa() {
        try {
            if (((zzja)this).zza().getPackageManager() == null) {
                ((zzja)this).zzj().zzg().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzja)this).zza()).getApplicationInfo(((zzja)this).zza().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzja)this).zzj().zzg().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzja)this).zzj().zzg().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public final zzjh zzc(String string, boolean bl) {
        Object object;
        Object object2;
        String string2 = string;
        zzag zzag2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzag2.zzaa();
        if (bundle == null) {
            ((zzja)zzag2).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            object2 = null;
        } else {
            object2 = object = bundle.get(string2);
        }
        if (object2 == null) {
            return zzjh.zza;
        }
        if (Boolean.TRUE.equals(object)) {
            return zzjh.zzd;
        }
        if (Boolean.FALSE.equals(object)) {
            return zzjh.zzc;
        }
        if (bl && "eu_consent_policy".equals(object)) {
            return zzjh.zzb;
        }
        ((zzja)this).zzj().zzu().zza("Invalid manifest metadata for", string);
        return zzjh.zza;
    }

    @VisibleForTesting
    final @Nullable Boolean zze(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzaa();
        if (bundle == null) {
            ((zzja)this).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    public final String zzo() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzp() {
        return this.zza("debug.deferred.deeplink", "");
    }

    @WorkerThread
    public final String zzd(@Nullable String string, zzfz<String> zzfz2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzfz2.zza(null);
        }
        return zzfz2.zza(this.zzc.zza(string, zzfz2.zza()));
    }

    public final @Nullable String zzu() {
        return this.zzb;
    }

    @WorkerThread
    final String zzf(String string) {
        return this.zzd(string, zzbh.zzan);
    }

    private final String zza(String string, String string2) {
        try {
            String string3 = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
            Preconditions.checkNotNull((Object)string3);
            return string3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzja)this).zzj().zzg().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzja)this).zzj().zzg().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzja)this).zzj().zzg().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzja)this).zzj().zzg().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    @VisibleForTesting
    final @Nullable List<String> zzg(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzag zzag2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzag2.zzaa();
        if (bundle == null) {
            ((zzja)zzag2).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzja)this).zza().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzja)this).zzj().zzg().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    zzag(zzhy zzhy2) {
        super(zzhy2);
    }

    final void zza(zzai zzai2) {
        this.zzc = zzai2;
    }

    public final void zzh(@Nullable String string) {
        this.zzb = string;
    }

    public final boolean zzv() {
        Boolean bl = this.zze("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    @WorkerThread
    final boolean zzi(String string) {
        return this.zzf(string, zzbh.zzam);
    }

    public final boolean zza(zzfz<Boolean> zzfz2) {
        zzfz<Boolean> zzfz3 = zzfz2;
        return this.zzf(null, zzfz3);
    }

    public final boolean zze(@Nullable String string, zzfz<Boolean> zzfz2) {
        return this.zzf(string, zzfz2);
    }

    @WorkerThread
    public final boolean zzf(@Nullable String string, zzfz<Boolean> zzfz2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzfz2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzfz2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfz2.zza(null);
        }
        return zzfz2.zza("1".equals(string2));
    }

    public final boolean zzj(String string) {
        return "1".equals(this.zzc.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zzw() {
        Boolean bl = this.zze("google_analytics_automatic_screen_reporting_enabled");
        return bl == null || bl != false;
    }

    public final boolean zzx() {
        Boolean bl = this.zze("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final boolean zzk(String string) {
        return "1".equals(this.zzc.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzy() {
        if (this.zza == null) {
            this.zza = this.zze("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzu.zzag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"this.isMainProcess"})
    public final boolean zzz() {
        if (this.zzd == null) {
            zzag zzag2 = this;
            synchronized (zzag2) {
                if (this.zzd == null) {
                    ApplicationInfo applicationInfo = ((zzja)this).zza().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzd = string2 != null && string2.equals(string);
                    }
                    if (this.zzd == null) {
                        this.zzd = Boolean.TRUE;
                        ((zzja)this).zzj().zzg().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzd;
    }
}

