/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzld;
import com.google.android.gms.measurement.internal.zzmb;
import com.google.android.gms.measurement.internal.zzmd;
import com.google.android.gms.measurement.internal.zzme;
import com.google.android.gms.measurement.internal.zzmf;
import com.google.android.gms.measurement.internal.zzmg;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzmc
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile @Nullable zzga zzc;
    final /* synthetic */ zzld zza;

    static /* bridge */ /* synthetic */ void zza(zzmc zzmc2, boolean bl) {
        zzmc2.zzb = false;
    }

    protected zzmc(zzld zzld2) {
        this.zza = zzld2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzim)this.zza).zzt();
        Context context = ((zzim)this.zza).zza();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzmc zzmc2 = this;
        synchronized (zzmc2) {
            if (this.zzb) {
                ((zzim)this.zza).zzj().zzp().zza("Connection attempt already in progress");
                return;
            }
            ((zzim)this.zza).zzj().zzp().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzld.zzb(this.zza), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza() {
        ((zzim)this.zza).zzt();
        Context context = ((zzim)this.zza).zza();
        zzmc zzmc2 = this;
        synchronized (zzmc2) {
            if (this.zzb) {
                ((zzim)this.zza).zzj().zzp().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzim)this.zza).zzj().zzp().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzga(context, Looper.getMainLooper(), this, this);
            ((zzim)this.zza).zzj().zzp().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzmc zzmc2 = this;
        synchronized (zzmc2) {
            try {
                Preconditions.checkNotNull((Object)((Object)this.zzc));
                zzfs zzfs2 = (zzfs)this.zzc.getService();
                ((zzim)this.zza).zzl().zzb(new zzmd(this, zzfs2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzfz zzfz2 = this.zza.zzu.zzm();
        if (zzfz2 != null) {
            zzfz2.zzu().zza("Service connection failed", connectionResult);
        }
        zzmc zzmc2 = this;
        synchronized (zzmc2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzim)this.zza).zzl().zzb(new zzmf(this));
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzim)this.zza).zzj().zzc().zza("Service connection suspended");
        ((zzim)this.zza).zzl().zzb(new zzmg(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, @Nullable IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzmc zzmc2 = this;
        synchronized (zzmc2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzim)this.zza).zzj().zzg().zza("Service connected with null binder");
                return;
            }
            zzfs zzfs2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzfs2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzfs ? (zzfs)iInterface : new zzfu(iBinder2));
                    ((zzim)this.zza).zzj().zzp().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzim)this.zza).zzj().zzg().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzim)this.zza).zzj().zzg().zza("Service connect failed to get IMeasurementService");
            }
            if (zzfs2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzim)this.zza).zza(), (ServiceConnection)zzld.zzb(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzfs2;
                ((zzim)this.zza).zzl().zzb(new zzmb(this, (zzfs)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzim)this.zza).zzj().zzc().zza("Service disconnected");
        ((zzim)this.zza).zzl().zzb(new zzme(this, componentName));
    }
}

