/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.measurement.zzgu;
import com.google.android.gms.internal.measurement.zzgv;
import com.google.android.gms.internal.measurement.zzgx;
import com.google.android.gms.internal.measurement.zzgy;
import com.google.android.gms.internal.measurement.zzgz;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzgs
implements zzgz {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map<Uri, zzgs> zza = new ArrayMap();
    private static final String[] zzb = new String[]{"key", "value"};
    private final ContentResolver zzc;
    private final Uri zzd;
    private final Runnable zze;
    private final ContentObserver zzf = new zzgu(this, null);
    private final Object zzg = new Object();
    private volatile Map<String, String> zzh;
    @GuardedBy(value="this")
    private final List<zzgx> zzi = new ArrayList<zzgx>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzgs zza(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        Class<zzgs> clazz = zzgs.class;
        synchronized (zzgs.class) {
            zzgs zzgs2 = zza.get(uri);
            if (zzgs2 == null) {
                try {
                    zzgs2 = new zzgs(contentResolver, uri, runnable);
                    zza.put(uri, zzgs2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzgs2;
        }
    }

    @Override
    public final /* synthetic */ Object zza(String string) {
        String string2 = string;
        return this.zza().get(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zza() {
        Map<String, String> map = this.zzh;
        if (map == null) {
            Object object = this.zzg;
            synchronized (object) {
                map = this.zzh;
                if (map == null) {
                    this.zzh = map = this.zze();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    final /* synthetic */ Map zzb() {
        Cursor cursor = this.zzc.query(this.zzd, zzb, null, null, null);
        if (cursor == null) {
            return Collections.emptyMap();
        }
        try {
            Object object;
            int n = cursor.getCount();
            if (n == 0) {
                Map map = Collections.emptyMap();
                return map;
            }
            Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
            while (cursor.moveToNext()) {
                object.put(cursor.getString(0), cursor.getString(1));
            }
            Object object3 = object;
            return object3;
        }
        finally {
            cursor.close();
        }
    }

    @Nullable
    private final Map<String, String> zze() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            zzgs zzgs2 = this;
            Map map = (Map)zzgy.zza(new zzgv(zzgs2));
            return map;
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLdr", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private zzgs(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        Preconditions.checkNotNull((Object)contentResolver);
        Preconditions.checkNotNull((Object)uri);
        this.zzc = contentResolver;
        this.zzd = uri;
        this.zze = runnable;
        contentResolver.registerContentObserver(uri, false, this.zzf);
    }

    static synchronized void zzc() {
        for (zzgs zzgs2 : zza.values()) {
            zzgs2.zzc.unregisterContentObserver(zzgs2.zzf);
        }
        zza.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd() {
        zzgs zzgs2;
        Object object = this.zzg;
        synchronized (object) {
            this.zzh = null;
            this.zze.run();
        }
        zzgs zzgs3 = zzgs2 = this;
        synchronized (zzgs2) {
            Iterator<zzgx> iterator = zzgs2.zzi.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }
}

