/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzgy
extends zzic {
    private static final AtomicLong zza = new AtomicLong(Long.MIN_VALUE);
    @Nullable
    private zzhc zzb;
    @Nullable
    private zzhc zzc;
    private final PriorityBlockingQueue<zzhd<?>> zzd;
    private final BlockingQueue<zzhd<?>> zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Thread.UncaughtExceptionHandler zzg;
    private final Object zzh = new Object();
    private final Semaphore zzi = new Semaphore(2);
    private volatile boolean zzj;

    static /* bridge */ /* synthetic */ zzhc zza(zzgy zzgy2) {
        return zzgy2.zzc;
    }

    static /* bridge */ /* synthetic */ zzhc zzb(zzgy zzgy2) {
        return zzgy2.zzb;
    }

    static /* bridge */ /* synthetic */ Object zzc(zzgy zzgy2) {
        return zzgy2.zzh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzid)this).zzl().zzb(runnable);
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                String string2 = string;
                ((zzid)this).zzj().zzu().zza("Interrupted waiting for " + string2);
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = string;
            ((zzid)this).zzj().zzu().zza("Timed out waiting for " + string3);
        }
        return (T)atomicReference2;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzab();
        Preconditions.checkNotNull(callable);
        zzhd zzhd2 = new zzhd(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzb) {
            if (!this.zzd.isEmpty()) {
                ((zzid)this).zzj().zzu().zza("Callable skipped the worker queue.");
            }
            zzhd2.run();
        } else {
            this.zza(zzhd2);
        }
        return zzhd2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzab();
        Preconditions.checkNotNull(callable);
        zzhd zzhd2 = new zzhd(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzb) {
            zzhd2.run();
        } else {
            this.zza(zzhd2);
        }
        return zzhd2;
    }

    static /* bridge */ /* synthetic */ Semaphore zzd(zzgy zzgy2) {
        return zzgy2.zzi;
    }

    static /* bridge */ /* synthetic */ AtomicLong zzc() {
        return zza;
    }

    static /* bridge */ /* synthetic */ void zza(zzgy zzgy2, zzhc zzhc2) {
        zzgy2.zzc = null;
    }

    static /* bridge */ /* synthetic */ void zzb(zzgy zzgy2, zzhc zzhc2) {
        zzgy2.zzb = null;
    }

    zzgy(zzhf zzhf2) {
        super(zzhf2);
        this.zzd = new PriorityBlockingQueue();
        this.zze = new LinkedBlockingQueue();
        this.zzf = new zzha(this, "Thread death: Uncaught exception on worker thread");
        this.zzg = new zzha(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    public final void zzr() {
        if (Thread.currentThread() != this.zzc) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    @Override
    public final void zzt() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzhd<?> zzhd2) {
        Object object = this.zzh;
        synchronized (object) {
            this.zzd.add(zzhd2);
            if (this.zzb == null) {
                this.zzb = new zzhc(this, "Measurement Worker", this.zzd);
                this.zzb.setUncaughtExceptionHandler(this.zzf);
                this.zzb.start();
            } else {
                this.zzb.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzab();
        Preconditions.checkNotNull((Object)runnable);
        zzhd zzhd2 = new zzhd(this, runnable, false, "Task exception on network thread");
        zzgy zzgy2 = this;
        Object object = zzgy2.zzh;
        synchronized (object) {
            zzgy2.zze.add(zzhd2);
            if (zzgy2.zzc == null) {
                zzgy2.zzc = new zzhc(zzgy2, "Measurement Network", zzgy2.zze);
                zzgy2.zzc.setUncaughtExceptionHandler(zzgy2.zzg);
                zzgy2.zzc.start();
            } else {
                zzgy2.zzc.zza();
            }
            return;
        }
    }

    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzab();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzhd(this, runnable, false, "Task exception on worker thread"));
    }

    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzab();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzhd(this, runnable, true, "Task exception on worker thread"));
    }

    static /* bridge */ /* synthetic */ boolean zze(zzgy zzgy2) {
        return zzgy2.zzj;
    }

    public final boolean zzg() {
        return Thread.currentThread() == this.zzb;
    }

    @Override
    protected final boolean zzo() {
        return false;
    }
}

