/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzob;
import com.google.android.gms.internal.measurement.zzok;
import com.google.android.gms.internal.measurement.zzpf;
import com.google.android.gms.internal.measurement.zzpi;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzlm;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzs;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzij
extends zzf {
    @VisibleForTesting
    protected zzii zza;
    private zzhe zzd;
    private final Set zze;
    private boolean zzf;
    private final AtomicReference zzg;
    private final Object zzh;
    @GuardedBy(value="consentLock")
    private zzai zzi;
    @GuardedBy(value="consentLock")
    private int zzj;
    private final AtomicLong zzk;
    private long zzl;
    private int zzm;
    final zzs zzb;
    @VisibleForTesting
    protected boolean zzc;
    private final zzlm zzn;

    public final int zzh(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzs.zzf();
        return 25;
    }

    public final Boolean zzi() {
        AtomicReference atomicReference = new AtomicReference();
        zzgz zzgz2 = this.zzs;
        zzgz2 = ((zzge)zzgz2).zzaz();
        zzhv zzhv2 = new zzhv(this, atomicReference);
        return (Boolean)((zzgb)zzgz2).zzd(atomicReference, 15000L, "boolean test flag value", zzhv2);
    }

    public final Double zzj() {
        AtomicReference atomicReference = new AtomicReference();
        zzgz zzgz2 = this.zzs;
        zzgz2 = ((zzge)zzgz2).zzaz();
        zzib zzib2 = new zzib(this, atomicReference);
        return (Double)((zzgb)zzgz2).zzd(atomicReference, 15000L, "double test flag value", zzib2);
    }

    public final Integer zzl() {
        AtomicReference atomicReference = new AtomicReference();
        zzgz zzgz2 = this.zzs;
        zzgz2 = ((zzge)zzgz2).zzaz();
        zzia zzia2 = new zzia(this, atomicReference);
        return (Integer)((zzgb)zzgz2).zzd(atomicReference, 15000L, "int test flag value", zzia2);
    }

    public final Long zzm() {
        AtomicReference atomicReference = new AtomicReference();
        zzgz zzgz2 = this.zzs;
        zzgz2 = ((zzge)zzgz2).zzaz();
        zzhz zzhz2 = new zzhz(this, atomicReference);
        return (Long)((zzgb)zzgz2).zzd(atomicReference, 15000L, "long test flag value", zzhz2);
    }

    public final String zzo() {
        return (String)this.zzg.get();
    }

    public final String zzp() {
        zziq zziq2 = ((zzij)((Object)zziq2)).zzs.zzs().zzi();
        if (zziq2 != null) {
            return zziq2.zzb;
        }
        return null;
    }

    public final String zzq() {
        zziq zziq2 = ((zzij)((Object)zziq2)).zzs.zzs().zzi();
        if (zziq2 != null) {
            return zziq2.zza;
        }
        return null;
    }

    public final String zzr() {
        AtomicReference atomicReference = new AtomicReference();
        zzgz zzgz2 = this.zzs;
        zzgz2 = ((zzge)zzgz2).zzaz();
        zzhy zzhy2 = new zzhy(this, atomicReference);
        return (String)((zzgb)zzgz2).zzd(atomicReference, 15000L, "String test flag value", zzhy2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList zzs(String object, String string) {
        if (((zzgx)((Object)this)).zzs.zzaz().zzs()) {
            ((zzgx)((Object)this)).zzs.zzay().zzd().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList(0);
        }
        ((zzgx)((Object)this)).zzs.zzaw();
        if (zzab.zza()) {
            ((zzgx)((Object)this)).zzs.zzay().zzd().zza("Cannot get conditional user properties from main thread");
            return new ArrayList(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgz zzgz2 = ((zzij)((Object)this)).zzs;
        zzgz2 = ((zzge)zzgz2).zzaz();
        zzhu zzhu2 = new zzhu((zzij)((Object)this), atomicReference, null, (String)object, string);
        ((zzgb)zzgz2).zzd(atomicReference, 5000L, "get conditional user properties", zzhu2);
        object = (List)atomicReference.get();
        if (object != null) return zzln.zzH((List)object);
        ((zzgx)((Object)this)).zzs.zzay().zzd().zzb("Timed out waiting for get conditional user properties", null);
        return new ArrayList();
    }

    public final List zzt(boolean bl) {
        this.zza();
        this.zzs.zzay().zzj().zza("Getting user properties (FE)");
        if (!this.zzs.zzaz().zzs()) {
            this.zzs.zzaw();
            if (zzab.zza()) {
                this.zzs.zzay().zzd().zza("Cannot get all user properties from main thread");
                return Collections.emptyList();
            }
            Object object = new AtomicReference();
            zzgz zzgz2 = this.zzs;
            zzgz2 = ((zzge)zzgz2).zzaz();
            zzhq zzhq2 = new zzhq(this, (AtomicReference)object, bl);
            ((zzgb)zzgz2).zzd((AtomicReference)object, 5000L, "get user properties", zzhq2);
            object = (List)((AtomicReference)object).get();
            if (object == null) {
                this.zzs.zzay().zzd().zzb("Timed out waiting for get user properties, includeInternal", bl);
                return Collections.emptyList();
            }
            return object;
        }
        this.zzs.zzay().zzd().zza("Cannot get all user properties from analytics worker thread");
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Map zzu(String iterator, String object, boolean bl) {
        void var3_5;
        if (((zzgx)object2).zzs.zzaz().zzs()) {
            ((zzgx)object2).zzs.zzay().zzd().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzgx)object2).zzs.zzaw();
        if (zzab.zza()) {
            ((zzgx)object2).zzs.zzay().zzd().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgz zzgz2 = ((zzij)object2).zzs;
        zzgz2 = ((zzge)zzgz2).zzaz();
        zzhw zzhw2 = new zzhw((zzij)object2, atomicReference, null, (String)((Object)iterator), (String)object, (boolean)var3_5);
        ((zzgb)zzgz2).zzd(atomicReference, 5000L, "get user properties", zzhw2);
        iterator = (List)atomicReference.get();
        if (iterator == null) {
            ((zzgx)object2).zzs.zzay().zzd().zzb("Timed out waiting for handle get user properties, includeInternal", (boolean)var3_5);
            return Collections.emptyMap();
        }
        Object object2 = new ArrayMap(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            zzli zzli2 = (zzli)((Object)iterator.next());
            Object object3 = zzli2.zza();
            if (object3 == null) continue;
            object2.put(zzli2.zzb, object3);
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzv(zzij zzij2, zzai zzai2, zzai zzai3) {
        int n;
        zzah[] zzahArray;
        block2: {
            zzahArray = new zzah[]{zzah.zzb, zzah.zza};
            for (n = 0; n < 2; ++n) {
                zzah zzah2 = zzahArray[n];
                if (zzai3.zzi(zzah2) || !zzai2.zzi(zzah2)) continue;
                n = 1;
                break block2;
            }
            n = 0;
        }
        zzahArray = new zzah[]{zzah.zzb, zzah.zza};
        boolean bl = zzai2.zzl(zzai3, zzahArray);
        if (n == 0 && !bl) {
            return;
        }
        zzij2.zzs.zzh().zzo();
    }

    static /* synthetic */ void zzw(zzij zzgz2, zzai atomicReference, int n, long l, boolean bl, boolean bl2) {
        ((zzgx)zzgz2).zzg();
        ((zzf)zzgz2).zza();
        if (l > ((zzij)zzgz2).zzl || !zzai.zzj(((zzij)zzgz2).zzm, n)) {
            zzfj zzfj2 = ((zzgx)zzgz2).zzs.zzm();
            zzge cfr_ignored_0 = zzfj2.zzs;
            zzfj2.zzg();
            if (zzfj2.zzl(n)) {
                zzfj2 = zzfj2.zza().edit();
                zzfj2.putString("consent_settings", ((zzai)((Object)atomicReference)).zzh());
                zzfj2.putInt("consent_source", n);
                zzfj2.apply();
                ((zzij)zzgz2).zzl = l;
                ((zzij)zzgz2).zzm = n;
                ((zze)zzgz2).zzs.zzt().zzF(bl);
                if (bl2) {
                    zzgz2 = ((zze)zzgz2).zzs;
                    zzgz2 = ((zzge)zzgz2).zzt();
                    atomicReference = new AtomicReference();
                    ((zzjy)zzgz2).zzu(atomicReference);
                    return;
                }
                return;
            }
            ((zzgx)zzgz2).zzs.zzay().zzi().zzb("Lower precedence consent source ignored, proposed source", n);
            return;
        }
        ((zzgx)zzgz2).zzs.zzay().zzi().zzb("Dropped out-of-date consent setting, proposed settings", atomicReference);
    }

    static /* bridge */ /* synthetic */ void zzx(zzij zzij2, Boolean bl, boolean bl2) {
        zzij2.zzaa(bl, true);
    }

    static /* bridge */ /* synthetic */ void zzy(zzij zzij2) {
        zzij2.zzab();
    }

    protected zzij(zzge zzge2) {
        super(zzge2);
        Object object = new CopyOnWriteArraySet();
        this.zze = object;
        this.zzh = object = new Object();
        this.zzc = true;
        this.zzn = object = new zzhx(this);
        object = new AtomicReference();
        this.zzg = object;
        this.zzi = object = new zzai(null, null);
        this.zzj = 100;
        this.zzl = -1L;
        this.zzm = 100;
        this.zzk = object = new AtomicLong(0L);
        this.zzb = object = new zzs(zzge2);
    }

    @WorkerThread
    public final void zzz() {
        ((zzgx)this).zzg();
        this.zza();
        if (this.zzs.zzM()) {
            Object object;
            Object object2;
            if (this.zzs.zzf().zzs(null, zzeh.zzX)) {
                object2 = this.zzs.zzf();
                ((zzgx)object2).zzs.zzaw();
                object2 = ((zzag)object2).zzk("google_analytics_deferred_deep_link_enabled");
                if (object2 != null && ((Boolean)object2).booleanValue()) {
                    this.zzs.zzay().zzc().zza("Deferred Deep Link feature enabled.");
                    object2 = this.zzs;
                    object2 = ((zzge)object2).zzaz();
                    object = new zzhl(this);
                    ((zzgb)object2).zzp((Runnable)object);
                }
            }
            this.zzs.zzt().zzq();
            this.zzc = false;
            object2 = this.zzs.zzm();
            ((zzgx)object2).zzg();
            object = ((zzfj)object2).zza().getString("previous_os_version", null);
            ((zzgx)object2).zzs.zzg().zzu();
            String string = Build.VERSION.RELEASE;
            if (!TextUtils.isEmpty((CharSequence)string) && !string.equals(object)) {
                object2 = ((zzfj)object2).zza().edit();
                object2.putString("previous_os_version", string);
                object2.apply();
            }
            if (!TextUtils.isEmpty((CharSequence)object)) {
                this.zzs.zzg().zzu();
                if (!((String)object).equals(Build.VERSION.RELEASE)) {
                    object2 = new Bundle();
                    object2.putString("_po", (String)object);
                    this.zzG("auto", "_ou", (Bundle)object2);
                    return;
                }
            }
            return;
        }
    }

    public final void zzA(String object, String object2, Bundle bundle) {
        zzge zzge2 = this.zzs;
        zzge2 = zzge2.zzav();
        long l = zzge2.currentTimeMillis();
        Preconditions.checkNotEmpty((String)object);
        zzge2 = new Bundle();
        zzge2.putString("name", (String)object);
        zzge2.putLong("creation_timestamp", l);
        if (object2 != null) {
            zzge2.putString("expired_event_name", (String)object2);
            zzge2.putBundle("expired_event_params", bundle);
        }
        object = this.zzs;
        object = ((zzge)object).zzaz();
        object2 = new zzht(this, (Bundle)zzge2);
        ((zzgb)object).zzp((Runnable)object2);
    }

    public final void zzB() {
        if (this.zzs.zzau().getApplicationContext() instanceof Application && this.zza != null) {
            ((Application)this.zzs.zzau().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zza);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzC(Bundle object) {
        Object object2;
        if (object == null) {
            Object object3 = ((zzgx)object3).zzs;
            object3 = ((zzge)object3).zzm();
            object3 = ((zzfj)object3).zzr;
            object = new Bundle();
            ((zzfe)object3).zzb((Bundle)object);
            return;
        }
        Bundle bundle = ((zzgx)object3).zzs.zzm().zzr.zza();
        for (Object object4 : object.keySet()) {
            object2 = object.get((String)object4);
            if (!(object2 == null || object2 instanceof String || object2 instanceof Long || object2 instanceof Double)) {
                if (((zzgx)object3).zzs.zzv().zzaf(object2)) {
                    ((zzgx)object3).zzs.zzv().zzN(((zzij)object3).zzn, null, 27, null, null, 0);
                }
                ((zzgx)object3).zzs.zzay().zzl().zzc("Invalid default event parameter type. Name, value", object4, object2);
                continue;
            }
            if (zzln.zzah((String)object4)) {
                ((zzgx)object3).zzs.zzay().zzl().zzb("Invalid default event parameter name. Name", object4);
                continue;
            }
            if (object2 == null) {
                bundle.remove((String)object4);
                continue;
            }
            zzgz zzgz2 = ((zzgx)object3).zzs;
            zzgz2 = ((zzge)zzgz2).zzv();
            ((zzgx)object3).zzs.zzf();
            if (!((zzln)zzgz2).zzaa("param", (String)object4, 100, object2)) continue;
            ((zzgx)object3).zzs.zzv().zzO(bundle, (String)object4, object2);
        }
        ((zzgx)object3).zzs.zzv();
        int n = ((zzgx)object3).zzs.zzf().zzc();
        if (bundle.size() > n) {
            Object object4;
            object = new TreeSet(bundle.keySet());
            object4 = object.iterator();
            int n2 = 0;
            while (object4.hasNext()) {
                object2 = (String)object4.next();
                if (++n2 <= n) continue;
                bundle.remove((String)object2);
            }
            ((zzgx)object3).zzs.zzv().zzN(((zzij)object3).zzn, null, 26, null, null, 0);
            ((zzgx)object3).zzs.zzay().zzl().zza("Too many default event parameters set. Discarding beyond event parameter limit");
        }
        ((zzgx)object3).zzs.zzm().zzr.zzb(bundle);
        ((zze)object3).zzs.zzt().zzH(bundle);
    }

    public final void zzD(String string, String string2, Bundle bundle) {
        this.zzE(string, string2, bundle, true, true, this.zzs.zzav().currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzE(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        String string3;
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (!(string2 == (string3 = "screen_view") || string2 != null && string2.equals(string3))) {
            boolean bl3 = bl2 ? (this.zzd != null ? zzln.zzah(string2) : true) : true;
            this.zzM(string, string2, l, bundle, bl2, bl3, bl, null);
            return;
        }
        this.zzs.zzs().zzx(bundle, l);
    }

    public final void zzF(String string, String string2, Bundle bundle, String string3) {
        zzge.zzO();
        this.zzM("auto", string2, this.zzs.zzav().currentTimeMillis(), bundle, false, true, true, string3);
    }

    @WorkerThread
    final void zzG(String string, String string2, Bundle bundle) {
        ((zzgx)this).zzg();
        this.zzH(string, string2, this.zzs.zzav().currentTimeMillis(), bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzH(String string, String string2, long l, Bundle bundle) {
        ((zzgx)this).zzg();
        boolean bl = this.zzd != null ? zzln.zzah(string2) : true;
        this.zzI(string, string2, l, bundle, true, bl, true, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    protected final void zzI(String object, String string, long l, Bundle object2, boolean n, boolean bl, boolean bl2, String string2) {
        int n2;
        int n3;
        Object object32;
        block53: {
            block54: {
                Object[] objectArray;
                Preconditions.checkNotEmpty((String)object);
                Preconditions.checkNotNull((Object)object2);
                ((zzgx)zzgz2).zzg();
                ((zzf)zzgz2).zza();
                if (!((zzij)zzgz2).zzs.zzJ()) {
                    ((zzgx)zzgz2).zzs.zzay().zzc().zza("Event not sent since app measurement is disabled");
                    return;
                }
                Object object4 = ((zze)zzgz2).zzs.zzh().zzn();
                if (object4 != null && !object4.contains(string)) {
                    ((zzgx)zzgz2).zzs.zzay().zzc().zzc("Dropping non-safelisted event. event name, origin", string, object);
                    return;
                }
                if (!((zzij)zzgz2).zzf) {
                    GenericDeclaration genericDeclaration;
                    ((zzij)zzgz2).zzf = true;
                    boolean bl3 = ((zzij)zzgz2).zzs.zzN();
                    if (bl3) {
                        genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                        genericDeclaration = Class.forName((String)((Object)genericDeclaration));
                    }
                    genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                    objectArray = ((zzgx)zzgz2).zzs.zzau();
                    genericDeclaration = Class.forName((String)((Object)genericDeclaration), true, objectArray.getClassLoader());
                    try {
                        objectArray = new Class[]{Context.class};
                        genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("initialize", (Class<?>[])objectArray);
                        objectArray = new Object[1];
                        object32 = ((zzgx)zzgz2).zzs.zzau();
                        objectArray[0] = object32;
                        ((Method)genericDeclaration).invoke(null, objectArray);
                    }
                    catch (Exception exception) {
                        try {
                            ((zzgx)zzgz2).zzs.zzay().zzk().zzb("Failed to invoke Tag Manager's initialize() method", exception);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ((zzgx)zzgz2).zzs.zzay().zzi().zza("Tag Manager is not found and thus will not be used");
                        }
                    }
                }
                if ("_cmp".equals(string) && object2.containsKey("gclid")) {
                    ((zzgx)zzgz2).zzs.zzaw();
                    ((zzij)zzgz2).zzY("auto", "_lgclid", object2.getString("gclid"), ((zzgx)zzgz2).zzs.zzav().currentTimeMillis());
                }
                ((zzgx)zzgz2).zzs.zzaw();
                if (n != 0 && zzln.zzal(string)) {
                    ((zzgx)zzgz2).zzs.zzv().zzL((Bundle)object2, ((zzgx)zzgz2).zzs.zzm().zzr.zza());
                }
                if (!bl2) {
                    ((zzgx)zzgz2).zzs.zzaw();
                    if (!"_iap".equals(string)) {
                        int n4;
                        object4 = ((zzij)zzgz2).zzs.zzv();
                        if (!((zzln)object4).zzac("event", string)) {
                            n4 = 2;
                        } else if (!((zzln)object4).zzZ("event", zzhb.zza, zzhb.zzb, string)) {
                            n4 = 13;
                        } else {
                            ((zzgx)object4).zzs.zzf();
                            n4 = !((zzln)object4).zzY("event", 40, string) ? 2 : 0;
                        }
                        if (n4 != 0) {
                            ((zzgx)zzgz2).zzs.zzay().zze().zzb("Invalid public event name. Event will not be logged (FE)", ((zzgx)zzgz2).zzs.zzj().zzd(string));
                            object = ((zzij)zzgz2).zzs;
                            object = ((zzge)object).zzv();
                            ((zzij)zzgz2).zzs.zzf();
                            object2 = ((zzln)object).zzD(string, 40, true);
                            int n5 = string != null ? string.length() : 0;
                            ((zzij)zzgz2).zzs.zzv().zzN(((zzij)zzgz2).zzn, null, n4, "_ev", (String)object2, n5);
                            return;
                        }
                    }
                }
                zzpf.zzc();
                if (((zzgx)zzgz2).zzs.zzf().zzs(null, zzeh.zzak)) {
                    ((zzgx)zzgz2).zzs.zzaw();
                    objectArray = ((zze)zzgz2).zzs.zzs().zzj(false);
                    if (objectArray != null && !object2.containsKey("_sc")) {
                        objectArray.zzd = true;
                    }
                    n3 = n != 0 ? (!bl2 ? 1 : 0) : 0;
                    zzln.zzK((zziq)objectArray, (Bundle)object2, n3 != 0);
                } else {
                    ((zzgx)zzgz2).zzs.zzaw();
                    objectArray = ((zze)zzgz2).zzs.zzs().zzj(false);
                    if (objectArray != null && !object2.containsKey("_sc")) {
                        objectArray.zzd = true;
                    }
                    n3 = n != 0 ? (!bl2 ? 1 : 0) : 0;
                    zzln.zzK((zziq)objectArray, (Bundle)object2, n3 != 0);
                }
                n3 = "am".equals(object);
                boolean bl4 = zzln.zzah(string);
                if (n == 0) break block54;
                if (((zzij)zzgz2).zzd != null) {
                    if (!bl4) {
                        if (n3 == 0) {
                            ((zzgx)zzgz2).zzs.zzay().zzc().zzc("Passing event to registered event handler (FE)", ((zzgx)zzgz2).zzs.zzj().zzd(string), ((zzgx)zzgz2).zzs.zzj().zzb((Bundle)object2));
                            Preconditions.checkNotNull((Object)((zzij)zzgz2).zzd);
                            ((zzij)zzgz2).zzd.interceptEvent((String)object, string, (Bundle)object2, l);
                            return;
                        }
                        n = 1;
                        break block53;
                    } else {
                        n = n3;
                    }
                    break block53;
                } else {
                    n = n3;
                }
                break block53;
            }
            n = n3;
        }
        if (!((zzij)zzgz2).zzs.zzM()) {
            return;
        }
        n3 = ((zzgx)zzgz2).zzs.zzv().zzh(string);
        if (n3 != 0) {
            ((zzgx)zzgz2).zzs.zzay().zze().zzb("Invalid event name. Event will not be logged (FE)", ((zzgx)zzgz2).zzs.zzj().zzd(string));
            object = ((zzgx)zzgz2).zzs;
            object = ((zzge)object).zzv();
            ((zzgx)zzgz2).zzs.zzf();
            object2 = ((zzln)object).zzD(string, 40, true);
            int n6 = string != null ? string.length() : 0;
            ((zzij)zzgz2).zzs.zzv().zzN(((zzij)zzgz2).zzn, string2, n3, "_ev", (String)object2, n6);
            return;
        }
        String[] stringArray = new String[]{"_o", "_sn", "_sc", "_si"};
        stringArray = CollectionUtils.listOf((Object[])stringArray);
        stringArray = ((zzgx)zzgz2).zzs.zzv().zzy(string2, string, (Bundle)object2, (List)stringArray, bl2);
        Preconditions.checkNotNull((Object)stringArray);
        ((zzgx)zzgz2).zzs.zzaw();
        if (((zze)zzgz2).zzs.zzs().zzj(false) != null && "_ae".equals(string)) {
            object2 = ((zze)zzgz2).zzs.zzu().zzb;
            long l2 = ((zzkm)object2).zzc.zzs.zzav().elapsedRealtime();
            long l3 = l2 - ((zzkm)object2).zzb;
            ((zzkm)object2).zzb = l2;
            if (l3 > 0L) {
                ((zzgx)zzgz2).zzs.zzv().zzI((Bundle)stringArray, l3);
            }
        }
        zzob.zzc();
        if (((zzgx)zzgz2).zzs.zzf().zzs(null, zzeh.zzac)) {
            if (!"auto".equals(object) && "_ssr".equals(string)) {
                zzln zzln2 = ((zzgx)zzgz2).zzs.zzv();
                object2 = stringArray.getString("_ffr");
                if (Strings.isEmptyOrWhitespace((String)object2)) {
                    object2 = null;
                } else if (object2 != null) {
                    object2 = ((String)object2).trim();
                }
                if (zzll.zza(object2, zzln2.zzs.zzm().zzo.zza())) {
                    zzln2.zzs.zzay().zzc().zza("Not logging duplicate session_start_with_rollout event");
                    return;
                }
                zzln2.zzs.zzm().zzo.zzb((String)object2);
            } else if ("_ae".equals(string) && !TextUtils.isEmpty((CharSequence)(object2 = ((zzgx)zzgz2).zzs.zzv().zzs.zzm().zzo.zza()))) {
                stringArray.putString("_ffr", (String)object2);
            }
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add((Bundle)stringArray);
        if (((zzgx)zzgz2).zzs.zzm().zzj.zza() > 0L && ((zzgx)zzgz2).zzs.zzm().zzk(l) && ((zzgx)zzgz2).zzs.zzm().zzl.zzb()) {
            ((zzgx)zzgz2).zzs.zzay().zzj().zza("Current session is expired, remove the session number, ID, and engagement time");
            ((zzij)zzgz2).zzY("auto", "_sid", null, ((zzgx)zzgz2).zzs.zzav().currentTimeMillis());
            ((zzij)zzgz2).zzY("auto", "_sno", null, ((zzgx)zzgz2).zzs.zzav().currentTimeMillis());
            ((zzij)zzgz2).zzY("auto", "_se", null, ((zzgx)zzgz2).zzs.zzav().currentTimeMillis());
        }
        if (stringArray.getLong("extend_session", 0L) == 1L) {
            ((zzgx)zzgz2).zzs.zzay().zzj().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            ((zzij)zzgz2).zzs.zzu().zza.zzb(l, true);
        }
        object32 = new ArrayList(stringArray.keySet());
        Collections.sort(object32);
        int n7 = object32.size();
        for (n2 = 0; n2 < n7; ++n2) {
            String string3 = (String)object32.get(n2);
            if (string3 == null) continue;
            ((zzgx)zzgz2).zzs.zzv();
            Object object5 = stringArray.get(string3);
            if (object5 instanceof Bundle) {
                Bundle[] bundleArray = new Bundle[]{(Bundle)object5};
                object5 = bundleArray;
            } else if (object5 instanceof Parcelable[]) {
                object5 = (Parcelable[])object5;
                object5 = (Bundle[])Arrays.copyOf(object5, ((Parcelable[])object5).length, Bundle[].class);
            } else if (object5 instanceof ArrayList) {
                object5 = (ArrayList)object5;
                object5 = ((ArrayList)object5).toArray(new Bundle[((ArrayList)object5).size()]);
            } else {
                object5 = null;
            }
            if (object5 == null) continue;
            stringArray.putParcelableArray(string3, (Parcelable[])object5);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            stringArray = (Bundle)arrayList.get(n2);
            String string4 = n2 != 0 ? "_ep" : string;
            stringArray.putString("_o", (String)object);
            if (bl) {
                stringArray = ((zzgx)zzgz2).zzs.zzv().zzt((Bundle)stringArray);
            }
            zzau zzau2 = new zzau((Bundle)stringArray);
            object32 = new zzaw(string4, zzau2, (String)object, l);
            ((zze)zzgz2).zzs.zzt().zzA((zzaw)((Object)object32), string2);
            if (n != 0) continue;
            for (Object object32 : ((zzij)zzgz2).zze) {
                object32 = (zzhf)object32;
                zzau2 = new Bundle((Bundle)stringArray);
                object32.onEvent((String)object, string, (Bundle)zzau2, l);
            }
        }
        ((zzgx)zzgz2).zzs.zzaw();
        if (((zze)zzgz2).zzs.zzs().zzj(false) != null && "_ae".equals(string)) {
            object = ((zze)zzgz2).zzs;
            object = ((zzge)object).zzu();
            zzgz zzgz2 = ((zzgx)zzgz2).zzs;
            zzgz2 = ((zzge)zzgz2).zzav();
            l = zzgz2.elapsedRealtime();
            ((zzko)object).zzb.zzd(true, true, l);
            return;
        }
    }

    public final void zzJ(zzhf zzhf2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzhf2);
        if (!this.zze.add(zzhf2)) {
            this.zzs.zzay().zzk().zza("OnEventListener already registered");
            return;
        }
    }

    public final void zzK(long l) {
        this.zzg.set(null);
        zzgz zzgz2 = this.zzs;
        zzgz2 = ((zzge)zzgz2).zzaz();
        zzhr zzhr2 = new zzhr(this, l);
        ((zzgb)zzgz2).zzp(zzhr2);
    }

    final void zzL(long l, boolean bl) {
        ((zzgx)this).zzg();
        this.zza();
        this.zzs.zzay().zzc().zza("Resetting analytics data (FE)");
        zzko zzko2 = this.zzs.zzu();
        ((zzgx)zzko2).zzg();
        zzkn cfr_ignored_0 = zzko2.zza;
        zzko2.zzb.zza();
        zzpi.zzc();
        if (this.zzs.zzf().zzs(null, zzeh.zzaz)) {
            this.zzs.zzh().zzo();
        }
        boolean bl2 = this.zzs.zzJ();
        zzfj zzfj2 = this.zzs.zzm();
        zzfj2.zzc.zzb(l);
        if (!TextUtils.isEmpty((CharSequence)zzfj2.zzs.zzm().zzo.zza())) {
            zzfj2.zzo.zzb(null);
        }
        zzok.zzc();
        if (zzfj2.zzs.zzf().zzs(null, zzeh.zzad)) {
            zzfj2.zzj.zzb(0L);
        }
        if (!zzfj2.zzs.zzf().zzv()) {
            zzfj2.zzi(bl2 ^ true);
        }
        zzfj2.zzp.zzb(null);
        zzfj2.zzq.zzb(0L);
        zzfj2.zzr.zzb(null);
        if (bl) {
            this.zzs.zzt().zzC();
        }
        zzok.zzc();
        if (this.zzs.zzf().zzs(null, zzeh.zzad)) {
            this.zzs.zzu().zza.zza();
        }
        this.zzc = bl2 ^ true;
    }

    protected final void zzM(String string, String string2, long l, Bundle object2, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle = new Bundle((Bundle)object2);
        for (Object object2 : bundle.keySet()) {
            Bundle bundle2;
            Object object3;
            Object object4 = bundle.get((String)object2);
            if (object4 instanceof Bundle) {
                object3 = new Bundle((Bundle)object4);
                bundle.putBundle((String)object2, object3);
                continue;
            }
            if (object4 instanceof Parcelable[]) {
                object4 = (Parcelable[])object4;
                for (int i = 0; i < ((Parcelable[])object4).length; ++i) {
                    object3 = object4[i];
                    if (!(object3 instanceof Bundle)) continue;
                    bundle2 = new Bundle(object3);
                    object4[i] = bundle2;
                }
                continue;
            }
            if (!(object4 instanceof List)) continue;
            object4 = (List)object4;
            for (int i = 0; i < object4.size(); ++i) {
                object3 = object4.get(i);
                if (!(object3 instanceof Bundle)) continue;
                bundle2 = new Bundle(object3);
                object4.set(i, bundle2);
            }
        }
        object2 = this.zzs;
        object2 = ((zzge)object2).zzaz();
        Object object5 = new zzho(this, string, string2, l, bundle, bl, bl2, bl3, string3);
        ((zzgb)object2).zzp((Runnable)object5);
    }

    final void zzN(String string, String string2, long l, Object object) {
        zzgz zzgz2 = this.zzs;
        zzgz2 = ((zzge)zzgz2).zzaz();
        zzhp zzhp2 = new zzhp(this, string, string2, object, l);
        ((zzgb)zzgz2).zzp(zzhp2);
    }

    final void zzO(String string) {
        this.zzg.set(string);
    }

    public final void zzP(Bundle bundle) {
        this.zzQ(bundle, this.zzs.zzav().currentTimeMillis());
    }

    public final void zzQ(Bundle object, long l) {
        Preconditions.checkNotNull((Object)object);
        Bundle bundle = new Bundle((Bundle)object);
        if (!TextUtils.isEmpty((CharSequence)bundle.getString("app_id"))) {
            this.zzs.zzay().zzk().zza("Package name should be null when calling setConditionalUserProperty");
        }
        bundle.remove("app_id");
        Preconditions.checkNotNull((Object)bundle);
        zzha.zza((Bundle)bundle, (String)"app_id", String.class, null);
        zzha.zza((Bundle)bundle, (String)"origin", String.class, null);
        zzha.zza((Bundle)bundle, (String)"name", String.class, null);
        zzha.zza((Bundle)bundle, (String)"value", Object.class, null);
        zzha.zza((Bundle)bundle, (String)"trigger_event_name", String.class, null);
        object = 0L;
        zzha.zza((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)object);
        zzha.zza((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
        zzha.zza((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
        zzha.zza((Bundle)bundle, (String)"triggered_event_name", String.class, null);
        zzha.zza((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
        zzha.zza((Bundle)bundle, (String)"time_to_live", Long.class, (Object)object);
        zzha.zza((Bundle)bundle, (String)"expired_event_name", String.class, null);
        zzha.zza((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        bundle.putLong("creation_timestamp", l);
        object = bundle.getString("name");
        Object object2 = bundle.get("value");
        if (this.zzs.zzv().zzl((String)object) == 0) {
            if (this.zzs.zzv().zzd((String)object, object2) == 0) {
                Object object3 = this.zzs.zzv().zzB((String)object, object2);
                if (object3 == null) {
                    this.zzs.zzay().zzd().zzc("Unable to normalize conditional user property value", this.zzs.zzj().zzf((String)object), object2);
                    return;
                }
                zzha.zzb((Bundle)bundle, (Object)object3);
                long l2 = bundle.getLong("trigger_timeout");
                if (!TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name"))) {
                    this.zzs.zzf();
                    if (l2 > 15552000000L || l2 < 1L) {
                        this.zzs.zzay().zzd().zzc("Invalid conditional user property timeout", this.zzs.zzj().zzf((String)object), l2);
                        return;
                    }
                }
                long l3 = bundle.getLong("time_to_live");
                this.zzs.zzf();
                if (l3 > 15552000000L || l3 < 1L) {
                    this.zzs.zzay().zzd().zzc("Invalid conditional user property time to live", this.zzs.zzj().zzf((String)object), l3);
                    return;
                }
                object = this.zzs;
                object = ((zzge)object).zzaz();
                object2 = new zzhs(this, bundle);
                ((zzgb)object).zzp((Runnable)object2);
                return;
            }
            this.zzs.zzay().zzd().zzc("Invalid conditional user property value", this.zzs.zzj().zzf((String)object), object2);
            return;
        }
        this.zzs.zzay().zzd().zzb("Invalid conditional user property name", this.zzs.zzj().zzf((String)object));
    }

    public final void zzR(Bundle bundle, int n, long l) {
        this.zza();
        String string = zzai.zzg(bundle);
        if (string != null) {
            this.zzs.zzay().zzl().zzb("Ignoring invalid consent setting", string);
            this.zzs.zzay().zzl().zza("Valid consent values are 'granted', 'denied'");
        }
        this.zzS(zzai.zza(bundle), n, l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzS(zzai zzai2, int n, long l) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        zzai zzai3;
        block9: {
            this.zza();
            if (n != -10 && zzai2.zze() == null && zzai2.zzf() == null) {
                this.zzs.zzay().zzl().zza("Discarding empty consent settings");
                return;
            }
            Object object = this.zzh;
            // MONITORENTER : object
            zzai3 = this.zzi;
            boolean bl4 = zzai.zzj(n, this.zzj);
            if (bl4) {
                zzai zzai4;
                bl3 = zzai2.zzk(this.zzi);
                bl4 = zzai2.zzi(zzah.zzb);
                bl4 = bl4 ? !(bl4 = (zzai4 = this.zzi).zzi(zzah.zzb)) : false;
                this.zzi = zzai2 = zzai2.zzd(this.zzi);
                this.zzj = n;
                bl2 = bl4;
                bl = true;
                // MONITOREXIT : object
                break block9;
            }
            bl3 = false;
            bl2 = false;
            bl = false;
            {
                catch (Throwable throwable) {}
                {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
        }
        if (!bl) {
            this.zzs.zzay().zzi().zzb("Ignoring lower-priority consent settings, proposed settings", zzai2);
            return;
        }
        long l2 = this.zzk.getAndIncrement();
        if (bl3) {
            this.zzg.set(null);
            zzgz zzgz2 = this.zzs;
            zzgz2 = ((zzge)zzgz2).zzaz();
            zzid zzid2 = new zzid(this, zzai2, l, n, l2, bl2, zzai3);
            ((zzgb)zzgz2).zzq(zzid2);
            return;
        }
        zzie zzie2 = new zzie(this, zzai2, n, l2, bl2, zzai3);
        if (n != 30 && n != -10) {
            this.zzs.zzaz().zzp(zzie2);
            return;
        }
        this.zzs.zzaz().zzq(zzie2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zzT(zzhe zzhe2) {
        zzhe zzhe3;
        ((zzgx)this).zzg();
        this.zza();
        if (zzhe2 != null && zzhe2 != (zzhe3 = this.zzd)) {
            boolean bl = zzhe3 == null;
            Preconditions.checkState((boolean)bl, (Object)"EventInterceptor already set.");
        }
        this.zzd = zzhe2;
    }

    public final void zzU(Boolean bl) {
        this.zza();
        zzgz zzgz2 = this.zzs;
        zzgz2 = ((zzge)zzgz2).zzaz();
        zzic zzic2 = new zzic(this, bl);
        ((zzgb)zzgz2).zzp(zzic2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzV(zzai zzai2) {
        ((zzgx)this).zzg();
        boolean bl = !zzai2.zzi(zzah.zzb) || !zzai2.zzi(zzah.zza) ? this.zzs.zzt().zzM() : true;
        if (bl != this.zzs.zzK()) {
            this.zzs.zzG(bl);
            Object object = this.zzs.zzm();
            zzge cfr_ignored_0 = ((zzgx)object).zzs;
            ((zzgx)object).zzg();
            object = ((zzfj)object).zza().contains("measurement_enabled_from_api") ? Boolean.valueOf(((zzfj)object).zza().getBoolean("measurement_enabled_from_api", true)) : null;
            if (!bl || object == null || ((Boolean)object).booleanValue()) {
                this.zzaa(bl, false);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzaa(Boolean bl, boolean bl2) {
        ((zzgx)this).zzg();
        this.zza();
        this.zzs.zzay().zzc().zzb("Setting app measurement enabled (FE)", bl);
        this.zzs.zzm().zzh(bl);
        if (bl2) {
            zzfj zzfj2 = this.zzs.zzm();
            zzge cfr_ignored_0 = zzfj2.zzs;
            zzfj2.zzg();
            zzfj2 = zzfj2.zza().edit();
            if (bl != null) {
                zzfj2.putBoolean("measurement_enabled_from_api", bl);
            } else {
                zzfj2.remove("measurement_enabled_from_api");
            }
            zzfj2.apply();
        }
        if (this.zzs.zzK() || bl != null && !bl.booleanValue()) {
            this.zzab();
            return;
        }
    }

    public final void zzW(String string, String string2, Object object, boolean bl) {
        this.zzX("auto", "_ldl", object, true, this.zzs.zzav().currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void zzX(String object, String string, Object object2, boolean bl, long l) {
        void var5_15;
        void var4_8;
        if (object == null) {
            object = "app";
        }
        if (bl) {
            int n = this.zzs.zzv().zzl(string);
        } else {
            zzln zzln2 = this.zzs.zzv();
            if (!zzln2.zzac("user property", string)) {
                int n = 6;
            } else if (!zzln2.zzZ("user property", zzhd.zza, null, string)) {
                int n = 15;
            } else {
                zzln2.zzs.zzf();
                if (!zzln2.zzY("user property", 24, string)) {
                    int n = 6;
                } else {
                    boolean bl2 = false;
                }
            }
        }
        if (var4_8 != false) {
            object = this.zzs;
            object = ((zzge)object).zzv();
            this.zzs.zzf();
            object2 = ((zzln)object).zzD(string, 24, true);
            int n = string != null ? string.length() : 0;
            this.zzs.zzv().zzN(this.zzn, null, (int)var4_8, "_ev", (String)object2, n);
            return;
        }
        if (object2 == null) {
            this.zzN((String)object, string, (long)var5_15, null);
            return;
        }
        int n = this.zzs.zzv().zzd(string, object2);
        if (n != 0) {
            object = this.zzs;
            object = ((zzge)object).zzv();
            this.zzs.zzf();
            string = ((zzln)object).zzD(string, 24, true);
            int n2 = object2 instanceof String || object2 instanceof CharSequence ? object2.toString().length() : 0;
            this.zzs.zzv().zzN(this.zzn, null, n, "_ev", string, n2);
            return;
        }
        object2 = this.zzs.zzv().zzB(string, object2);
        if (object2 != null) {
            this.zzN((String)object, string, (long)var5_15, object2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzY(String string, String string2, Object object, long l) {
        Object object2;
        block6: {
            block7: {
                Preconditions.checkNotEmpty((String)string);
                Preconditions.checkNotEmpty((String)string2);
                ((zzgx)this).zzg();
                this.zza();
                if (!"allow_personalized_ads".equals(string2)) break block7;
                if (object instanceof String && !TextUtils.isEmpty((CharSequence)(object2 = (String)object))) {
                    long l2 = true != "false".equals(((String)object2).toLowerCase(Locale.ENGLISH)) ? 0L : 1L;
                    object2 = l2;
                    object = this.zzs.zzm().zzh;
                    string2 = (Long)object2 == 1L ? "true" : "false";
                    ((zzfi)object).zzb(string2);
                    string2 = "_npa";
                    break block6;
                } else if (object == null) {
                    this.zzs.zzm().zzh.zzb("unset");
                    string2 = "_npa";
                    object2 = object;
                    break block6;
                } else {
                    object2 = object;
                }
                break block6;
            }
            object2 = object;
        }
        if (!this.zzs.zzJ()) {
            this.zzs.zzay().zzj().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzs.zzM()) {
            return;
        }
        object = new zzli(string2, l, object2, string);
        this.zzs.zzt().zzK((zzli)((Object)object));
    }

    public final void zzZ(zzhf zzhf2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzhf2);
        if (!this.zze.remove(zzhf2)) {
            this.zzs.zzay().zzk().zza("OnEventListener had not been registered");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzab() {
        ((zzgx)this).zzg();
        Object object = this.zzs.zzm().zzh.zza();
        if (object != null) {
            if ("unset".equals(object)) {
                this.zzY("app", "_npa", null, this.zzs.zzav().currentTimeMillis());
            } else {
                long l = true != "true".equals(object) ? 0L : 1L;
                this.zzY("app", "_npa", l, this.zzs.zzav().currentTimeMillis());
            }
        }
        if (this.zzs.zzJ() && this.zzc) {
            this.zzs.zzay().zzc().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzz();
            zzok.zzc();
            if (this.zzs.zzf().zzs(null, zzeh.zzad)) {
                this.zzs.zzu().zza.zza();
            }
            object = this.zzs;
            object = ((zzge)object).zzaz();
            zzhm zzhm2 = new zzhm(this);
            ((zzgb)object).zzp(zzhm2);
            return;
        }
        this.zzs.zzay().zzc().zza("Updating Scion state (FE)");
        this.zzs.zzt().zzI();
    }

    @Override
    protected final boolean zzf() {
        return false;
    }
}

