/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzgp;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzfa
extends zzgp {
    @VisibleForTesting
    static final Pair<String, Long> zza;
    private SharedPreferences zzt;
    public zzey zzb;
    public final zzew zzc;
    public final zzew zzd;
    public final zzez zze;
    private String zzu;
    private boolean zzv;
    private long zzw;
    public final zzew zzf;
    public final zzeu zzg;
    public final zzez zzh;
    public final zzeu zzi;
    public final zzew zzj;
    public boolean zzk;
    public final zzeu zzl;
    public final zzeu zzm;
    public final zzew zzn;
    public final zzez zzo;
    public final zzez zzp;
    public final zzew zzq;
    public final zzev zzr;

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zza() {
        this.zzg();
        this.zzu();
        Preconditions.checkNotNull((Object)this.zzt);
        return this.zzt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair<String, Boolean> zzb(String string) {
        this.zzg();
        long l = this.zzs.zzav().elapsedRealtime();
        String string2 = this.zzu;
        if (string2 != null && l < this.zzw) {
            return new Pair((Object)string2, (Object)this.zzv);
        }
        this.zzw = l + this.zzs.zzf().zzi(string, zzdy.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = this.zzs.zzau();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            this.zzu = "";
            string2 = string.getId();
            if (string2 != null) {
                this.zzu = string2;
            }
            this.zzv = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            this.zzs.zzay().zzc().zzb("Unable to get advertising id", exception);
            this.zzu = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzu, (Object)this.zzv);
    }

    @WorkerThread
    final zzag zzc() {
        this.zzg();
        return zzag.zzb(this.zza().getString("consent_settings", "G1"));
    }

    @WorkerThread
    final Boolean zzd() {
        this.zzg();
        if (this.zza().contains("measurement_enabled")) {
            return this.zza().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    static {
        Pair pair;
        zza = pair = new Pair((Object)"", (Object)0L);
    }

    zzfa(zzfv object) {
        super((zzfv)object);
        this.zzf = object = new zzew(this, "session_timeout", 1800000L);
        this.zzg = object = new zzeu(this, "start_new_session", true);
        this.zzj = object = new zzew(this, "last_pause_time", 0L);
        this.zzh = object = new zzez(this, "non_personalized_ads", null);
        this.zzi = object = new zzeu(this, "allow_remote_dynamite", false);
        this.zzc = object = new zzew(this, "first_open_time", 0L);
        this.zzd = object = new zzew(this, "app_install_time", 0L);
        this.zze = object = new zzez(this, "app_instance_id", null);
        this.zzl = object = new zzeu(this, "app_backgrounded", false);
        this.zzm = object = new zzeu(this, "deep_link_retrieval_complete", false);
        this.zzn = object = new zzew(this, "deep_link_retrieval_attempts", 0L);
        this.zzo = object = new zzez(this, "firebase_feature_rollouts", null);
        this.zzp = object = new zzez(this, "deferred_attribution_cache", null);
        this.zzq = object = new zzew(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzr = object = new zzev(this, "default_event_parameters", null);
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzaA() {
        zzey zzey2;
        boolean bl;
        this.zzt = this.zzs.zzau().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzk = bl = this.zzt.getBoolean("has_been_opened", false);
        if (!bl) {
            SharedPreferences.Editor editor = this.zzt.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzs.zzf();
        this.zzb = zzey2 = new zzey(this, "health_monitor", Math.max(0L, (Long)zzdy.zzb.zza(null)), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzh(Boolean bl) {
        zzfa2.zzg();
        zzfa zzfa2 = zzfa2.zza().edit();
        if (bl != null) {
            zzfa2.putBoolean("measurement_enabled", bl);
        } else {
            zzfa2.remove("measurement_enabled");
        }
        zzfa2.apply();
    }

    @WorkerThread
    final void zzi(boolean bl) {
        zzfa2.zzg();
        zzfa2.zzs.zzay().zzj().zzb("App measurement setting deferred collection", bl);
        zzfa zzfa2 = zzfa2.zza().edit();
        zzfa2.putBoolean("deferred_analytics_collection", bl);
        zzfa2.apply();
    }

    @WorkerThread
    final boolean zzj() {
        zzfa zzfa2 = zzfa2.zzt;
        if (zzfa2 == null) {
            return false;
        }
        return zzfa2.contains("deferred_analytics_collection");
    }

    final boolean zzk(long l) {
        return l - this.zzf.zza() > this.zzj.zza();
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    @WorkerThread
    final boolean zzl(int n) {
        return zzag.zzl(n, this.zza().getInt("consent_source", 100));
    }
}

