/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzdz;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzkp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zzif
extends zzf {
    private volatile zzhy zzb;
    private zzhy zzc;
    @VisibleForTesting
    protected zzhy zza;
    private final Map<Activity, zzhy> zzd;
    @GuardedBy(value="activityLock")
    private Activity zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile zzhy zzg;
    private zzhy zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj;
    @GuardedBy(value="this")
    private zzhy zzk;
    @GuardedBy(value="this")
    private String zzl;

    public zzif(zzfp concurrentHashMap) {
        super((zzfp)((Object)concurrentHashMap));
        concurrentHashMap = new ConcurrentHashMap<Activity, zzhy>();
        this.zzj = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap<Activity, zzhy>();
        this.zzd = concurrentHashMap;
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @WorkerThread
    public final zzhy zzh(boolean bl) {
        this.zzb();
        ((zzgi)this).zzg();
        if (!this.zzs.zzc().zzn(null, zzea.zzar) || !bl) {
            return this.zza;
        }
        zzhy zzhy2 = this.zza;
        if (zzhy2 != null) {
            return zzhy2;
        }
        return this.zzh;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final String zzi(Class<?> object, String string) {
        if ((object = ((Class)object).getCanonicalName()) == null) {
            return "Activity";
        }
        int n = ((Object)(object = ((String)object).split("\\."))).length;
        object = n > 0 ? object[n + -1] : "";
        n = ((String)object).length();
        this.zzs.zzc();
        if (n > 100) {
            this.zzs.zzc();
            return ((String)object).substring(0, 100);
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzj(Bundle bundle, long l) {
        Object object;
        Object object2;
        zzgi zzgi2;
        Object object3;
        block18: {
            block19: {
                block16: {
                    block17: {
                        if (!zzgi2.zzs.zzc().zzn(null, zzea.zzar)) {
                            zzgi2.zzs.zzau().zzh().zza("Manual screen reporting is disabled.");
                            return;
                        }
                        object3 = ((zzif)zzgi2).zzj;
                        // MONITORENTER : object3
                        int n = ((zzif)zzgi2).zzi;
                        if (n == 0) {
                            zzgi2 = zzgi2.zzs.zzau();
                            ((zzem)zzgi2).zzh().zza("Cannot log screen view event when the app is in the background.");
                            // MONITOREXIT : object3
                            return;
                        }
                        object2 = bundle.getString("screen_name");
                        if (object2 == null) break block16;
                        n = ((String)object2).length();
                        if (n <= 0) break block17;
                        n = ((String)object2).length();
                        zzgi2.zzs.zzc();
                        if (n <= 100) break block16;
                    }
                    zzgi2 = zzgi2.zzs.zzau();
                    ((zzem)zzgi2).zzh().zzb("Invalid screen name length for screen view. Length", ((String)object2).length());
                    // MONITOREXIT : object3
                    return;
                }
                if ((object = bundle.getString("screen_class")) == null) break block18;
                int n = ((String)object).length();
                if (n <= 0) break block19;
                n = ((String)object).length();
                zzgi2.zzs.zzc();
                if (n <= 100) break block18;
            }
            zzgi2 = zzgi2.zzs.zzau();
            ((zzem)zzgi2).zzh().zzb("Invalid screen class length for screen view. Length", ((String)object).length());
            // MONITOREXIT : object3
            return;
        }
        if (object == null) {
            object = ((zzif)zzgi2).zze;
            object = object != null ? ((zzif)zzgi2).zzi(object.getClass(), "Activity") : "Activity";
        }
        zzhy zzhy2 = ((zzif)zzgi2).zzb;
        boolean bl = ((zzif)zzgi2).zzf;
        if (bl && zzhy2 != null) {
            ((zzif)zzgi2).zzf = false;
            String string = zzhy2.zzb;
            bl = zzkp.zzS(string, (String)object);
            boolean bl2 = zzkp.zzS(zzhy2.zza, (String)object2);
            if (bl && bl2) {
                zzgi2 = zzgi2.zzs.zzau();
                ((zzem)zzgi2).zzh().zza("Ignoring call to log screen view event with duplicate parameters.");
                // MONITOREXIT : object3
                return;
            }
        }
        // MONITOREXIT : object3
        zzek zzek2 = zzgi2.zzs.zzau().zzk();
        object3 = object2 == null ? "null" : object2;
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object3
                throw throwable;
            }
        }
        Object object4 = object == null ? "null" : object;
        zzek2.zzc("Logging screen view with name, class", object3, object4);
        object3 = ((zzif)zzgi2).zzb == null ? ((zzif)zzgi2).zzc : ((zzif)zzgi2).zzb;
        ((zzif)zzgi2).zzb = object4 = new zzhy((String)object2, (String)object, zzgi2.zzs.zzl().zzd(), true, l);
        ((zzif)zzgi2).zzc = object3;
        ((zzif)zzgi2).zzg = object4;
        object = zzgi2.zzs;
        object = ((zzfp)object).zzay();
        l = object.elapsedRealtime();
        object = zzgi2.zzs;
        object = ((zzfp)object).zzav();
        object2 = new zzhz((zzif)zzgi2, bundle, (zzhy)object4, (zzhy)object3, l);
        ((zzfm)object).zzh((Runnable)object2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    @MainThread
    public final void zzk(@NonNull Activity activity, @Size(min=1L, max=36L) String string, @Size(min=1L, max=36L) String string2) {
        block9: {
            block11: {
                block10: {
                    int n;
                    block8: {
                        if (!this.zzs.zzc().zzt()) {
                            this.zzs.zzau().zzh().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
                            return;
                        }
                        zzhy zzhy2 = this.zzb;
                        if (zzhy2 == null) {
                            this.zzs.zzau().zzh().zza("setCurrentScreen cannot be called while no activity active");
                            return;
                        }
                        if (this.zzd.get(activity) == null) {
                            this.zzs.zzau().zzh().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
                            return;
                        }
                        if (string2 == null) {
                            string2 = this.zzi(activity.getClass(), "Activity");
                        }
                        String string3 = zzhy2.zzb;
                        boolean bl = zzkp.zzS(string3, string2);
                        n = zzkp.zzS(zzhy2.zza, string);
                        if (bl && n != 0) {
                            this.zzs.zzau().zzh().zza("setCurrentScreen cannot be called with the same class and name");
                            return;
                        }
                        if (string == null) break block8;
                        if (string.length() <= 0) break block9;
                        n = string.length();
                        this.zzs.zzc();
                        if (n > 100) break block9;
                    }
                    if (string2 == null) break block10;
                    if (string2.length() <= 0) break block11;
                    n = string2.length();
                    this.zzs.zzc();
                    if (n > 100) break block11;
                }
                zzek zzek2 = this.zzs.zzau().zzk();
                Object object = string == null ? "null" : string;
                zzek2.zzc("Setting current screen to name, class", object, string2);
                object = new zzhy(string, string2, this.zzs.zzl().zzd());
                this.zzd.put(activity, (zzhy)object);
                this.zzA(activity, (zzhy)object, true);
                return;
            }
            this.zzs.zzau().zzh().zzb("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        this.zzs.zzau().zzh().zzb("Invalid screen name length in setCurrentScreen. Length", string.length());
    }

    public final zzhy zzl() {
        return this.zzb;
    }

    /*
     * Enabled aggressive block sorting
     */
    @MainThread
    private final void zzA(Activity object, zzhy object2, boolean bl) {
        Object object3;
        zzhy zzhy2 = this.zzb == null ? this.zzc : this.zzb;
        if (((zzhy)object2).zzb == null) {
            object = object != null ? this.zzi(object.getClass(), "Activity") : null;
            object = object3 = new zzhy(((zzhy)object2).zza, (String)object, ((zzhy)object2).zzc, ((zzhy)object2).zze, ((zzhy)object2).zzf);
        } else {
            object = object2;
        }
        this.zzc = this.zzb;
        this.zzb = object;
        object2 = this.zzs;
        object2 = ((zzfp)object2).zzay();
        long l = object2.elapsedRealtime();
        object2 = this.zzs;
        object2 = ((zzfp)object2).zzav();
        object3 = new zzia(this, (zzhy)object, zzhy2, l, bl);
        ((zzfm)object2).zzh((Runnable)object3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzB(zzhy zzhy2, zzhy object, long l, boolean bl, Bundle bundle) {
        ((zzgi)this).zzg();
        bl = bl ? this.zza != null : false;
        if (bl) {
            this.zzC(this.zza, true, l);
        }
        if (object == null || ((zzhy)object).zzc != zzhy2.zzc || !zzkp.zzS(((zzhy)object).zzb, zzhy2.zzb) || !zzkp.zzS(((zzhy)object).zza, zzhy2.zza)) {
            Bundle bundle2;
            Bundle bundle3 = new Bundle();
            bundle = this.zzs.zzc().zzn(null, zzea.zzar) ? (bundle != null ? (bundle2 = new Bundle(bundle)) : new Bundle()) : bundle3;
            zzif.zzm(zzhy2, bundle, true);
            if (object != null) {
                String string;
                String string2 = ((zzhy)object).zza;
                if (string2 != null) {
                    bundle.putString("_pn", string2);
                }
                if ((string = ((zzhy)object).zzb) != null) {
                    bundle.putString("_pc", string);
                }
                bundle.putLong("_pi", ((zzhy)object).zzc);
            }
            if (bl) {
                object = this.zzs.zzh().zzb;
                long l2 = l - ((zzjs)object).zzb;
                ((zzjs)object).zzb = l;
                if (l2 > 0L) {
                    this.zzs.zzl().zzac(bundle, l2);
                }
            }
            if (this.zzs.zzc().zzn(null, zzea.zzar)) {
                if (!this.zzs.zzc().zzt()) {
                    bundle.putLong("_mst", 1L);
                }
                object = !zzhy2.zze ? "auto" : "app";
            } else {
                object = "auto";
            }
            if (this.zzs.zzc().zzn(null, zzea.zzar)) {
                long l3;
                long l4 = this.zzs.zzay().currentTimeMillis();
                long l5 = zzhy2.zze ? ((l3 = zzhy2.zzf) != 0L ? l3 : l4) : l4;
                this.zzs.zzk().zzt((String)object, "_vs", l5, bundle);
            } else {
                zzhr zzhr2 = this.zzs.zzk();
                zzfp cfr_ignored_0 = zzhr2.zzs;
                ((zzgi)zzhr2).zzg();
                zzhr2.zzt((String)object, "_vs", zzhr2.zzs.zzay().currentTimeMillis(), bundle);
            }
        }
        this.zza = zzhy2;
        if (this.zzs.zzc().zzn(null, zzea.zzar) && zzhy2.zze) {
            this.zzh = zzhy2;
        }
        this.zzs.zzy().zzz(zzhy2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzC(zzhy zzhy2, boolean bl, long l) {
        this.zzs.zzB().zzc(this.zzs.zzay().elapsedRealtime());
        boolean bl2 = zzhy2 != null ? zzhy2.zzd : false;
        if (this.zzs.zzh().zzb.zzd(bl2, bl, l) && zzhy2 != null) {
            zzhy2.zzd = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zzm(zzhy zzhy2, Bundle bundle, boolean bl) {
        if (zzhy2 != null) {
            if (!bundle.containsKey("_sc") || bl) {
                String string = zzhy2.zza;
                if (string != null) {
                    bundle.putString("_sn", string);
                } else {
                    bundle.remove("_sn");
                }
                if ((string = zzhy2.zzb) != null) {
                    bundle.putString("_sc", string);
                } else {
                    bundle.remove("_sc");
                }
                bundle.putLong("_si", zzhy2.zzc);
                return;
            }
            bl = false;
        }
        if (zzhy2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzn(String string, zzhy zzhy2) {
        ((zzgi)this).zzg();
        synchronized (this) {
            boolean bl;
            String string2 = this.zzl;
            if (string2 != null && !(bl = string2.equals(string))) {
                if (zzhy2 == null) return;
            }
            this.zzl = string;
            this.zzk = zzhy2;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @MainThread
    private final zzhy zzD(@NonNull Activity object) {
        void var1_3;
        Preconditions.checkNotNull((Object)object);
        Object object2 = this.zzd.get(object);
        if (object2 == null) {
            object2 = object.getClass();
            object2 = this.zzi((Class<?>)object2, "Activity");
            zzhy zzhy2 = new zzhy(null, (String)object2, this.zzs.zzl().zzd());
            this.zzd.put((Activity)object, zzhy2);
            zzhy zzhy3 = zzhy2;
        } else {
            zzhy zzhy4 = object2;
        }
        if (!this.zzs.zzc().zzn(null, zzea.zzar)) {
            return var1_3;
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return var1_3;
    }

    @MainThread
    public final void zzo(Activity activity, Bundle bundle) {
        if (!this.zzs.zzc().zzt()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        if ((bundle = bundle.getBundle("com.google.app_measurement.screen_service")) == null) {
            return;
        }
        zzhy zzhy2 = new zzhy(bundle.getString("name"), bundle.getString("referrer_name"), bundle.getLong("id"));
        this.zzd.put(activity, zzhy2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void zzq(Activity object) {
        Object object2;
        block12: {
            if (zze2.zzs.zzc().zzn(null, zzea.zzar)) {
                object2 = zze2.zzj;
                synchronized (object2) {
                    zze2.zzi = true;
                    Object object3 = zze2.zze;
                    if (object != object3) {
                        zzgk zzgk2;
                        Object object4;
                        object3 = zze2.zzj;
                        synchronized (object3) {
                            zze2.zze = object;
                            zze2.zzf = false;
                            // MONITOREXIT @DISABLED, blocks:[2, 6, 7, 10, 11] lbl12 : MonitorExitStatement: MONITOREXIT : var3_4
                            object3 = zze2.zzs.zzc();
                            object4 = zzea.zzaq;
                            boolean bl = ((zzae)object3).zzn(null, (zzdz<Boolean>)object4);
                            if (!bl || !(bl = zze2.zzs.zzc().zzt())) break block12;
                            zze2.zzg = null;
                            zzgk2 = zze2.zzs;
                            zzgk2 = ((zzfp)zzgk2).zzav();
                            object4 = new zzie((zzif)zze2);
                        }
                        ((zzfm)zzgk2).zzh((Runnable)object4);
                    }
                }
            }
        }
        if (zze2.zzs.zzc().zzn(null, zzea.zzaq) && !zze2.zzs.zzc().zzt()) {
            zze2.zzb = zze2.zzg;
            object = zze2.zzs;
            object = ((zzfp)object).zzav();
            object2 = new zzib((zzif)zze2);
            ((zzfm)object).zzh((Runnable)object2);
            return;
        }
        zze2.zzA((Activity)object, zze2.zzD((Activity)object), false);
        zze zze2 = zze2.zzs.zzB();
        object = zze2.zzs;
        object = ((zzfp)object).zzay();
        long l = object.elapsedRealtime();
        object = zze2.zzs;
        object = ((zzfp)object).zzav();
        object2 = new zzc((zzd)zze2, l);
        ((zzfm)object).zzh((Runnable)object2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void zzr(Activity object) {
        Object object2;
        if (this.zzs.zzc().zzn(null, zzea.zzar)) {
            object2 = this.zzj;
            synchronized (object2) {
                this.zzi = false;
                this.zzf = true;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
        }
        long l = this.zzs.zzay().elapsedRealtime();
        if (this.zzs.zzc().zzn(null, zzea.zzaq) && !this.zzs.zzc().zzt()) {
            this.zzb = null;
            object = this.zzs;
            object = ((zzfp)object).zzav();
            object2 = new zzic(this, l);
            ((zzfm)object).zzh((Runnable)object2);
            return;
        }
        object = this.zzD((Activity)object);
        this.zzc = this.zzb;
        this.zzb = null;
        object2 = this.zzs;
        object2 = ((zzfp)object2).zzav();
        zzid zzid2 = new zzid(this, (zzhy)object, l);
        ((zzfm)object2).zzh(zzid2);
    }

    @MainThread
    public final void zzs(Activity activity, Bundle bundle) {
        if (!((zzgi)((Object)zzhy2)).zzs.zzc().zzt()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzhy zzhy2 = ((zzif)((Object)zzhy2)).zzd.get(activity);
        if (zzhy2 == null) {
            return;
        }
        activity = new Bundle();
        activity.putLong("id", zzhy2.zzc);
        activity.putString("name", zzhy2.zza);
        activity.putString("referrer_name", zzhy2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", (Bundle)activity);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void zzt(Activity activity) {
        Object object = this.zzj;
        // MONITORENTER : object
        Activity activity2 = this.zze;
        if (activity == activity2) {
            this.zze = null;
            // MONITOREXIT : object
        }
        if (!this.zzs.zzc().zzt()) {
            return;
        }
        this.zzd.remove(activity);
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object
                throw throwable;
            }
        }
    }

    static /* synthetic */ void zzu(zzif zzif2, Bundle bundle, zzhy zzhy2, zzhy zzhy3, long l) {
        bundle.remove("screen_name");
        bundle.remove("screen_class");
        zzif2.zzB(zzhy2, zzhy3, l, true, zzif2.zzs.zzl().zzF(null, "screen_view", bundle, null, true));
    }

    static /* synthetic */ void zzv(zzif zzif2, zzhy zzhy2, zzhy zzhy3, long l, boolean bl, Bundle bundle) {
        zzif2.zzB(zzhy2, zzhy3, l, bl, null);
    }

    static /* synthetic */ zzhy zzx(zzif zzif2) {
        return zzif2.zzh;
    }

    static /* synthetic */ void zzy(zzif zzif2, zzhy zzhy2, boolean bl, long l) {
        zzif2.zzC(zzhy2, false, l);
    }

    static /* synthetic */ zzhy zzz(zzif zzif2, zzhy zzhy2) {
        zzif2.zzh = null;
        return null;
    }
}

