/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzlf;
import com.google.android.gms.internal.measurement.zzll;
import com.google.android.gms.internal.measurement.zzlo;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzee;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzz;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzfp
implements zzgk {
    private static volatile zzfp zzd;
    private final Context zze;
    private final String zzf;
    private final String zzg;
    private final String zzh;
    private final boolean zzi;
    private final zzz zzj;
    private final zzae zzk;
    private final zzfb zzl;
    private final zzem zzm;
    private final zzfm zzn;
    private final zzju zzo;
    private final zzkp zzp;
    private final zzeh zzq;
    private final Clock zzr;
    private final zzif zzs;
    private final zzhr zzt;
    private final zzd zzu;
    private final zzhv zzv;
    private final String zzw;
    private zzeg zzx;
    private zzjf zzy;
    private zzam zzz;
    private zzee zzA;
    private zzfe zzB;
    private boolean zzC;
    private Boolean zzD;
    private long zzE;
    private volatile Boolean zzF;
    @VisibleForTesting
    protected Boolean zza;
    @VisibleForTesting
    protected Boolean zzb;
    private volatile boolean zzG;
    private int zzH;
    private final AtomicInteger zzI;
    @VisibleForTesting
    final long zzc;

    /*
     * Enabled aggressive block sorting
     */
    zzfp(zzgr zzgr2) {
        Object object;
        block7: {
            block6: {
                long l;
                long l2;
                this.zzC = false;
                Object object2 = new AtomicInteger(0);
                this.zzI = object2;
                Preconditions.checkNotNull((Object)zzgr2);
                object2 = zzgr2.zza;
                object = new zzz((Context)object2);
                zzdy.zza = this.zzj = object;
                this.zze = zzgr2.zza;
                this.zzf = zzgr2.zzb;
                this.zzg = zzgr2.zzc;
                this.zzh = zzgr2.zzd;
                this.zzi = zzgr2.zzh;
                this.zzF = zzgr2.zze;
                this.zzw = zzgr2.zzj;
                this.zzG = true;
                object2 = zzgr2.zzg;
                if (object2 != null && (object = ((com.google.android.gms.internal.measurement.zzz)object2).zzg) != null) {
                    if ((object = object.get("measurementEnabled")) instanceof Boolean) {
                        this.zza = (Boolean)object;
                    }
                    if ((object2 = ((com.google.android.gms.internal.measurement.zzz)object2).zzg.get("measurementDeactivated")) instanceof Boolean) {
                        this.zzb = (Boolean)object2;
                    }
                }
                zzfh.zzb(this.zze);
                this.zzr = DefaultClock.getInstance();
                object2 = zzgr2.zzi;
                long l3 = object2 != null ? (l2 = ((Long)object2).longValue()) : (l = this.zzr.currentTimeMillis());
                this.zzc = l3;
                zzgi zzgi2 = new zzae(this);
                this.zzk = zzgi2;
                super(this);
                ((zzgj)zzgi2).zzx();
                this.zzl = zzgi2;
                super(this);
                ((zzgj)zzgi2).zzx();
                this.zzm = zzgi2;
                super(this);
                ((zzgj)zzgi2).zzx();
                this.zzp = zzgi2;
                super(this);
                ((zzgj)zzgi2).zzx();
                this.zzq = zzgi2;
                super(this);
                this.zzu = zzgi2;
                super(this);
                ((zzf)zzgi2).zzc();
                this.zzs = zzgi2;
                super(this);
                ((zzf)zzgi2).zzc();
                this.zzt = zzgi2;
                super(this);
                ((zzf)zzgi2).zzc();
                this.zzo = zzgi2;
                super(this);
                ((zzgj)zzgi2).zzx();
                this.zzv = zzgi2;
                super(this);
                ((zzgj)zzgi2).zzx();
                this.zzn = zzgi2;
                zzgi2 = zzgr2.zzg;
                boolean bl = zzgi2 != null ? ((com.google.android.gms.internal.measurement.zzz)zzgi2).zzb == 0L : true;
                if (!(this.zze.getApplicationContext() instanceof Application)) break block6;
                object = this.zzk();
                if (((zzgi)object).zzs.zze.getApplicationContext() instanceof Application) {
                    Application application = (Application)((zzgi)object).zzs.zze.getApplicationContext();
                    if (((zzhr)object).zza == null) {
                        zzhq zzhq2;
                        ((zzhr)object).zza = zzhq2 = new zzhq((zzhr)object, null);
                    }
                    if (bl) {
                        application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzhr)object).zza);
                        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzhr)object).zza);
                        ((zzgi)object).zzs.zzau().zzk().zza("Registered activity lifecycle callback");
                    }
                }
                break block7;
            }
            this.zzau().zze().zza("Application context is not an Application");
        }
        zzfm zzfm2 = this.zzn;
        object = new zzfo(this, zzgr2);
        zzfm2.zzh((Runnable)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    protected final void zza(com.google.android.gms.internal.measurement.zzz object) {
        Object object2;
        Object object3;
        block32: {
            block30: {
                block39: {
                    block40: {
                        block33: {
                            int n;
                            block29: {
                                block36: {
                                    block37: {
                                        block38: {
                                            block35: {
                                                int n2;
                                                block34: {
                                                    ((zzgi)this.zzav()).zzg();
                                                    zzlf.zzb();
                                                    if (!this.zzk.zzn(null, zzea.zzau)) break block32;
                                                    object3 = this.zzd().zzi();
                                                    Object object4 = this.zzd();
                                                    zzfp cfr_ignored_0 = ((zzgi)object4).zzs;
                                                    ((zzgi)object4).zzg();
                                                    n2 = ((zzfb)object4).zzd().getInt("consent_source", 100);
                                                    if (!this.zzk.zzn(null, zzea.zzav)) break block33;
                                                    object4 = this.zzk;
                                                    zzfp cfr_ignored_1 = ((zzgi)object4).zzs;
                                                    zzlf.zzb();
                                                    object4 = !((zzae)object4).zzn(null, zzea.zzav) ? null : ((zzae)object4).zzp("google_analytics_default_allow_ad_storage");
                                                    object2 = this.zzk;
                                                    zzfp cfr_ignored_2 = ((zzgi)object2).zzs;
                                                    zzlf.zzb();
                                                    object2 = !((zzae)object2).zzn(null, zzea.zzav) ? null : ((zzae)object2).zzp("google_analytics_default_allow_analytics_storage");
                                                    if (object4 == null && object2 == null || !this.zzd().zzh(-10)) break block34;
                                                    object = new zzaf((Boolean)object4, (Boolean)object2);
                                                    n = -10;
                                                    break block29;
                                                }
                                                if (TextUtils.isEmpty((CharSequence)this.zzA().zzj()) || n2 != 0 && n2 != 30 && n2 != 10 && n2 != 30 && n2 != 30 && n2 != 40) break block35;
                                                this.zzk().zzq(zzaf.zza, -10, this.zzc);
                                                object = null;
                                                n = 100;
                                                break block29;
                                            }
                                            zzlo.zzb();
                                            if (this.zzk.zzn(null, zzea.zzaF) && !TextUtils.isEmpty((CharSequence)this.zzA().zzj())) break block36;
                                            if (object == null) break block37;
                                            if (((com.google.android.gms.internal.measurement.zzz)object).zzg == null) break block38;
                                            if (this.zzd().zzh(30)) {
                                                object = zzaf.zzb(((com.google.android.gms.internal.measurement.zzz)object).zzg);
                                                if (!((zzaf)object).equals(zzaf.zza)) {
                                                    n = 30;
                                                    break block29;
                                                } else {
                                                    object = null;
                                                    n = 100;
                                                }
                                                break block29;
                                            } else {
                                                object = null;
                                                n = 100;
                                            }
                                            break block29;
                                        }
                                        object = null;
                                        n = 100;
                                        break block29;
                                    }
                                    object = null;
                                    n = 100;
                                    break block29;
                                }
                                object = null;
                                n = 100;
                            }
                            if (object != null) {
                                this.zzk().zzq((zzaf)object, n, this.zzc);
                                break block30;
                            } else {
                                object = object3;
                            }
                            break block30;
                        }
                        if (object == null) break block39;
                        if (((com.google.android.gms.internal.measurement.zzz)object).zzg == null) break block40;
                        if (this.zzd().zzh(30)) {
                            object = zzaf.zzb(((com.google.android.gms.internal.measurement.zzz)object).zzg);
                            if (!((zzaf)object).equals(zzaf.zza)) {
                                this.zzk().zzq((zzaf)object, 30, this.zzc);
                                break block30;
                            } else {
                                object = object3;
                            }
                            break block30;
                        } else {
                            object = object3;
                        }
                        break block30;
                    }
                    object = object3;
                    break block30;
                }
                object = object3;
            }
            this.zzk().zzr((zzaf)object);
        }
        if (this.zzd().zzc.zza() == 0L) {
            this.zzau().zzk().zzb("Persisting first open", this.zzc);
            this.zzd().zzc.zzb(this.zzc);
        }
        this.zzk().zzb.zzc();
        if (!this.zzL()) {
            if (this.zzF()) {
                if (!this.zzl().zzQ("android.permission.INTERNET")) {
                    this.zzau().zzb().zza("App is missing INTERNET permission");
                }
                if (!this.zzl().zzQ("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzau().zzb().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zze).isCallerInstantApp() && !this.zzk.zzy()) {
                    if (!zzkp.zzam(this.zze)) {
                        this.zzau().zzb().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzkp.zzP(this.zze, false)) {
                        this.zzau().zzb().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzau().zzb().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            block31: {
                if (!TextUtils.isEmpty((CharSequence)this.zzA().zzj()) || !TextUtils.isEmpty((CharSequence)this.zzA().zzk())) {
                    object = this.zzl();
                    Object object5 = this.zzA();
                    object5 = ((zzee)object5).zzj();
                    object2 = this.zzd();
                    ((zzgi)object2).zzg();
                    object2 = ((zzfb)object2).zzd();
                    object2 = object2.getString("gmp_app_id", null);
                    object3 = this.zzA();
                    object3 = ((zzee)object3).zzk();
                    zzfb zzfb2 = this.zzd();
                    zzfb2.zzg();
                    if (((zzkp)object).zzB((String)object5, (String)object2, (String)object3, zzfb2.zzd().getString("admob_app_id", null))) {
                        this.zzau().zzi().zza("Rechecking which service to use due to a GMP App Id change");
                        object = this.zzd();
                        ((zzgi)object).zzg();
                        object5 = ((zzfb)object).zzf();
                        object2 = ((zzfb)object).zzd().edit();
                        object2.clear();
                        object2.apply();
                        if (object5 != null) {
                            ((zzfb)object).zze((Boolean)object5);
                        }
                        this.zzn().zzh();
                        this.zzy.zzF();
                        this.zzy.zzB();
                        this.zzd().zzc.zzb(this.zzc);
                        this.zzd().zze.zzb(null);
                    }
                    object = this.zzd();
                    object5 = this.zzA();
                    object5 = ((zzee)object5).zzj();
                    ((zzgi)object).zzg();
                    object = ((zzfb)object).zzd().edit();
                    object.putString("gmp_app_id", (String)object5);
                    object.apply();
                    object = this.zzd();
                    object5 = this.zzA();
                    object5 = ((zzee)object5).zzk();
                    ((zzgi)object).zzg();
                    object = ((zzfb)object).zzd().edit();
                    object.putString("admob_app_id", (String)object5);
                    object.apply();
                }
                zzlf.zzb();
                if (this.zzk.zzn(null, zzea.zzau) && !this.zzd().zzi().zzh()) {
                    this.zzd().zze.zzb(null);
                }
                this.zzk().zzE(this.zzd().zze.zza());
                zzll.zzb();
                if (this.zzk.zzn(null, zzea.zzam)) {
                    object = this.zzl();
                    try {
                        object = ((zzgi)object).zzs;
                        object = ((zzfp)object).zze;
                        object.getClassLoader().loadClass("com.google.firebase.remoteconfig.FirebaseRemoteConfig");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (TextUtils.isEmpty((CharSequence)this.zzd().zzo.zza())) break block31;
                        this.zzau().zze().zza("Remote config removed with active feature rollouts");
                        this.zzd().zzo.zzb(null);
                    }
                }
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzA().zzj()) || !TextUtils.isEmpty((CharSequence)this.zzA().zzk())) {
                boolean bl = this.zzF();
                if (!this.zzd().zzk() && !this.zzk.zzr()) {
                    this.zzd().zzj(bl ^ true);
                }
                if (bl) {
                    this.zzk().zzH();
                }
                this.zzh().zza.zza();
                zzjf zzjf2 = this.zzy();
                AtomicReference<String> atomicReference = new AtomicReference<String>();
                zzjf2.zzv(atomicReference);
                this.zzy().zzA(this.zzd().zzr.zza());
            }
        }
        this.zzd().zzi.zzb(true);
    }

    @Override
    @Pure
    public final zzz zzat() {
        return this.zzj;
    }

    @Pure
    public final zzae zzc() {
        return this.zzk;
    }

    @Pure
    public final zzfb zzd() {
        zzfp.zzQ(this.zzl);
        return this.zzl;
    }

    @Override
    @Pure
    public final zzem zzau() {
        zzfp.zzS(this.zzm);
        return this.zzm;
    }

    public final zzem zzf() {
        zzem zzem2 = this.zzm;
        if (zzem2 != null && zzem2.zzu()) {
            return this.zzm;
        }
        return null;
    }

    @Override
    @Pure
    public final zzfm zzav() {
        zzfp.zzS(this.zzn);
        return this.zzn;
    }

    @Pure
    public final zzju zzh() {
        zzfp.zzR(this.zzo);
        return this.zzo;
    }

    @SideEffectFree
    public final zzfe zzi() {
        return this.zzB;
    }

    @SideEffectFree
    final zzfm zzj() {
        return this.zzn;
    }

    @Pure
    public final zzhr zzk() {
        zzfp.zzR(this.zzt);
        return this.zzt;
    }

    @Pure
    public final zzkp zzl() {
        zzfp.zzQ(this.zzp);
        return this.zzp;
    }

    @Pure
    public final zzeh zzm() {
        zzfp.zzQ(this.zzq);
        return this.zzq;
    }

    @Pure
    public final zzeg zzn() {
        zzfp.zzR(this.zzx);
        return this.zzx;
    }

    @Pure
    public final zzhv zzo() {
        zzfp.zzS(this.zzv);
        return this.zzv;
    }

    @Override
    @Pure
    public final Context zzax() {
        return this.zze;
    }

    @Pure
    public final boolean zzq() {
        return TextUtils.isEmpty((CharSequence)this.zzf);
    }

    @Pure
    public final String zzr() {
        return this.zzf;
    }

    @Pure
    public final String zzs() {
        return this.zzg;
    }

    @Pure
    public final String zzt() {
        return this.zzh;
    }

    @Pure
    public final boolean zzu() {
        return this.zzi;
    }

    @Pure
    public final String zzv() {
        return this.zzw;
    }

    @Override
    @Pure
    public final Clock zzay() {
        return this.zzr;
    }

    @Pure
    public final zzif zzx() {
        zzfp.zzR(this.zzs);
        return this.zzs;
    }

    @Pure
    public final zzjf zzy() {
        zzfp.zzR(this.zzy);
        return this.zzy;
    }

    @Pure
    public final zzam zzz() {
        zzfp.zzS(this.zzz);
        return this.zzz;
    }

    @Pure
    public final zzee zzA() {
        zzfp.zzR(this.zzA);
        return this.zzA;
    }

    @Pure
    public final zzd zzB() {
        Object object = ((zzfp)object).zzu;
        if (object == null) {
            object = new IllegalStateException("Component not created");
            throw object;
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static zzfp zzC(Context object, com.google.android.gms.internal.measurement.zzz zzz2, Long l) {
        Object object2;
        if (zzz2 != null && (zzz2.zze == null || zzz2.zzf == null)) {
            zzz2 = object2 = new com.google.android.gms.internal.measurement.zzz(zzz2.zza, zzz2.zzb, zzz2.zzc, zzz2.zzd, null, null, zzz2.zzg, null);
        }
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.getApplicationContext());
        if (zzd == null) {
            object2 = zzfp.class;
            // MONITORENTER : object2
            Object object3 = zzd;
            if (object3 == null) {
                object3 = new zzgr((Context)object, zzz2, l);
                object = new zzfp((zzgr)object3);
                zzd = object;
            }
            // MONITOREXIT : object2
        } else if (zzz2 != null && (object = zzz2.zzg) != null && object.containsKey("dataCollectionDefaultEnabled")) {
            Preconditions.checkNotNull((Object)zzd);
            zzfp.zzd.zzF = zzz2.zzg.getBoolean("dataCollectionDefaultEnabled");
        }
        Preconditions.checkNotNull((Object)zzd);
        return zzd;
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object2
                throw throwable;
            }
        }
    }

    @WorkerThread
    final void zzD(boolean bl) {
        this.zzF = bl;
    }

    @WorkerThread
    public final boolean zzE() {
        return this.zzF != null && this.zzF != false;
    }

    @WorkerThread
    public final boolean zzF() {
        return this.zzG() == 0;
    }

    @WorkerThread
    public final int zzG() {
        block12: {
            block14: {
                Object object;
                block13: {
                    ((zzgi)this.zzav()).zzg();
                    if (this.zzk.zzr()) {
                        return 1;
                    }
                    object = this.zzb;
                    if (object != null && ((Boolean)object).booleanValue()) break block12;
                    zzlf.zzb();
                    if (!this.zzk.zzn(null, zzea.zzau)) break block13;
                    ((zzgi)this.zzav()).zzg();
                    if (!this.zzG) break block14;
                }
                if ((object = this.zzd().zzf()) != null) {
                    if (((Boolean)object).booleanValue()) {
                        return 0;
                    }
                    return 3;
                }
                object = this.zzk;
                zzz cfr_ignored_0 = ((zzgi)object).zzs.zzj;
                object = ((zzae)object).zzp("firebase_analytics_collection_enabled");
                if (object != null) {
                    if (((Boolean)object).booleanValue()) {
                        return 0;
                    }
                    return 4;
                }
                object = this.zza;
                if (object != null) {
                    if (((Boolean)object).booleanValue()) {
                        return 0;
                    }
                    return 5;
                }
                if (this.zzk.zzn(null, zzea.zzS) && this.zzF != null) {
                    if (this.zzF.booleanValue()) {
                        return 0;
                    }
                    return 7;
                }
                return 0;
            }
            return 8;
        }
        return 2;
    }

    @WorkerThread
    public final void zzH(boolean bl) {
        ((zzgi)this.zzav()).zzg();
        this.zzG = bl;
    }

    @WorkerThread
    public final boolean zzI() {
        ((zzgi)this.zzav()).zzg();
        return this.zzG;
    }

    final void zzJ() {
        ++this.zzH;
    }

    final void zzK() {
        this.zzI.incrementAndGet();
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    protected final boolean zzL() {
        if (!((zzfp)object).zzC) {
            Object object = new IllegalStateException("AppMeasurement is not initialized");
            throw object;
        }
        ((zzgi)((zzfp)object).zzav()).zzg();
        Boolean bl = ((zzfp)object).zzD;
        if (bl == null || ((zzfp)object).zzE == 0L || !bl.booleanValue() && Math.abs(((zzfp)object).zzr.elapsedRealtime() - ((zzfp)object).zzE) > 1000L) {
            ((zzfp)object).zzE = ((zzfp)object).zzr.elapsedRealtime();
            boolean bl2 = ((zzfp)object).zzl().zzQ("android.permission.INTERNET") ? (((zzfp)object).zzl().zzQ("android.permission.ACCESS_NETWORK_STATE") ? (!Wrappers.packageManager((Context)((zzfp)object).zze).isCallerInstantApp() ? (!((zzfp)object).zzk.zzy() ? (zzkp.zzam(((zzfp)object).zze) ? zzkp.zzP(((zzfp)object).zze, false) : false) : true) : true) : false) : false;
            ((zzfp)object).zzD = bl2;
            if (((zzfp)object).zzD.booleanValue()) {
                bl2 = !((zzfp)object).zzl().zzA(((zzfp)object).zzA().zzj(), ((zzfp)object).zzA().zzk(), ((zzfp)object).zzA().zzl()) ? !TextUtils.isEmpty((CharSequence)((zzfp)object).zzA().zzk()) : true;
                ((zzfp)object).zzD = bl2;
            }
        }
        return ((zzfp)object).zzD;
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    public final void zzM() {
        this.zzav().zzg();
        zzfp.zzS(this.zzo());
        var2_1 = this.zzA().zzi();
        var3_2 = this.zzd().zzb(var2_1);
        if (!this.zzk.zzs() || ((Boolean)var3_2.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)var3_2.first))) {
            this.zzau().zzj().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        var1_3 = this.zzo();
        var1_3.zzv();
        var1_3 = (ConnectivityManager)var1_3.zzs.zze.getSystemService("connectivity");
        if (var1_3 != null) {
            var1_3 = var1_3.getActiveNetworkInfo();
lbl14:
            // 3 sources

            while (true) {
                if (var1_3 != null && var1_3.isConnected()) {
                    var1_3 = this.zzl();
                    this.zzA().zzs.zzk.zzf();
                    var1_3 = var1_3.zzal(39065L, var2_1, (String)var3_2.first, this.zzd().zzn.zza() + -1L);
                    if (var1_3 != null) {
                        var3_2 = this.zzo();
                        var4_4 = new zzfn((zzfp)this);
                        var3_2.zzg();
                        var3_2.zzv();
                        Preconditions.checkNotNull((Object)var1_3);
                        Preconditions.checkNotNull((Object)var4_4);
                        this = var3_2.zzs;
                        this = this.zzav();
                        var5_5 = new zzhu((zzhv)var3_2, var2_1, (URL)var1_3, null, null, var4_4, null);
                        this.zzk(var5_5);
                        return;
                    }
                    return;
                }
                this.zzau().zze().zza("Network is not available for Deferred Deep Link request. Skipping");
                return;
            }
        }
        var1_3 = null;
        ** GOTO lbl14
        catch (SecurityException v0) {
            var1_3 = null;
            ** continue;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzN(String string, int n, Throwable object, byte[] byArray, Map map) {
        Object object2;
        int n2;
        block17: {
            block12: {
                block11: {
                    double d;
                    String string2;
                    block19: {
                        block18: {
                            boolean bl;
                            block16: {
                                block13: {
                                    block14: {
                                        block15: {
                                            if (n == 200) break block13;
                                            if (n == 204) break block14;
                                            if (n != 304) break block15;
                                            n2 = 304;
                                            break block16;
                                        }
                                        n2 = n;
                                        break block17;
                                    }
                                    n2 = n;
                                    break block16;
                                }
                                n2 = n;
                            }
                            if (object != null) break block17;
                            this.zzd().zzm.zzb(true);
                            if (byArray == null || byArray.length == 0) {
                                this.zzau().zzj().zza("Deferred Deep Link response empty.");
                                return;
                            }
                            string2 = new String(byArray);
                            JSONObject jSONObject = new JSONObject(string2);
                            string2 = jSONObject.optString("deeplink", "");
                            object = jSONObject.optString("gclid", "");
                            d = jSONObject.optDouble("timestamp", 0.0);
                            boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
                            if (bl2) {
                                this.zzau().zzj().zza("Deferred Deep Link is empty.");
                                return;
                            }
                            Object object3 = this.zzl();
                            zzfp cfr_ignored_0 = ((zzgi)object3).zzs;
                            boolean bl3 = TextUtils.isEmpty((CharSequence)string2);
                            if (bl3) break block18;
                            object3 = ((zzgi)object3).zzs;
                            object3 = ((zzfp)object3).zze;
                            object3 = object3.getPackageManager();
                            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
                            if ((object3 = object3.queryIntentActivities(intent, 0)) != null && !(bl = object3.isEmpty())) break block19;
                        }
                        this.zzau().zze().zzc("Deferred Deep Link validation failed. gclid, deep link", object, string2);
                        return;
                    }
                    object2 = new Bundle();
                    object2.putString("gclid", (String)object);
                    object2.putString("_cis", "ddp");
                    this.zzt.zzs("auto", "_cmp", (Bundle)object2);
                    object2 = this.zzl();
                    boolean bl = TextUtils.isEmpty((CharSequence)string2);
                    if (bl) break block11;
                    {
                        catch (JSONException jSONException) {
                            this.zzau().zzb().zzb("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
                            return;
                        }
                    }
                    zzfp zzfp2 = object2.zzs;
                    zzfp2 = zzfp2.zze;
                    zzfp2 = zzfp2.getSharedPreferences("google.analytics.deferred.deeplink.prefs", 0).edit();
                    zzfp2.putString("deeplink", string2);
                    zzfp2.putLong("timestamp", Double.doubleToRawLongBits(d));
                    boolean bl4 = zzfp2.commit();
                    if (bl4) break block12;
                }
                return;
            }
            Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
            object2 = object2.zzs;
            object2 = object2.zze;
            object2.sendBroadcast(intent);
            return;
        }
        this.zzau().zze().zzc("Network Request for Deferred Deep Link failed. response, exception", n2, object);
        return;
        catch (Exception exception) {
            object2.zzs.zzau().zzb().zzb("Failed to persist Deferred Deep Link. exception", exception);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* synthetic */ void zzO(zzfp zzfp2, zzgr object) {
        ((zzgi)zzfp2.zzav()).zzg();
        zzfp2.zzk.zzb();
        Object object2 = new zzam(zzfp2);
        ((zzgj)object2).zzx();
        zzfp2.zzz = object2;
        object2 = new zzee(zzfp2, ((zzgr)object).zzf);
        ((zzf)object2).zzc();
        zzfp2.zzA = object2;
        object = new zzeg(zzfp2);
        ((zzf)object).zzc();
        zzfp2.zzx = object;
        object = new zzjf(zzfp2);
        ((zzf)object).zzc();
        zzfp2.zzy = object;
        zzfp2.zzp.zzy();
        zzfp2.zzl.zzy();
        zzfp2.zzB = object = new zzfe(zzfp2);
        zzfp2.zzA.zzd();
        object = zzfp2.zzau();
        object = ((zzem)object).zzi();
        zzfp2.zzk.zzf();
        ((zzek)object).zzb("App measurement initialized, version", 39065L);
        zzfp2.zzau().zzi().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        object = ((zzee)object2).zzi();
        if (TextUtils.isEmpty((CharSequence)zzfp2.zzf)) {
            if (zzfp2.zzl().zzT((String)object)) {
                zzfp2.zzau().zzi().zza("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
            } else {
                object2 = zzfp2.zzau().zzi();
                object = String.valueOf(object);
                String string = "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ";
                object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
                ((zzek)object2).zza((String)object);
            }
        }
        zzfp2.zzau().zzj().zza("Debug-level message logging enabled");
        if (zzfp2.zzH != zzfp2.zzI.get()) {
            zzfp2.zzau().zzb().zzc("Not all components initialized", zzfp2.zzH, zzfp2.zzI.get());
        }
        zzfp2.zzC = true;
    }

    private static final void zzQ(zzgi object) {
        if (object == null) {
            object = new IllegalStateException("Component not created");
            throw object;
        }
    }

    private static final void zzR(zzf object) {
        if (object == null) {
            object = new IllegalStateException("Component not created");
            throw object;
        }
        if (!((zzf)object).zza()) {
            object = String.valueOf(object.getClass());
            String string = String.valueOf(object);
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n + 27);
            stringBuilder.append("Component not initialized: ");
            stringBuilder.append((String)object);
            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
            throw illegalStateException;
        }
    }

    private static final void zzS(zzgj object) {
        if (object == null) {
            object = new IllegalStateException("Component not created");
            throw object;
        }
        if (!((zzgj)object).zzu()) {
            object = String.valueOf(object.getClass());
            String string = String.valueOf(object);
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n + 27);
            stringBuilder.append("Component not initialized: ");
            stringBuilder.append((String)object);
            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
            throw illegalStateException;
        }
    }

    static final void zzP() {
        IllegalStateException illegalStateException = new IllegalStateException("Unexpected call on client side");
        throw illegalStateException;
    }
}

