/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzfm
extends zzgj {
    @Nullable
    private zzfl zza;
    @Nullable
    private zzfl zzb;
    private final PriorityBlockingQueue<zzfk<?>> zzc;
    private final BlockingQueue<zzfk<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg;
    private final Semaphore zzh;
    private volatile boolean zzi;
    private static final AtomicLong zzj;

    zzfm(zzfp object) {
        super((zzfp)object);
        this.zzg = object = new Object();
        this.zzh = object = new Semaphore(2);
        object = new PriorityBlockingQueue();
        this.zzc = object;
        super();
        this.zzd = object;
        this.zze = object = new zzfj(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = object = new zzfj(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zza() {
        return false;
    }

    @Override
    public final void zzg() {
        if (Thread.currentThread() != ((zzfm)object).zza) {
            Object object = new IllegalStateException("Call expected from worker thread");
            throw object;
        }
    }

    @Override
    public final void zzaw() {
        if (Thread.currentThread() != ((zzfm)object).zzb) {
            Object object = new IllegalStateException("Call expected from network thread");
            throw object;
        }
    }

    public final boolean zzd() {
        return Thread.currentThread() == this.zza;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull(callable);
        zzfk zzfk2 = new zzfk(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                this.zzs.zzau().zze().zza("Callable skipped the worker queue.");
            }
            zzfk2.run();
            return zzfk2;
        }
        this.zzt(zzfk2);
        return zzfk2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <V> Future<V> zzf(Callable<V> callable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull(callable);
        zzfk zzfk2 = new zzfk(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzfk2.run();
            return zzfk2;
        }
        this.zzt(zzfk2);
        return zzfk2;
    }

    public final void zzh(Runnable runnable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)runnable);
        zzfk zzfk2 = new zzfk(this, runnable, false, "Task exception on worker thread");
        this.zzt(zzfk2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nullable
    final <T> T zzi(AtomicReference<T> atomicReference, long l, String string, Runnable object) {
        Object object2;
        block9: {
            // MONITORENTER : atomicReference
            zzfm zzfm2 = ((zzgi)object2).zzs.zzav();
            zzfm2.zzh((Runnable)object);
            try {
                atomicReference.wait(l);
                // MONITOREXIT : atomicReference
                atomicReference = atomicReference.get();
                if (atomicReference != null) return (T)atomicReference;
                object = ((zzgi)object2).zzs.zzau().zze();
                object2 = "Timed out waiting for ";
                if (string.length() != 0) {
                    object2 = ((String)object2).concat(string);
                    break block9;
                }
                string = new String((String)object2);
                object2 = string;
            }
            catch (InterruptedException interruptedException) {
                object2 = ((zzgi)object2).zzs.zzau();
                object = ((zzem)object2).zze();
                object2 = "Interrupted waiting for ";
                int n = string.length();
                if (n != 0) {
                    object2 = ((String)object2).concat(string);
                } else {
                    string = new String((String)object2);
                    object2 = string;
                }
                ((zzek)object).zza((String)object2);
                // MONITOREXIT : atomicReference
                return null;
            }
        }
        ((zzek)object).zza((String)object2);
        return (T)atomicReference;
    }

    public final void zzj(Runnable runnable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)runnable);
        zzfk zzfk2 = new zzfk(this, runnable, true, "Task exception on worker thread");
        this.zzt(zzfk2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzt(zzfk<?> runnable) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add((zzfk<?>)runnable);
            runnable = this.zza;
            if (runnable == null) {
                runnable = new Runnable(this, "Measurement Worker", this.zzc);
                this.zza = runnable;
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                ((zzfl)runnable).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzk(Runnable object) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)object);
        Runnable runnable = new Runnable(this, (Runnable)object, false, "Task exception on network thread");
        object = this.zzg;
        synchronized (object) {
            this.zzd.add((zzfk<?>)runnable);
            runnable = this.zzb;
            if (runnable == null) {
                runnable = new Runnable(this, "Measurement Network", this.zzd);
                this.zzb = runnable;
                this.zzb.setUncaughtExceptionHandler(this.zzf);
                this.zzb.start();
            } else {
                ((zzfl)runnable).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static /* synthetic */ Semaphore zzl(zzfm zzfm2) {
        return zzfm2.zzh;
    }

    static /* synthetic */ boolean zzm(zzfm zzfm2) {
        boolean cfr_ignored_0 = zzfm2.zzi;
        return false;
    }

    static /* synthetic */ Object zzn(zzfm zzfm2) {
        return zzfm2.zzg;
    }

    static /* synthetic */ zzfl zzo(zzfm zzfm2) {
        return zzfm2.zza;
    }

    static /* synthetic */ zzfl zzp(zzfm zzfm2, zzfl zzfl2) {
        zzfm2.zza = null;
        return null;
    }

    static /* synthetic */ zzfl zzq(zzfm zzfm2) {
        return zzfm2.zzb;
    }

    static /* synthetic */ zzfl zzr(zzfm zzfm2, zzfl zzfl2) {
        zzfm2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzs() {
        return zzj;
    }

    static {
        AtomicLong atomicLong;
        zzj = atomicLong = new AtomicLong(Long.MIN_VALUE);
    }
}

