/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzz;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzkl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Deprecated
@ShowFirstParty
@KeepForSdk
public class AppMeasurement {
    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public static final String CRASH_ORIGIN = "crash";
    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public static final String FCM_ORIGIN = "fcm";
    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public static final String FIAM_ORIGIN = "fiam";
    private static volatile AppMeasurement zza;
    private final zzfp zzb;
    private final zzhs zzc;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @ShowFirstParty
    @Keep
    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @RecentlyNonNull
    public static AppMeasurement getInstance(@RecentlyNonNull Context context) {
        if (zza == null) {
            Class<AppMeasurement> clazz = AppMeasurement.class;
            synchronized (clazz) {
                Object object = zza;
                if (object == null) {
                    Object object2;
                    block10: {
                        try {
                            object = Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            object = null;
                            break block10;
                        }
                        try {
                            Object[] objectArray = new Class[]{Context.class, Bundle.class};
                            object = ((Class)object).getDeclaredMethod("getScionFrontendApiImplementation", (Class<?>[])objectArray);
                            objectArray = new Object[]{object2, null};
                            object = (zzhs)((Method)object).invoke(null, objectArray);
                        }
                        catch (Exception exception) {
                            object = null;
                        }
                    }
                    if (object != null) {
                        object2 = new AppMeasurement((zzhs)object);
                        zza = object2;
                    } else {
                        object = new zzz(0L, 0L, true, null, null, null, null, null);
                        object2 = zzfp.zzC(object2, (zzz)object, null);
                        zza = object = new AppMeasurement((zzfp)object2);
                    }
                }
            }
        }
        return zza;
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @Keep
    public void logEventInternal(@RecentlyNonNull String origin, @RecentlyNonNull String name, @RecentlyNonNull Bundle params) {
        void var3_3;
        void var2_2;
        void var1_1;
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            zzhs2.zza((String)var1_1, (String)var2_2, (Bundle)var3_3);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzs((String)var1_1, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public void logEventInternalNoInterceptor(@RecentlyNonNull String origin, @RecentlyNonNull String name, @RecentlyNonNull Bundle params, long timestampInMillis) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            zzhs2.zzb((String)var1_1, (String)var2_2, (Bundle)var3_3, (long)var4_4);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzv((String)var1_1, (String)var2_2, (Bundle)var3_3, true, false, (long)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public Map<String, Object> getUserProperties(boolean includeInternal) {
        void var1_1;
        Object object = ((AppMeasurement)((Object)this_)).zzc;
        if (object != null) {
            return object.zzc(null, null, (boolean)var1_1);
        }
        Preconditions.checkNotNull((Object)((AppMeasurement)((Object)this_)).zzb);
        Iterator this_ = ((AppMeasurement)((Object)this_)).zzb.zzk().zzC((boolean)var1_1);
        ArrayMap arrayMap = new ArrayMap(this_.size());
        this_ = this_.iterator();
        while (this_.hasNext()) {
            object = (zzkl)((Object)this_.next());
            Object object2 = object.zza();
            if (object2 == null) continue;
            arrayMap.put(object.zzb, object2);
        }
        return arrayMap;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(@RecentlyNonNull EventInterceptor interceptor) {
        void var1_1;
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            zzhs2.zzd((zzgp)var1_1);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzI((zzgp)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(@RecentlyNonNull OnEventListener listener) {
        void var1_1;
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            zzhs2.zze((zzgq)var1_1);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzJ((zzgq)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(@RecentlyNonNull OnEventListener listener) {
        void var1_1;
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            zzhs2.zzf((zzgq)var1_1);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzK((zzgq)var1_1);
    }

    @Keep
    @RecentlyNonNull
    public String getCurrentScreenName() {
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            return zzhs2.zzg();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzR();
    }

    @Keep
    @RecentlyNonNull
    public String getCurrentScreenClass() {
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            return zzhs2.zzh();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzS();
    }

    @Keep
    @RecentlyNonNull
    public String getAppInstanceId() {
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            return zzhs2.zzi();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzD();
    }

    @Keep
    @RecentlyNonNull
    public String getGmpAppId() {
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            return zzhs2.zzj();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzT();
    }

    @Keep
    public long generateEventId() {
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            return zzhs2.zzk();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzl().zzd();
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void beginAdUnitExposure(@RecentlyNonNull @Size(min=1L) String adUnitId) {
        void var1_1;
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            zzhs2.zzl((String)var1_1);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzB().zza((String)var1_1, this.zzb.zzay().elapsedRealtime());
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void endAdUnitExposure(@RecentlyNonNull @Size(min=1L) String adUnitId) {
        void var1_1;
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            zzhs2.zzm((String)var1_1);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzB().zzb((String)var1_1, this.zzb.zzay().elapsedRealtime());
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void setConditionalUserProperty(@RecentlyNonNull ConditionalUserProperty conditionalUserProperty) {
        void var1_1;
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            zzhs2.zzn(var1_1.zza());
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzM(var1_1.zza());
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void clearConditionalUserProperty(@RecentlyNonNull @Size(min=1L, max=24L) String userPropertyName, @RecentlyNonNull String clearEventName, @RecentlyNonNull Bundle clearEventParams) {
        void var3_3;
        void var2_2;
        void var1_1;
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            zzhs2.zzo((String)var1_1, (String)var2_2, (Bundle)var3_3);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzO((String)var1_1, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @Keep
    @VisibleForTesting
    @RecentlyNonNull
    protected Map<String, Object> getUserProperties(@RecentlyNonNull String origin, @Size(min=1L, max=24L) @RecentlyNonNull String propertyNamePrefix, boolean includeInternal) {
        void var3_3;
        void var2_2;
        void var1_1;
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            return zzhs2.zzc((String)var1_1, (String)var2_2, (boolean)var3_3);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzQ((String)var1_1, (String)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public List<ConditionalUserProperty> getConditionalUserProperties(@RecentlyNonNull String origin, @Size(min=1L, max=23L) @RecentlyNonNull String propertyNamePrefix) {
        void var1_3;
        Object this_;
        ArrayList<ConditionalUserProperty> arrayList;
        void var1_1;
        zzhs zzhs2 = ((AppMeasurement)this_).zzc;
        if (zzhs2 != null) {
            this_ = zzhs2.zzp((String)var1_1, (String)((Object)arrayList));
        } else {
            Preconditions.checkNotNull((Object)((AppMeasurement)this_).zzb);
            this_ = ((AppMeasurement)this_).zzb.zzk().zzP((String)var1_1, (String)((Object)arrayList));
        }
        if (this_ == null) {
            boolean bl = false;
        } else {
            int n = this_.size();
        }
        arrayList = new ArrayList<ConditionalUserProperty>((int)var1_3);
        this_ = this_.iterator();
        while (this_.hasNext()) {
            Object e = this_.next();
            Bundle bundle = (Bundle)e;
            ConditionalUserProperty conditionalUserProperty = new ConditionalUserProperty(bundle);
            arrayList.add(conditionalUserProperty);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public int getMaxUserProperties(@RecentlyNonNull @Size(min=1L) String origin) {
        void var1_1;
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            return zzhs2.zzq((String)var1_1);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzL((String)var1_1);
        return 25;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Boolean getBoolean() {
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            return (Boolean)zzhs2.zzr(4);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzi();
    }

    @KeepForSdk
    @RecentlyNonNull
    public String getString() {
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            return (String)zzhs2.zzr(0);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzj();
    }

    @KeepForSdk
    @RecentlyNonNull
    public Long getLong() {
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            return (Long)zzhs2.zzr(1);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzk();
    }

    @KeepForSdk
    @RecentlyNonNull
    public Integer getInteger() {
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            return (Integer)zzhs2.zzr(3);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzl();
    }

    @KeepForSdk
    @RecentlyNonNull
    public Double getDouble() {
        zzhs zzhs2 = this.zzc;
        if (zzhs2 != null) {
            return (Double)zzhs2.zzr(2);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzm();
    }

    public AppMeasurement(zzfp zzfp2) {
        Preconditions.checkNotNull((Object)zzfp2);
        this.zzb = zzfp2;
        this.zzc = null;
    }

    public AppMeasurement(zzhs zzhs2) {
        Preconditions.checkNotNull((Object)zzhs2);
        this.zzc = zzhs2;
        this.zzb = null;
    }

    @ShowFirstParty
    @KeepForSdk
    public static class ConditionalUserProperty {
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @RecentlyNonNull
        public String mAppId;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @RecentlyNonNull
        public String mOrigin;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @RecentlyNonNull
        public String mName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @RecentlyNonNull
        public Object mValue;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @RecentlyNonNull
        public String mTriggerEventName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggerTimeout;
        @Keep
        @RecentlyNonNull
        public String mTimedOutEventName;
        @Keep
        @RecentlyNonNull
        public Bundle mTimedOutEventParams;
        @Keep
        @RecentlyNonNull
        public String mTriggeredEventName;
        @Keep
        @RecentlyNonNull
        public Bundle mTriggeredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTimeToLive;
        @Keep
        @RecentlyNonNull
        public String mExpiredEventName;
        @Keep
        @RecentlyNonNull
        public Bundle mExpiredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mCreationTimestamp;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public boolean mActive;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggeredTimestamp;

        @KeepForSdk
        public ConditionalUserProperty() {
        }

        @KeepForSdk
        public ConditionalUserProperty(@RecentlyNonNull ConditionalUserProperty other) {
            Bundle bundle;
            Bundle bundle2;
            Preconditions.checkNotNull((Object)bundle2);
            this.mAppId = bundle2.mAppId;
            this.mOrigin = bundle2.mOrigin;
            this.mCreationTimestamp = bundle2.mCreationTimestamp;
            this.mName = bundle2.mName;
            Object object = bundle2.mValue;
            if (object != null) {
                this.mValue = zzhx.zzb((Object)object);
                if (this.mValue == null) {
                    this.mValue = bundle2.mValue;
                }
            }
            this.mActive = bundle2.mActive;
            this.mTriggerEventName = bundle2.mTriggerEventName;
            this.mTriggerTimeout = bundle2.mTriggerTimeout;
            this.mTimedOutEventName = bundle2.mTimedOutEventName;
            object = bundle2.mTimedOutEventParams;
            if (object != null) {
                this.mTimedOutEventParams = bundle = new Bundle((Bundle)object);
            }
            this.mTriggeredEventName = bundle2.mTriggeredEventName;
            object = bundle2.mTriggeredEventParams;
            if (object != null) {
                this.mTriggeredEventParams = bundle = new Bundle((Bundle)object);
            }
            this.mTriggeredTimestamp = bundle2.mTriggeredTimestamp;
            this.mTimeToLive = bundle2.mTimeToLive;
            this.mExpiredEventName = bundle2.mExpiredEventName;
            bundle2 = bundle2.mExpiredEventParams;
            if (bundle2 != null) {
                object = new Bundle(bundle2);
                this.mExpiredEventParams = object;
                return;
            }
        }

        @VisibleForTesting
        ConditionalUserProperty(@NonNull Bundle bundle) {
            Preconditions.checkNotNull((Object)bundle);
            this.mAppId = (String)zzgl.zzb((Bundle)bundle, (String)"app_id", String.class, null);
            this.mOrigin = (String)zzgl.zzb((Bundle)bundle, (String)"origin", String.class, null);
            this.mName = (String)zzgl.zzb((Bundle)bundle, (String)"name", String.class, null);
            this.mValue = zzgl.zzb((Bundle)bundle, (String)"value", Object.class, null);
            this.mTriggerEventName = (String)zzgl.zzb((Bundle)bundle, (String)"trigger_event_name", String.class, null);
            Long l = 0L;
            this.mTriggerTimeout = (Long)zzgl.zzb((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)l);
            this.mTimedOutEventName = (String)zzgl.zzb((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
            this.mTimedOutEventParams = (Bundle)zzgl.zzb((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
            this.mTriggeredEventName = (String)zzgl.zzb((Bundle)bundle, (String)"triggered_event_name", String.class, null);
            this.mTriggeredEventParams = (Bundle)zzgl.zzb((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
            this.mTimeToLive = (Long)zzgl.zzb((Bundle)bundle, (String)"time_to_live", Long.class, (Object)l);
            this.mExpiredEventName = (String)zzgl.zzb((Bundle)bundle, (String)"expired_event_name", String.class, null);
            this.mExpiredEventParams = (Bundle)zzgl.zzb((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
            this.mActive = (Boolean)zzgl.zzb((Bundle)bundle, (String)"active", Boolean.class, (Object)false);
            this.mCreationTimestamp = (Long)zzgl.zzb((Bundle)bundle, (String)"creation_timestamp", Long.class, (Object)l);
            this.mTriggeredTimestamp = (Long)zzgl.zzb((Bundle)bundle, (String)"triggered_timestamp", Long.class, (Object)l);
        }

        @VisibleForTesting
        final Bundle zza() {
            Bundle bundle = new Bundle();
            Object object = this.mAppId;
            if (object != null) {
                bundle.putString("app_id", (String)object);
            }
            if ((object = this.mOrigin) != null) {
                bundle.putString("origin", (String)object);
            }
            if ((object = this.mName) != null) {
                bundle.putString("name", (String)object);
            }
            if ((object = this.mValue) != null) {
                zzgl.zza((Bundle)bundle, (Object)object);
            }
            if ((object = this.mTriggerEventName) != null) {
                bundle.putString("trigger_event_name", (String)object);
            }
            bundle.putLong("trigger_timeout", this.mTriggerTimeout);
            object = this.mTimedOutEventName;
            if (object != null) {
                bundle.putString("timed_out_event_name", (String)object);
            }
            if ((object = this.mTimedOutEventParams) != null) {
                bundle.putBundle("timed_out_event_params", (Bundle)object);
            }
            if ((object = this.mTriggeredEventName) != null) {
                bundle.putString("triggered_event_name", (String)object);
            }
            if ((object = this.mTriggeredEventParams) != null) {
                bundle.putBundle("triggered_event_params", (Bundle)object);
            }
            bundle.putLong("time_to_live", this.mTimeToLive);
            object = this.mExpiredEventName;
            if (object != null) {
                bundle.putString("expired_event_name", (String)object);
            }
            if ((object = this.mExpiredEventParams) != null) {
                bundle.putBundle("expired_event_params", (Bundle)object);
            }
            bundle.putLong("creation_timestamp", this.mCreationTimestamp);
            bundle.putBoolean("active", this.mActive);
            bundle.putLong("triggered_timestamp", this.mTriggeredTimestamp);
            return bundle;
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzgq {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(@RecentlyNonNull String var1, @RecentlyNonNull String var2, @RecentlyNonNull Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzgp {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(@RecentlyNonNull String var1, @RecentlyNonNull String var2, @RecentlyNonNull Bundle var3, long var4);
    }
}

