/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzfi
extends zzgf {
    @Nullable
    private zzfh zza;
    @Nullable
    private zzfh zzb;
    private final PriorityBlockingQueue<zzfg<?>> zzc;
    private final BlockingQueue<zzfg<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg;
    private final Semaphore zzh;
    private volatile boolean zzi;
    private static final AtomicLong zzj;

    zzfi(zzfl object) {
        super((zzfl)object);
        this.zzg = object = new Object();
        this.zzh = object = new Semaphore(2);
        object = new PriorityBlockingQueue();
        this.zzc = object;
        super();
        this.zzd = object;
        this.zze = object = new zzff(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = object = new zzff(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zza() {
        return false;
    }

    @Override
    public final void zzg() {
        if (Thread.currentThread() != ((zzfi)object).zza) {
            Object object = new IllegalStateException("Call expected from worker thread");
            throw object;
        }
    }

    @Override
    public final void zzav() {
        if (Thread.currentThread() != ((zzfi)object).zzb) {
            Object object = new IllegalStateException("Call expected from network thread");
            throw object;
        }
    }

    public final boolean zzd() {
        return Thread.currentThread() == this.zza;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull(callable);
        zzfg zzfg2 = new zzfg(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                this.zzx.zzat().zze().zza("Callable skipped the worker queue.");
            }
            zzfg2.run();
            return zzfg2;
        }
        this.zzt(zzfg2);
        return zzfg2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <V> Future<V> zzf(Callable<V> callable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull(callable);
        zzfg zzfg2 = new zzfg(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzfg2.run();
            return zzfg2;
        }
        this.zzt(zzfg2);
        return zzfg2;
    }

    public final void zzh(Runnable runnable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)runnable);
        zzfg zzfg2 = new zzfg(this, runnable, false, "Task exception on worker thread");
        this.zzt(zzfg2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nullable
    final <T> T zzi(AtomicReference<T> atomicReference, long l, String string, Runnable object) {
        Object object2;
        block9: {
            // MONITORENTER : atomicReference
            zzfi zzfi2 = ((zzge)object2).zzx.zzau();
            zzfi2.zzh((Runnable)object);
            try {
                atomicReference.wait(l);
                // MONITOREXIT : atomicReference
                atomicReference = atomicReference.get();
                if (atomicReference != null) return (T)atomicReference;
                object = ((zzge)object2).zzx.zzat().zze();
                object2 = "Timed out waiting for ";
                if (string.length() != 0) {
                    object2 = ((String)object2).concat(string);
                    break block9;
                }
                string = new String((String)object2);
                object2 = string;
            }
            catch (InterruptedException interruptedException) {
                object2 = ((zzge)object2).zzx.zzat();
                object = ((zzei)object2).zze();
                object2 = "Interrupted waiting for ";
                int n = string.length();
                if (n != 0) {
                    object2 = ((String)object2).concat(string);
                } else {
                    string = new String((String)object2);
                    object2 = string;
                }
                ((zzeg)object).zza((String)object2);
                // MONITOREXIT : atomicReference
                return null;
            }
        }
        ((zzeg)object).zza((String)object2);
        return (T)atomicReference;
    }

    public final void zzj(Runnable runnable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)runnable);
        zzfg zzfg2 = new zzfg(this, runnable, true, "Task exception on worker thread");
        this.zzt(zzfg2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzt(zzfg<?> runnable) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add((zzfg<?>)runnable);
            runnable = this.zza;
            if (runnable == null) {
                runnable = new Runnable(this, "Measurement Worker", this.zzc);
                this.zza = runnable;
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                ((zzfh)runnable).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzk(Runnable object) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)object);
        Runnable runnable = new Runnable(this, (Runnable)object, false, "Task exception on network thread");
        object = this.zzg;
        synchronized (object) {
            this.zzd.add((zzfg<?>)runnable);
            runnable = this.zzb;
            if (runnable == null) {
                runnable = new Runnable(this, "Measurement Network", this.zzd);
                this.zzb = runnable;
                this.zzb.setUncaughtExceptionHandler(this.zzf);
                this.zzb.start();
            } else {
                ((zzfh)runnable).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static /* synthetic */ Semaphore zzl(zzfi zzfi2) {
        return zzfi2.zzh;
    }

    static /* synthetic */ boolean zzm(zzfi zzfi2) {
        boolean cfr_ignored_0 = zzfi2.zzi;
        return false;
    }

    static /* synthetic */ Object zzn(zzfi zzfi2) {
        return zzfi2.zzg;
    }

    static /* synthetic */ zzfh zzo(zzfi zzfi2) {
        return zzfi2.zza;
    }

    static /* synthetic */ zzfh zzp(zzfi zzfi2, zzfh zzfh2) {
        zzfi2.zza = null;
        return null;
    }

    static /* synthetic */ zzfh zzq(zzfi zzfi2) {
        return zzfi2.zzb;
    }

    static /* synthetic */ zzfh zzr(zzfi zzfi2, zzfh zzfh2) {
        zzfi2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzs() {
        return zzj;
    }

    static {
        AtomicLong atomicLong;
        zzj = atomicLong = new AtomicLong(Long.MIN_VALUE);
    }
}

