/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzy;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzkg;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Deprecated
@ShowFirstParty
@KeepForSdk
public class AppMeasurement {
    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public static final String CRASH_ORIGIN = "crash";
    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public static final String FCM_ORIGIN = "fcm";
    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public static final String FIAM_ORIGIN = "fiam";
    private static volatile AppMeasurement zza;
    private final zzfl zzb;
    private final zzho zzc;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @ShowFirstParty
    @Keep
    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @RecentlyNonNull
    public static AppMeasurement getInstance(@RecentlyNonNull Context object) {
        if (zza == null) {
            Class<AppMeasurement> clazz = AppMeasurement.class;
            synchronized (clazz) {
                Object object2 = zza;
                if (object2 == null) {
                    block10: {
                        try {
                            object2 = Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            object2 = null;
                            break block10;
                        }
                        try {
                            Object[] objectArray = new Class[]{Context.class, Bundle.class};
                            object2 = ((Class)object2).getDeclaredMethod("getScionFrontendApiImplementation", (Class<?>[])objectArray);
                            objectArray = new Object[]{object, null};
                            object2 = (zzho)((Method)object2).invoke(null, objectArray);
                        }
                        catch (Exception exception) {
                            object2 = null;
                        }
                    }
                    if (object2 != null) {
                        object = new AppMeasurement((zzho)object2);
                        zza = object;
                    } else {
                        object2 = new zzy(0L, 0L, true, null, null, null, null, null);
                        object = zzfl.zzC(object, (zzy)object2, null);
                        zza = object2 = new AppMeasurement((zzfl)object);
                    }
                }
            }
        }
        return zza;
    }

    @ShowFirstParty
    @Keep
    public void logEventInternal(@RecentlyNonNull String string, @RecentlyNonNull String string2, @RecentlyNonNull Bundle bundle) {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            zzho2.zza(string, string2, bundle);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzs(string, string2, bundle);
    }

    @ShowFirstParty
    @KeepForSdk
    public void logEventInternalNoInterceptor(@RecentlyNonNull String string, @RecentlyNonNull String string2, @RecentlyNonNull Bundle bundle, long l) {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            zzho2.zzb(string, string2, bundle, l);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzv(string, string2, bundle, true, false, l);
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public Map<String, Object> getUserProperties(boolean bl) {
        Object object = ((AppMeasurement)((Object)iterator)).zzc;
        if (object != null) {
            return object.zzc(null, null, bl);
        }
        Preconditions.checkNotNull((Object)((AppMeasurement)((Object)iterator)).zzb);
        Iterator iterator = ((AppMeasurement)((Object)iterator)).zzb.zzk().zzC(bl);
        ArrayMap arrayMap = new ArrayMap(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object = (zzkg)((Object)iterator.next());
            Object object2 = object.zza();
            if (object2 == null) continue;
            arrayMap.put(object.zzb, object2);
        }
        return arrayMap;
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(@RecentlyNonNull EventInterceptor eventInterceptor) {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            zzho2.zzd((zzgl)eventInterceptor);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzI(eventInterceptor);
    }

    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(@RecentlyNonNull OnEventListener onEventListener) {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            zzho2.zze((zzgm)onEventListener);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzJ(onEventListener);
    }

    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(@RecentlyNonNull OnEventListener onEventListener) {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            zzho2.zzf((zzgm)onEventListener);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzK(onEventListener);
    }

    @Keep
    @RecentlyNonNull
    public String getCurrentScreenName() {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            return zzho2.zzg();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzR();
    }

    @Keep
    @RecentlyNonNull
    public String getCurrentScreenClass() {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            return zzho2.zzh();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzS();
    }

    @Keep
    @RecentlyNonNull
    public String getAppInstanceId() {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            return zzho2.zzi();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzD();
    }

    @Keep
    @RecentlyNonNull
    public String getGmpAppId() {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            return zzho2.zzj();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzT();
    }

    @Keep
    public long generateEventId() {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            return zzho2.zzk();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzl().zzd();
    }

    @Keep
    public void beginAdUnitExposure(@RecentlyNonNull @Size(min=1L) String string) {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            zzho2.zzl(string);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzB().zza(string, this.zzb.zzax().elapsedRealtime());
    }

    @Keep
    public void endAdUnitExposure(@RecentlyNonNull @Size(min=1L) String string) {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            zzho2.zzm(string);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzB().zzb(string, this.zzb.zzax().elapsedRealtime());
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void setConditionalUserProperty(@RecentlyNonNull ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            zzho2.zzn(conditionalUserProperty.zza());
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzM(conditionalUserProperty.zza());
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void clearConditionalUserProperty(@RecentlyNonNull @Size(min=1L, max=24L) String string, @RecentlyNonNull String string2, @RecentlyNonNull Bundle bundle) {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            zzho2.zzo(string, string2, bundle);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzO(string, string2, bundle);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    @RecentlyNonNull
    protected Map<String, Object> getUserProperties(@RecentlyNonNull String string, @Size(min=1L, max=24L) @RecentlyNonNull String string2, boolean bl) {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            return zzho2.zzc(string, string2, bl);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzQ(string, string2, bl);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public List<ConditionalUserProperty> getConditionalUserProperties(@RecentlyNonNull String string, @Size(min=1L, max=23L) @RecentlyNonNull String arrayList) {
        void var1_3;
        Object object;
        ArrayList<ConditionalUserProperty> arrayList2;
        zzho zzho2 = ((AppMeasurement)object).zzc;
        if (zzho2 != null) {
            object = zzho2.zzp(string, (String)((Object)arrayList2));
        } else {
            Preconditions.checkNotNull((Object)((AppMeasurement)object).zzb);
            object = ((AppMeasurement)object).zzb.zzk().zzP(string, (String)((Object)arrayList2));
        }
        if (object == null) {
            boolean bl = false;
        } else {
            int n = object.size();
        }
        arrayList2 = new ArrayList<ConditionalUserProperty>((int)var1_3);
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            Bundle bundle = (Bundle)e;
            ConditionalUserProperty conditionalUserProperty = new ConditionalUserProperty(bundle);
            arrayList2.add(conditionalUserProperty);
        }
        return arrayList2;
    }

    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public int getMaxUserProperties(@RecentlyNonNull @Size(min=1L) String string) {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            return zzho2.zzq(string);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzL(string);
        return 25;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Boolean getBoolean() {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            return (Boolean)zzho2.zzr(4);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzi();
    }

    @KeepForSdk
    @RecentlyNonNull
    public String getString() {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            return (String)zzho2.zzr(0);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzj();
    }

    @KeepForSdk
    @RecentlyNonNull
    public Long getLong() {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            return (Long)zzho2.zzr(1);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzk();
    }

    @KeepForSdk
    @RecentlyNonNull
    public Integer getInteger() {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            return (Integer)zzho2.zzr(3);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzl();
    }

    @KeepForSdk
    @RecentlyNonNull
    public Double getDouble() {
        zzho zzho2 = this.zzc;
        if (zzho2 != null) {
            return (Double)zzho2.zzr(2);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzm();
    }

    public AppMeasurement(zzfl zzfl2) {
        Preconditions.checkNotNull((Object)zzfl2);
        this.zzb = zzfl2;
        this.zzc = null;
    }

    public AppMeasurement(zzho zzho2) {
        Preconditions.checkNotNull((Object)zzho2);
        this.zzc = zzho2;
        this.zzb = null;
    }

    @ShowFirstParty
    @KeepForSdk
    public static class ConditionalUserProperty {
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @RecentlyNonNull
        public String mAppId;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @RecentlyNonNull
        public String mOrigin;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @RecentlyNonNull
        public String mName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @RecentlyNonNull
        public Object mValue;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @RecentlyNonNull
        public String mTriggerEventName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggerTimeout;
        @Keep
        @RecentlyNonNull
        public String mTimedOutEventName;
        @Keep
        @RecentlyNonNull
        public Bundle mTimedOutEventParams;
        @Keep
        @RecentlyNonNull
        public String mTriggeredEventName;
        @Keep
        @RecentlyNonNull
        public Bundle mTriggeredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTimeToLive;
        @Keep
        @RecentlyNonNull
        public String mExpiredEventName;
        @Keep
        @RecentlyNonNull
        public Bundle mExpiredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mCreationTimestamp;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public boolean mActive;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggeredTimestamp;

        @KeepForSdk
        public ConditionalUserProperty() {
        }

        @KeepForSdk
        public ConditionalUserProperty(@RecentlyNonNull ConditionalUserProperty conditionalUserProperty) {
            Bundle bundle;
            Preconditions.checkNotNull((Object)conditionalUserProperty);
            this.mAppId = conditionalUserProperty.mAppId;
            this.mOrigin = conditionalUserProperty.mOrigin;
            this.mCreationTimestamp = conditionalUserProperty.mCreationTimestamp;
            this.mName = conditionalUserProperty.mName;
            Object object = conditionalUserProperty.mValue;
            if (object != null) {
                this.mValue = zzht.zzc((Object)object);
                if (this.mValue == null) {
                    this.mValue = conditionalUserProperty.mValue;
                }
            }
            this.mActive = conditionalUserProperty.mActive;
            this.mTriggerEventName = conditionalUserProperty.mTriggerEventName;
            this.mTriggerTimeout = conditionalUserProperty.mTriggerTimeout;
            this.mTimedOutEventName = conditionalUserProperty.mTimedOutEventName;
            object = conditionalUserProperty.mTimedOutEventParams;
            if (object != null) {
                this.mTimedOutEventParams = bundle = new Bundle((Bundle)object);
            }
            this.mTriggeredEventName = conditionalUserProperty.mTriggeredEventName;
            object = conditionalUserProperty.mTriggeredEventParams;
            if (object != null) {
                this.mTriggeredEventParams = bundle = new Bundle((Bundle)object);
            }
            this.mTriggeredTimestamp = conditionalUserProperty.mTriggeredTimestamp;
            this.mTimeToLive = conditionalUserProperty.mTimeToLive;
            this.mExpiredEventName = conditionalUserProperty.mExpiredEventName;
            conditionalUserProperty = conditionalUserProperty.mExpiredEventParams;
            if (conditionalUserProperty != null) {
                object = new Bundle((Bundle)conditionalUserProperty);
                this.mExpiredEventParams = object;
                return;
            }
        }

        @VisibleForTesting
        ConditionalUserProperty(@NonNull Bundle bundle) {
            Preconditions.checkNotNull((Object)bundle);
            this.mAppId = (String)zzgh.zzb((Bundle)bundle, (String)"app_id", String.class, null);
            this.mOrigin = (String)zzgh.zzb((Bundle)bundle, (String)"origin", String.class, null);
            this.mName = (String)zzgh.zzb((Bundle)bundle, (String)"name", String.class, null);
            this.mValue = zzgh.zzb((Bundle)bundle, (String)"value", Object.class, null);
            this.mTriggerEventName = (String)zzgh.zzb((Bundle)bundle, (String)"trigger_event_name", String.class, null);
            Long l = 0L;
            this.mTriggerTimeout = (Long)zzgh.zzb((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)l);
            this.mTimedOutEventName = (String)zzgh.zzb((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
            this.mTimedOutEventParams = (Bundle)zzgh.zzb((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
            this.mTriggeredEventName = (String)zzgh.zzb((Bundle)bundle, (String)"triggered_event_name", String.class, null);
            this.mTriggeredEventParams = (Bundle)zzgh.zzb((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
            this.mTimeToLive = (Long)zzgh.zzb((Bundle)bundle, (String)"time_to_live", Long.class, (Object)l);
            this.mExpiredEventName = (String)zzgh.zzb((Bundle)bundle, (String)"expired_event_name", String.class, null);
            this.mExpiredEventParams = (Bundle)zzgh.zzb((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
            this.mActive = (Boolean)zzgh.zzb((Bundle)bundle, (String)"active", Boolean.class, (Object)false);
            this.mCreationTimestamp = (Long)zzgh.zzb((Bundle)bundle, (String)"creation_timestamp", Long.class, (Object)l);
            this.mTriggeredTimestamp = (Long)zzgh.zzb((Bundle)bundle, (String)"triggered_timestamp", Long.class, (Object)l);
        }

        @VisibleForTesting
        final Bundle zza() {
            Bundle bundle = new Bundle();
            Object object = this.mAppId;
            if (object != null) {
                bundle.putString("app_id", (String)object);
            }
            if ((object = this.mOrigin) != null) {
                bundle.putString("origin", (String)object);
            }
            if ((object = this.mName) != null) {
                bundle.putString("name", (String)object);
            }
            if ((object = this.mValue) != null) {
                zzgh.zza((Bundle)bundle, (Object)object);
            }
            if ((object = this.mTriggerEventName) != null) {
                bundle.putString("trigger_event_name", (String)object);
            }
            bundle.putLong("trigger_timeout", this.mTriggerTimeout);
            object = this.mTimedOutEventName;
            if (object != null) {
                bundle.putString("timed_out_event_name", (String)object);
            }
            if ((object = this.mTimedOutEventParams) != null) {
                bundle.putBundle("timed_out_event_params", (Bundle)object);
            }
            if ((object = this.mTriggeredEventName) != null) {
                bundle.putString("triggered_event_name", (String)object);
            }
            if ((object = this.mTriggeredEventParams) != null) {
                bundle.putBundle("triggered_event_params", (Bundle)object);
            }
            bundle.putLong("time_to_live", this.mTimeToLive);
            object = this.mExpiredEventName;
            if (object != null) {
                bundle.putString("expired_event_name", (String)object);
            }
            if ((object = this.mExpiredEventParams) != null) {
                bundle.putBundle("expired_event_params", (Bundle)object);
            }
            bundle.putLong("creation_timestamp", this.mCreationTimestamp);
            bundle.putBoolean("active", this.mActive);
            bundle.putLong("triggered_timestamp", this.mTriggeredTimestamp);
            return bundle;
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzgm {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(@RecentlyNonNull String var1, @RecentlyNonNull String var2, @RecentlyNonNull Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzgl {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(@RecentlyNonNull String var1, @RecentlyNonNull String var2, @RecentlyNonNull Bundle var3, long var4);
    }
}

