/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzr;

public final class zzfd {
    private final zzfe zza;

    public zzfd(zzfe zzfe2) {
        Preconditions.checkNotNull((Object)zzfe2);
        this.zza = zzfe2;
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void zza(Context context, Intent intent) {
        zzfn zzfn2 = zzfn.zza(context, null);
        zzej zzej2 = zzfn2.zzr();
        if (intent == null) {
            zzej2.zzi().zza("Receiver called with null intent");
            return;
        }
        zzr zzr2 = zzfn2.zzu();
        boolean bl = false;
        String string = intent.getAction();
        if (bl) {
            zzej2.zzx().zza("Device receiver got", string);
        } else {
            zzej2.zzx().zza("Local receiver got", string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzej2.zzx().zza("Starting wakeful intent.");
            this.zza.doStartService(context, intent2);
            return;
        }
        if (!bl && "com.android.vending.INSTALL_REFERRER".equals(string)) {
            try {
                zzfn2.zzq().zza(new zzfc(this, zzfn2, zzej2));
            }
            catch (Exception exception) {
                zzej2.zzi().zza("Install Referrer Reporter encountered a problem", exception);
            }
            BroadcastReceiver.PendingResult pendingResult = this.zza.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzej2.zzx().zza("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzej2.zzv().zza("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzfn2.zzi().zza(uri);
            if (bundle == null) {
                zzej2.zzx().zza("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzej2.zzi().zza("Install referrer is missing timestamp");
                }
                zzfn2.zzq().zza(new zzff(this, zzfn2, l, bundle, context, zzej2, pendingResult));
            }
        }
    }
}

