/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzgu;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzeu
extends zzdj<Float>
implements zzff<Float>,
zzgu,
RandomAccess {
    private static final zzeu zzahm = new zzeu(new float[0], 0);
    private float[] zzahn;
    private int size;

    zzeu() {
        this(new float[10], 0);
    }

    private zzeu(float[] fArray, int n) {
        this.zzahn = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzrz();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzahn, n2, this.zzahn, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzeu)) {
            return super.equals(object);
        }
        zzeu zzeu2 = (zzeu)object;
        if (this.size != zzeu2.size) {
            return false;
        }
        float[] fArray = zzeu2.zzahn;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzahn[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzahn[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzrz();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzao(n));
        }
        if (this.size < this.zzahn.length) {
            System.arraycopy(this.zzahn, n, this.zzahn, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzahn, 0, fArray, 0, n);
            System.arraycopy(this.zzahn, n, fArray, n + 1, this.size - n);
            this.zzahn = fArray;
        }
        this.zzahn[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzrz();
        zzez.checkNotNull(collection);
        if (!(collection instanceof zzeu)) {
            return super.addAll(collection);
        }
        zzeu zzeu2 = (zzeu)collection;
        if (zzeu2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzeu2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzeu2.size;
        if (n > this.zzahn.length) {
            this.zzahn = Arrays.copyOf(this.zzahn, n);
        }
        System.arraycopy(zzeu2.zzahn, 0, this.zzahn, this.size, zzeu2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzrz();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzahn[i]))) continue;
            System.arraycopy(this.zzahn, i + 1, this.zzahn, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzan(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzao(n));
        }
    }

    private final String zzao(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzeu zzeu2 = this;
        zzeu2.zzrz();
        zzeu2.zzan(n);
        float f3 = zzeu2.zzahn[n];
        zzeu2.zzahn[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzeu zzeu2 = this;
        zzeu2.zzrz();
        zzeu2.zzan(n);
        float f = zzeu2.zzahn[n];
        if (n < zzeu2.size - 1) {
            System.arraycopy(zzeu2.zzahn, n + 1, zzeu2.zzahn, n, zzeu2.size - n - 1);
        }
        --zzeu2.size;
        ++zzeu2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzff zzap(int n) {
        int n2 = n;
        zzeu zzeu2 = this;
        if (n2 < zzeu2.size) {
            throw new IllegalArgumentException();
        }
        return new zzeu(Arrays.copyOf(zzeu2.zzahn, n2), zzeu2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzeu zzeu2 = this;
        zzeu2.zzan(n);
        return Float.valueOf(zzeu2.zzahn[n]);
    }

    static {
        zzahm.zzry();
    }
}

