/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.maps.model.StreetViewPanoramaOrientation;
import com.google.android.gms.maps.model.zzk;

public class StreetViewPanoramaCamera
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<StreetViewPanoramaCamera> CREATOR = new zzk();
    private final int mVersionCode;
    public final float zoom;
    public final float tilt;
    public final float bearing;
    private StreetViewPanoramaOrientation aqo;

    StreetViewPanoramaCamera(int n, float f, float f2, float f3) {
        zzaa.zzb((-90.0f <= f2 && f2 <= 90.0f ? 1 : 0) != 0, (Object)"Tilt needs to be between -90 and 90 inclusive");
        this.mVersionCode = n;
        this.zoom = (double)f <= 0.0 ? 0.0f : f;
        this.tilt = f2 + 0.0f;
        this.bearing = ((double)f3 <= 0.0 ? f3 % 360.0f + 360.0f : f3) % 360.0f;
        this.aqo = new StreetViewPanoramaOrientation.Builder().tilt(f2).bearing(f3).build();
    }

    public StreetViewPanoramaCamera(float f, float f2, float f3) {
        this(1, f, f2, f3);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzk.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StreetViewPanoramaCamera streetViewPanoramaCamera) {
        return new Builder(streetViewPanoramaCamera);
    }

    public StreetViewPanoramaOrientation getOrientation() {
        return this.aqo;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StreetViewPanoramaCamera)) {
            return false;
        }
        StreetViewPanoramaCamera streetViewPanoramaCamera = (StreetViewPanoramaCamera)((Object)object);
        return Float.floatToIntBits(this.zoom) == Float.floatToIntBits(streetViewPanoramaCamera.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(streetViewPanoramaCamera.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaCamera.bearing);
    }

    public String toString() {
        return zzz.zzx((Object)((Object)this)).zzg("zoom", (Object)Float.valueOf(this.zoom)).zzg("tilt", (Object)Float.valueOf(this.tilt)).zzg("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    public static final class Builder {
        public float bearing;
        public float tilt;
        public float zoom;

        public Builder() {
        }

        public Builder(StreetViewPanoramaCamera streetViewPanoramaCamera) {
            StreetViewPanoramaCamera streetViewPanoramaCamera2 = streetViewPanoramaCamera;
            this.zoom = streetViewPanoramaCamera2.zoom;
            this.bearing = streetViewPanoramaCamera2.bearing;
            this.tilt = streetViewPanoramaCamera2.tilt;
        }

        public Builder zoom(float f) {
            this.zoom = f;
            return this;
        }

        public Builder orientation(StreetViewPanoramaOrientation streetViewPanoramaOrientation) {
            this.tilt = streetViewPanoramaOrientation.tilt;
            this.bearing = streetViewPanoramaOrientation.bearing;
            return this;
        }

        public Builder tilt(float f) {
            this.tilt = f;
            return this;
        }

        public Builder bearing(float f) {
            this.bearing = f;
            return this;
        }

        public StreetViewPanoramaCamera build() {
            return new StreetViewPanoramaCamera(this.zoom, this.tilt, this.bearing);
        }
    }
}

