/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzah;
import com.google.android.gms.maps.internal.zzai;
import com.google.android.gms.maps.internal.zzt;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=11)
public class MapFragment
extends Fragment {
    private final zzb aoJ = new zzb(this);

    public static MapFragment newInstance() {
        return new MapFragment();
    }

    public static MapFragment newInstance(GoogleMapOptions googleMapOptions) {
        MapFragment mapFragment = new MapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        mapFragment.setArguments(bundle);
        return mapFragment;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.aoJ.setActivity(activity);
    }

    @SuppressLint(value={"NewApi"})
    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        this.aoJ.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attributeSet);
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.aoJ.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.aoJ.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = this.aoJ.onCreateView(layoutInflater, viewGroup, bundle);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.aoJ.onResume();
    }

    public void onPause() {
        this.aoJ.onPause();
        super.onPause();
    }

    public void onStart() {
        super.onStart();
        this.aoJ.onStart();
    }

    public void onStop() {
        this.aoJ.onStop();
        super.onStop();
    }

    public void onDestroyView() {
        this.aoJ.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.aoJ.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.aoJ.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onActivityCreated(bundle);
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(bundle);
        this.aoJ.onSaveInstanceState(bundle);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzaa.zzhs((String)"onEnterAmbient must be called on the main thread.");
        this.aoJ.onEnterAmbient(bundle);
    }

    public final void onExitAmbient() {
        zzaa.zzhs((String)"onExitAmbient must be called on the main thread.");
        this.aoJ.onExitAmbient();
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzaa.zzhs((String)"getMapAsync must be called on the main thread.");
        this.aoJ.getMapAsync(onMapReadyCallback);
    }

    public void setArguments(Bundle bundle) {
        super.setArguments(bundle);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment Qd;
        protected zzf<zza> aoN;
        private Activity mActivity;
        private final List<OnMapReadyCallback> aoO = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.Qd = fragment;
        }

        protected void zza(zzf<zza> zzf2) {
            this.aoN = zzf2;
            this.zzbsp();
        }

        public void zzbsp() {
            if (this.mActivity != null && this.aoN != null && this.zzbdo() == null) {
                try {
                    MapsInitializer.initialize((Context)this.mActivity);
                    IMapFragmentDelegate iMapFragmentDelegate = zzai.zzdm((Context)this.mActivity).zzah(zze.zzac((Object)this.mActivity));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.aoN.zza((LifecycleDelegate)new zza(this.Qd, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.aoO) {
                        ((zza)this.zzbdo()).getMapAsync(onMapReadyCallback);
                    }
                    this.aoO.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
            this.zzbsp();
        }

        public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzbdo() != null) {
                ((zza)this.zzbdo()).getMapAsync(onMapReadyCallback);
            } else {
                this.aoO.add(onMapReadyCallback);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            if (this.zzbdo() != null) {
                ((zza)this.zzbdo()).onEnterAmbient(bundle);
            }
        }

        public void onExitAmbient() {
            if (this.zzbdo() != null) {
                ((zza)this.zzbdo()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final Fragment Qd;
        private final IMapFragmentDelegate aoK;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.aoK = (IMapFragmentDelegate)zzaa.zzy((Object)iMapFragmentDelegate);
            this.Qd = (Fragment)zzaa.zzy((Object)fragment);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)bundle.getParcelable("MapOptions");
            try {
                this.aoK.onInflate(zze.zzac((Object)activity), googleMapOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                Bundle bundle2;
                if (bundle == null) {
                    bundle = new Bundle();
                }
                if ((bundle2 = this.Qd.getArguments()) != null && bundle2.containsKey("MapOptions")) {
                    zzah.zza(bundle, "MapOptions", bundle2.getParcelable("MapOptions"));
                }
                this.aoK.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            zzd zzd2;
            try {
                zzd2 = this.aoK.onCreateView(zze.zzac((Object)layoutInflater), zze.zzac((Object)viewGroup), bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zze.zzae((zzd)zzd2);
        }

        public void onStart() {
            try {
                this.aoK.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.aoK.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.aoK.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.aoK.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroyView() {
            try {
                this.aoK.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroy() {
            try {
                this.aoK.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.aoK.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.aoK.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback onMapReadyCallback) {
            try {
                this.aoK.getMapAsync(new zzt.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        onMapReadyCallback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            try {
                this.aoK.onEnterAmbient(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.aoK.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

