/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.maps.model.zze;

public final class LatLng
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final zze CREATOR = new zze();
    private final int mVersionCode;
    public final double latitude;
    public final double longitude;

    LatLng(int n, double d, double d2) {
        this.mVersionCode = n;
        this.longitude = -180.0 <= d2 && d2 < 180.0 ? d2 : ((d2 - 180.0) % 360.0 + 360.0) % 360.0 - 180.0;
        this.latitude = Math.max(-90.0, Math.min(90.0, d));
    }

    public LatLng(double d, double d2) {
        this(1, d, d2);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.latitude);
        n2 = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.longitude);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLng)) {
            return false;
        }
        LatLng latLng = (LatLng)((Object)object);
        return Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(latLng.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(latLng.longitude);
    }

    public String toString() {
        double d = this.latitude;
        double d2 = this.longitude;
        return new StringBuilder(60).append("lat/lng: (").append(d).append(",").append(d2).append(")").toString();
    }
}

