/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzc;

public final class GroundOverlayOptions
extends AbstractSafeParcelable {
    public static final zzc CREATOR = new zzc();
    public static final float NO_DIMENSION = -1.0f;
    private final int mVersionCode;
    private BitmapDescriptor amH;
    private LatLng amI;
    private float amJ;
    private float amK;
    private LatLngBounds akB;
    private float amz;
    private float amD;
    private boolean amE = true;
    private float amL = 0.0f;
    private float amM = 0.5f;
    private float amN = 0.5f;
    private boolean amF = false;

    GroundOverlayOptions(int n, IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.mVersionCode = n;
        this.amH = new BitmapDescriptor(zzd.zza.zzfe((IBinder)iBinder));
        this.amI = latLng;
        this.amJ = f;
        this.amK = f2;
        this.akB = latLngBounds;
        this.amz = f3;
        this.amD = f4;
        this.amE = bl;
        this.amL = f5;
        this.amM = f6;
        this.amN = f7;
        this.amF = bl2;
    }

    public GroundOverlayOptions() {
        this.mVersionCode = 1;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    IBinder zzbsh() {
        return this.amH.zzbrh().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor bitmapDescriptor) {
        this.amH = bitmapDescriptor;
        return this;
    }

    public GroundOverlayOptions anchor(float f, float f2) {
        this.amM = f;
        this.amN = f2;
        return this;
    }

    public GroundOverlayOptions position(LatLng latLng, float f) {
        zzac.zza((this.akB == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzac.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzac.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzac.zza((this.akB == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzac.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzac.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzac.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.amI = latLng;
        this.amJ = f;
        this.amK = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.amI);
        zzac.zza((this.amI == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.akB = latLngBounds;
        return this;
    }

    public GroundOverlayOptions bearing(float f) {
        this.amz = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float f) {
        this.amD = f;
        return this;
    }

    public GroundOverlayOptions visible(boolean bl) {
        this.amE = bl;
        return this;
    }

    public GroundOverlayOptions transparency(float f) {
        zzac.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.amL = f;
        return this;
    }

    public GroundOverlayOptions clickable(boolean bl) {
        this.amF = bl;
        return this;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public BitmapDescriptor getImage() {
        return this.amH;
    }

    public LatLng getLocation() {
        return this.amI;
    }

    public float getWidth() {
        return this.amJ;
    }

    public float getHeight() {
        return this.amK;
    }

    public LatLngBounds getBounds() {
        return this.akB;
    }

    public float getBearing() {
        return this.amz;
    }

    public float getZIndex() {
        return this.amD;
    }

    public float getTransparency() {
        return this.amL;
    }

    public float getAnchorU() {
        return this.amM;
    }

    public float getAnchorV() {
        return this.amN;
    }

    public boolean isVisible() {
        return this.amE;
    }

    public boolean isClickable() {
        return this.amF;
    }
}

