/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzai;
import com.google.android.gms.maps.internal.zzt;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb alI;

    public MapView(Context context) {
        super(context);
        this.alI = new zzb((ViewGroup)this, context, null);
        this.zzbrv();
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.alI = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzbrv();
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.alI = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzbrv();
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.alI = new zzb((ViewGroup)this, context, googleMapOptions);
        this.zzbrv();
    }

    private void zzbrv() {
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        this.alI.onCreate(bundle);
        if (this.alI.zzbdt() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.alI.onResume();
    }

    public final void onPause() {
        this.alI.onPause();
    }

    public final void onStart() {
        this.alI.onStart();
    }

    public final void onStop() {
        this.alI.onStop();
    }

    public final void onDestroy() {
        this.alI.onDestroy();
    }

    public final void onLowMemory() {
        this.alI.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.alI.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzac.zzhq((String)"getMapAsync() must be called on the main thread");
        this.alI.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzac.zzhq((String)"onEnterAmbient() must be called on the main thread");
        this.alI.onEnterAmbient(bundle);
    }

    public final void onExitAmbient() {
        zzac.zzhq((String)"onExitAmbient() must be called on the main thread");
        this.alI.onExitAmbient();
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup alN;
        private final Context mContext;
        protected zzf<zza> alG;
        private final GoogleMapOptions alO;
        private final List<OnMapReadyCallback> alH = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.alN = viewGroup;
            this.mContext = context;
            this.alO = googleMapOptions;
        }

        protected void zza(zzf<zza> zzf2) {
            this.alG = zzf2;
            this.zzbru();
        }

        public void zzbru() {
            if (this.alG != null && this.zzbdt() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzai.zzdp(this.mContext).zza(zze.zzac((Object)this.mContext), this.alO);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.alG.zza((LifecycleDelegate)new zza(this.alN, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.alH) {
                        ((zza)this.zzbdt()).getMapAsync(onMapReadyCallback);
                    }
                    this.alH.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzbdt() != null) {
                ((zza)this.zzbdt()).getMapAsync(onMapReadyCallback);
            } else {
                this.alH.add(onMapReadyCallback);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            if (this.zzbdt() != null) {
                ((zza)this.zzbdt()).onEnterAmbient(bundle);
            }
        }

        public void onExitAmbient() {
            if (this.zzbdt() != null) {
                ((zza)this.zzbdt()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup alJ;
        private final IMapViewDelegate alK;
        private View alL;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.alK = (IMapViewDelegate)zzac.zzy((Object)iMapViewDelegate);
            this.alJ = (ViewGroup)zzac.zzy((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public void onCreate(Bundle bundle) {
            try {
                this.alK.onCreate(bundle);
                this.alL = (View)zze.zzae((zzd)this.alK.getView());
                this.alJ.removeAllViews();
                this.alJ.addView(this.alL);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public void onStart() {
            try {
                this.alK.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.alK.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.alK.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.alK.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public void onDestroy() {
            try {
                this.alK.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.alK.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.alK.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback onMapReadyCallback) {
            try {
                this.alK.getMapAsync(new zzt.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        onMapReadyCallback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            try {
                this.alK.onEnterAmbient(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.alK.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

