/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Bitmap;
import android.location.Location;
import android.os.RemoteException;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.LocationSource;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.UiSettings;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.ILocationSourceDelegate;
import com.google.android.gms.maps.internal.zzaa;
import com.google.android.gms.maps.internal.zzag;
import com.google.android.gms.maps.internal.zzb;
import com.google.android.gms.maps.internal.zzd;
import com.google.android.gms.maps.internal.zze;
import com.google.android.gms.maps.internal.zzf;
import com.google.android.gms.maps.internal.zzg;
import com.google.android.gms.maps.internal.zzh;
import com.google.android.gms.maps.internal.zzi;
import com.google.android.gms.maps.internal.zzj;
import com.google.android.gms.maps.internal.zzk;
import com.google.android.gms.maps.internal.zzl;
import com.google.android.gms.maps.internal.zzm;
import com.google.android.gms.maps.internal.zzn;
import com.google.android.gms.maps.internal.zzo;
import com.google.android.gms.maps.internal.zzp;
import com.google.android.gms.maps.internal.zzq;
import com.google.android.gms.maps.internal.zzr;
import com.google.android.gms.maps.internal.zzs;
import com.google.android.gms.maps.internal.zzu;
import com.google.android.gms.maps.internal.zzv;
import com.google.android.gms.maps.internal.zzw;
import com.google.android.gms.maps.internal.zzx;
import com.google.android.gms.maps.internal.zzz;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.IndoorBuilding;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.internal.IPolylineDelegate;
import com.google.android.gms.maps.model.internal.zzb;
import com.google.android.gms.maps.model.internal.zzc;
import com.google.android.gms.maps.model.internal.zzd;
import com.google.android.gms.maps.model.internal.zzf;
import com.google.android.gms.maps.model.internal.zzg;
import com.google.android.gms.maps.model.internal.zzh;

public final class GoogleMap {
    public static final int MAP_TYPE_NONE = 0;
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_TERRAIN = 3;
    public static final int MAP_TYPE_HYBRID = 4;
    private final IGoogleMapDelegate aeV;
    private UiSettings aeW;

    protected GoogleMap(IGoogleMapDelegate iGoogleMapDelegate) {
        this.aeV = (IGoogleMapDelegate)zzab.zzy((Object)iGoogleMapDelegate);
    }

    public final CameraPosition getCameraPosition() {
        try {
            return this.aeV.getCameraPosition();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getMaxZoomLevel() {
        try {
            return this.aeV.getMaxZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getMinZoomLevel() {
        try {
            return this.aeV.getMinZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void moveCamera(CameraUpdate cameraUpdate) {
        try {
            this.aeV.moveCamera(cameraUpdate.zzboj());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate) {
        try {
            this.aeV.animateCamera(cameraUpdate.zzboj());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate, CancelableCallback cancelableCallback) {
        try {
            this.aeV.animateCameraWithCallback(cameraUpdate.zzboj(), cancelableCallback == null ? null : new zza(cancelableCallback));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate, int n, CancelableCallback cancelableCallback) {
        try {
            this.aeV.animateCameraWithDurationAndCallback(cameraUpdate.zzboj(), n, cancelableCallback == null ? null : new zza(cancelableCallback));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void stopAnimation() {
        try {
            this.aeV.stopAnimation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Polyline addPolyline(PolylineOptions polylineOptions) {
        try {
            return new Polyline(this.aeV.addPolyline(polylineOptions));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Polygon addPolygon(PolygonOptions polygonOptions) {
        try {
            return new Polygon(this.aeV.addPolygon(polygonOptions));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Circle addCircle(CircleOptions circleOptions) {
        try {
            return new Circle(this.aeV.addCircle(circleOptions));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Marker addMarker(MarkerOptions markerOptions) {
        try {
            zzf zzf2 = this.aeV.addMarker(markerOptions);
            if (zzf2 != null) {
                return new Marker(zzf2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final GroundOverlay addGroundOverlay(GroundOverlayOptions groundOverlayOptions) {
        try {
            zzc zzc2 = this.aeV.addGroundOverlay(groundOverlayOptions);
            if (zzc2 != null) {
                return new GroundOverlay(zzc2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final TileOverlay addTileOverlay(TileOverlayOptions tileOverlayOptions) {
        try {
            zzh zzh2 = this.aeV.addTileOverlay(tileOverlayOptions);
            if (zzh2 != null) {
                return new TileOverlay(zzh2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void clear() {
        try {
            this.aeV.clear();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public IndoorBuilding getFocusedBuilding() {
        try {
            zzd zzd2 = this.aeV.getFocusedBuilding();
            if (zzd2 != null) {
                return new IndoorBuilding(zzd2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnIndoorStateChangeListener(final OnIndoorStateChangeListener onIndoorStateChangeListener) {
        try {
            if (onIndoorStateChangeListener == null) {
                this.aeV.setOnIndoorStateChangeListener(null);
            } else {
                this.aeV.setOnIndoorStateChangeListener(new zzl.zza(){

                    @Override
                    public void onIndoorBuildingFocused() {
                        onIndoorStateChangeListener.onIndoorBuildingFocused();
                    }

                    @Override
                    public void zza(zzd zzd2) {
                        onIndoorStateChangeListener.onIndoorLevelActivated(new IndoorBuilding(zzd2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int getMapType() {
        try {
            return this.aeV.getMapType();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setMapType(int n) {
        try {
            this.aeV.setMapType(n);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isTrafficEnabled() {
        try {
            return this.aeV.isTrafficEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setTrafficEnabled(boolean bl) {
        try {
            this.aeV.setTrafficEnabled(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isIndoorEnabled() {
        try {
            return this.aeV.isIndoorEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean setIndoorEnabled(boolean bl) {
        try {
            return this.aeV.setIndoorEnabled(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isBuildingsEnabled() {
        try {
            return this.aeV.isBuildingsEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setBuildingsEnabled(boolean bl) {
        try {
            this.aeV.setBuildingsEnabled(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isMyLocationEnabled() {
        try {
            return this.aeV.isMyLocationEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final void setMyLocationEnabled(boolean bl) {
        try {
            this.aeV.setMyLocationEnabled(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final Location getMyLocation() {
        try {
            return this.aeV.getMyLocation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setLocationSource(final LocationSource locationSource) {
        try {
            if (locationSource == null) {
                this.aeV.setLocationSource(null);
            } else {
                this.aeV.setLocationSource(new ILocationSourceDelegate.zza(){

                    @Override
                    public void activate(final zzp zzp2) {
                        locationSource.activate(new LocationSource.OnLocationChangedListener(){

                            @Override
                            public void onLocationChanged(Location location) {
                                try {
                                    zzp2.zzd(location);
                                }
                                catch (RemoteException remoteException) {
                                    throw new RuntimeRemoteException(remoteException);
                                }
                            }
                        });
                    }

                    @Override
                    public void deactivate() {
                        locationSource.deactivate();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final UiSettings getUiSettings() {
        try {
            if (this.aeW == null) {
                this.aeW = new UiSettings(this.aeV.getUiSettings());
            }
            return this.aeW;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Projection getProjection() {
        try {
            return new Projection(this.aeV.getProjection());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final void setOnCameraChangeListener(final OnCameraChangeListener onCameraChangeListener) {
        try {
            if (onCameraChangeListener == null) {
                this.aeV.setOnCameraChangeListener(null);
            } else {
                this.aeV.setOnCameraChangeListener(new zze.zza(){

                    @Override
                    public void onCameraChange(CameraPosition cameraPosition) {
                        onCameraChangeListener.onCameraChange(cameraPosition);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraMoveStartedListener(final OnCameraMoveStartedListener onCameraMoveStartedListener) {
        try {
            if (onCameraMoveStartedListener == null) {
                this.aeV.setOnCameraMoveStartedListener(null);
            } else {
                this.aeV.setOnCameraMoveStartedListener(new zzi.zza(){

                    @Override
                    public void onCameraMoveStarted(int n) {
                        onCameraMoveStartedListener.onCameraMoveStarted(n);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraMoveListener(final OnCameraMoveListener onCameraMoveListener) {
        try {
            if (onCameraMoveListener == null) {
                this.aeV.setOnCameraMoveListener(null);
            } else {
                this.aeV.setOnCameraMoveListener(new zzh.zza(){

                    @Override
                    public void onCameraMove() {
                        onCameraMoveListener.onCameraMove();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraMoveCanceledListener(final OnCameraMoveCanceledListener onCameraMoveCanceledListener) {
        try {
            if (onCameraMoveCanceledListener == null) {
                this.aeV.setOnCameraMoveCanceledListener(null);
            } else {
                this.aeV.setOnCameraMoveCanceledListener(new zzg.zza(){

                    @Override
                    public void onCameraMoveCanceled() {
                        onCameraMoveCanceledListener.onCameraMoveCanceled();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraIdleListener(final OnCameraIdleListener onCameraIdleListener) {
        try {
            if (onCameraIdleListener == null) {
                this.aeV.setOnCameraIdleListener(null);
            } else {
                this.aeV.setOnCameraIdleListener(new zzf.zza(){

                    @Override
                    public void onCameraIdle() {
                        onCameraIdleListener.onCameraIdle();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapClickListener(final OnMapClickListener onMapClickListener) {
        try {
            if (onMapClickListener == null) {
                this.aeV.setOnMapClickListener(null);
            } else {
                this.aeV.setOnMapClickListener(new zzq.zza(){

                    @Override
                    public void onMapClick(LatLng latLng) {
                        onMapClickListener.onMapClick(latLng);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapLongClickListener(final OnMapLongClickListener onMapLongClickListener) {
        try {
            if (onMapLongClickListener == null) {
                this.aeV.setOnMapLongClickListener(null);
            } else {
                this.aeV.setOnMapLongClickListener(new zzs.zza(){

                    @Override
                    public void onMapLongClick(LatLng latLng) {
                        onMapLongClickListener.onMapLongClick(latLng);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMarkerClickListener(final OnMarkerClickListener onMarkerClickListener) {
        try {
            if (onMarkerClickListener == null) {
                this.aeV.setOnMarkerClickListener(null);
            } else {
                this.aeV.setOnMarkerClickListener(new zzu.zza(){

                    @Override
                    public boolean zza(zzf zzf2) {
                        return onMarkerClickListener.onMarkerClick(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMarkerDragListener(final OnMarkerDragListener onMarkerDragListener) {
        try {
            if (onMarkerDragListener == null) {
                this.aeV.setOnMarkerDragListener(null);
            } else {
                this.aeV.setOnMarkerDragListener(new zzv.zza(){

                    @Override
                    public void zzb(zzf zzf2) {
                        onMarkerDragListener.onMarkerDragStart(new Marker(zzf2));
                    }

                    @Override
                    public void zzc(zzf zzf2) {
                        onMarkerDragListener.onMarkerDragEnd(new Marker(zzf2));
                    }

                    @Override
                    public void zzd(zzf zzf2) {
                        onMarkerDragListener.onMarkerDrag(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowClickListener(final OnInfoWindowClickListener onInfoWindowClickListener) {
        try {
            if (onInfoWindowClickListener == null) {
                this.aeV.setOnInfoWindowClickListener(null);
            } else {
                this.aeV.setOnInfoWindowClickListener(new zzm.zza(){

                    @Override
                    public void zze(zzf zzf2) {
                        onInfoWindowClickListener.onInfoWindowClick(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowLongClickListener(final OnInfoWindowLongClickListener onInfoWindowLongClickListener) {
        try {
            if (onInfoWindowLongClickListener == null) {
                this.aeV.setOnInfoWindowLongClickListener(null);
            } else {
                this.aeV.setOnInfoWindowLongClickListener(new zzo.zza(){

                    @Override
                    public void zzf(zzf zzf2) {
                        onInfoWindowLongClickListener.onInfoWindowLongClick(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowCloseListener(final OnInfoWindowCloseListener onInfoWindowCloseListener) {
        try {
            if (onInfoWindowCloseListener == null) {
                this.aeV.setOnInfoWindowCloseListener(null);
            } else {
                this.aeV.setOnInfoWindowCloseListener(new zzn.zza(){

                    @Override
                    public void zzg(zzf zzf2) {
                        onInfoWindowCloseListener.onInfoWindowClose(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setInfoWindowAdapter(final InfoWindowAdapter infoWindowAdapter) {
        try {
            if (infoWindowAdapter == null) {
                this.aeV.setInfoWindowAdapter(null);
            } else {
                this.aeV.setInfoWindowAdapter(new zzd.zza(){

                    @Override
                    public com.google.android.gms.dynamic.zzd zzh(zzf zzf2) {
                        return zze.zzac((Object)infoWindowAdapter.getInfoWindow(new Marker(zzf2)));
                    }

                    @Override
                    public com.google.android.gms.dynamic.zzd zzi(zzf zzf2) {
                        return zze.zzac((Object)infoWindowAdapter.getInfoContents(new Marker(zzf2)));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final void setOnMyLocationChangeListener(final OnMyLocationChangeListener onMyLocationChangeListener) {
        try {
            if (onMyLocationChangeListener == null) {
                this.aeV.setOnMyLocationChangeListener(null);
            } else {
                this.aeV.setOnMyLocationChangeListener(new zzx.zza(){

                    @Override
                    public void zzae(com.google.android.gms.dynamic.zzd zzd2) {
                        onMyLocationChangeListener.onMyLocationChange((Location)zze.zzad((com.google.android.gms.dynamic.zzd)zzd2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMyLocationButtonClickListener(final OnMyLocationButtonClickListener onMyLocationButtonClickListener) {
        try {
            if (onMyLocationButtonClickListener == null) {
                this.aeV.setOnMyLocationButtonClickListener(null);
            } else {
                this.aeV.setOnMyLocationButtonClickListener(new zzw.zza(){

                    @Override
                    public boolean onMyLocationButtonClick() throws RemoteException {
                        return onMyLocationButtonClickListener.onMyLocationButtonClick();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setOnMapLoadedCallback(final OnMapLoadedCallback onMapLoadedCallback) {
        try {
            if (onMapLoadedCallback == null) {
                this.aeV.setOnMapLoadedCallback(null);
            } else {
                this.aeV.setOnMapLoadedCallback(new zzr.zza(){

                    @Override
                    public void onMapLoaded() throws RemoteException {
                        onMapLoadedCallback.onMapLoaded();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnGroundOverlayClickListener(final OnGroundOverlayClickListener onGroundOverlayClickListener) {
        try {
            if (onGroundOverlayClickListener == null) {
                this.aeV.setOnGroundOverlayClickListener(null);
            } else {
                this.aeV.setOnGroundOverlayClickListener(new zzk.zza(){

                    @Override
                    public void zza(zzc zzc2) {
                        onGroundOverlayClickListener.onGroundOverlayClick(new GroundOverlay(zzc2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCircleClickListener(final OnCircleClickListener onCircleClickListener) {
        try {
            if (onCircleClickListener == null) {
                this.aeV.setOnCircleClickListener(null);
            } else {
                this.aeV.setOnCircleClickListener(new zzj.zza(){

                    @Override
                    public void zza(zzb zzb2) {
                        onCircleClickListener.onCircleClick(new Circle(zzb2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnPolygonClickListener(final OnPolygonClickListener onPolygonClickListener) {
        try {
            if (onPolygonClickListener == null) {
                this.aeV.setOnPolygonClickListener(null);
            } else {
                this.aeV.setOnPolygonClickListener(new zzz.zza(){

                    @Override
                    public void zza(zzg zzg2) {
                        onPolygonClickListener.onPolygonClick(new Polygon(zzg2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnPolylineClickListener(final OnPolylineClickListener onPolylineClickListener) {
        try {
            if (onPolylineClickListener == null) {
                this.aeV.setOnPolylineClickListener(null);
            } else {
                this.aeV.setOnPolylineClickListener(new zzaa.zza(){

                    @Override
                    public void zza(IPolylineDelegate iPolylineDelegate) {
                        onPolylineClickListener.onPolylineClick(new Polyline(iPolylineDelegate));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        this.snapshot(snapshotReadyCallback, null);
    }

    public final void snapshot(final SnapshotReadyCallback snapshotReadyCallback, Bitmap bitmap) {
        zze zze2 = (zze)(bitmap != null ? zze.zzac((Object)bitmap) : null);
        try {
            this.aeV.snapshot(new zzag.zza(){

                @Override
                public void onSnapshotReady(Bitmap bitmap) throws RemoteException {
                    snapshotReadyCallback.onSnapshotReady(bitmap);
                }

                @Override
                public void zzaf(com.google.android.gms.dynamic.zzd zzd2) throws RemoteException {
                    snapshotReadyCallback.onSnapshotReady((Bitmap)zze.zzad((com.google.android.gms.dynamic.zzd)zzd2));
                }
            }, (com.google.android.gms.dynamic.zzd)zze2);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setPadding(int n, int n2, int n3, int n4) {
        try {
            this.aeV.setPadding(n, n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setContentDescription(String string) {
        try {
            this.aeV.setContentDescription(string);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setMinZoomPreference(float f) {
        try {
            this.aeV.setMinZoomPreference(f);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setMaxZoomPreference(float f) {
        try {
            this.aeV.setMaxZoomPreference(f);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void resetMinMaxZoomPreference() {
        try {
            this.aeV.resetMinMaxZoomPreference();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setLatLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        try {
            this.aeV.setLatLngBoundsForCameraTarget(latLngBounds);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    private static final class zza
    extends zzb.zza {
        private final CancelableCallback afx;

        zza(CancelableCallback cancelableCallback) {
            this.afx = cancelableCallback;
        }

        @Override
        public void onFinish() {
            this.afx.onFinish();
        }

        @Override
        public void onCancel() {
            this.afx.onCancel();
        }
    }

    public static interface OnGroundOverlayClickListener {
        public void onGroundOverlayClick(GroundOverlay var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMyLocationButtonClickListener {
        public boolean onMyLocationButtonClick();
    }

    @Deprecated
    public static interface OnMyLocationChangeListener {
        public void onMyLocationChange(Location var1);
    }

    public static interface InfoWindowAdapter {
        public View getInfoWindow(Marker var1);

        public View getInfoContents(Marker var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface CancelableCallback {
        public void onFinish();

        public void onCancel();
    }

    public static interface OnInfoWindowCloseListener {
        public void onInfoWindowClose(Marker var1);
    }

    public static interface OnInfoWindowLongClickListener {
        public void onInfoWindowLongClick(Marker var1);
    }

    public static interface OnInfoWindowClickListener {
        public void onInfoWindowClick(Marker var1);
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDragStart(Marker var1);

        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnPolylineClickListener {
        public void onPolylineClick(Polyline var1);
    }

    public static interface OnPolygonClickListener {
        public void onPolygonClick(Polygon var1);
    }

    public static interface OnCircleClickListener {
        public void onCircleClick(Circle var1);
    }

    @Deprecated
    public static interface OnCameraChangeListener {
        public void onCameraChange(CameraPosition var1);
    }

    public static interface OnCameraIdleListener {
        public void onCameraIdle();
    }

    public static interface OnCameraMoveCanceledListener {
        public void onCameraMoveCanceled();
    }

    public static interface OnCameraMoveListener {
        public void onCameraMove();
    }

    public static interface OnCameraMoveStartedListener {
        public static final int REASON_GESTURE = 1;
        public static final int REASON_API_ANIMATION = 2;
        public static final int REASON_DEVELOPER_ANIMATION = 3;

        public void onCameraMoveStarted(int var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);
    }

    public static interface OnIndoorStateChangeListener {
        public void onIndoorBuildingFocused();

        public void onIndoorLevelActivated(IndoorBuilding var1);
    }
}

