/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzad;
import com.google.android.gms.maps.internal.zzo;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzaZz;
    private GoogleMap zzaZt;

    public MapView(Context context) {
        super(context);
        this.zzaZz = new zzb((ViewGroup)this, context, null);
        this.zzDG();
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzaZz = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzDG();
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzaZz = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzDG();
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.zzaZz = new zzb((ViewGroup)this, context, googleMapOptions);
        this.zzDG();
    }

    private void zzDG() {
        this.setClickable(true);
    }

    @Deprecated
    public final GoogleMap getMap() {
        if (this.zzaZt != null) {
            return this.zzaZt;
        }
        this.zzaZz.zzDF();
        if (this.zzaZz.zzxd() == null) {
            return null;
        }
        try {
            this.zzaZt = new GoogleMap(((zza)this.zzaZz.zzxd()).zzDH().getMap());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this.zzaZt;
    }

    public final void onCreate(Bundle bundle) {
        this.zzaZz.onCreate(bundle);
        if (this.zzaZz.zzxd() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.zzaZz.onResume();
    }

    public final void onPause() {
        this.zzaZz.onPause();
    }

    public final void onDestroy() {
        this.zzaZz.onDestroy();
    }

    public final void onLowMemory() {
        this.zzaZz.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zzaZz.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzaa.zzdc((String)"getMapAsync() must be called on the main thread");
        this.zzaZz.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzaa.zzdc((String)"onEnterAmbient() must be called on the main thread");
        this.zzaZz.onEnterAmbient(bundle);
    }

    public final void onExitAmbient() {
        zzaa.zzdc((String)"onExitAmbient() must be called on the main thread");
        this.zzaZz.onExitAmbient();
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzaZE;
        private final Context mContext;
        protected zzf<zza> zzaZx;
        private final GoogleMapOptions zzaZF;
        private final List<OnMapReadyCallback> zzaZy = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzaZE = viewGroup;
            this.mContext = context;
            this.zzaZF = googleMapOptions;
        }

        protected void zza(zzf<zza> zzf2) {
            this.zzaZx = zzf2;
            this.zzDF();
        }

        public void zzDF() {
            if (this.zzaZx != null && this.zzxd() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzad.zzaZ(this.mContext).zza(zze.zzD((Object)this.mContext), this.zzaZF);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.zzaZx.zza((LifecycleDelegate)new zza(this.zzaZE, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaZy) {
                        ((zza)this.zzxd()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaZy.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzxd() != null) {
                ((zza)this.zzxd()).getMapAsync(onMapReadyCallback);
            } else {
                this.zzaZy.add(onMapReadyCallback);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            if (this.zzxd() != null) {
                ((zza)this.zzxd()).onEnterAmbient(bundle);
            }
        }

        public void onExitAmbient() {
            if (this.zzxd() != null) {
                ((zza)this.zzxd()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzaZA;
        private final IMapViewDelegate zzaZB;
        private View zzaZC;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzaZB = (IMapViewDelegate)zzaa.zzz((Object)iMapViewDelegate);
            this.zzaZA = (ViewGroup)zzaa.zzz((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public void onCreate(Bundle bundle) {
            try {
                this.zzaZB.onCreate(bundle);
                this.zzaZC = (View)zze.zzx((zzd)this.zzaZB.getView());
                this.zzaZA.removeAllViews();
                this.zzaZA.addView(this.zzaZC);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.zzaZB.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaZB.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public void onDestroy() {
            try {
                this.zzaZB.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzaZB.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzaZB.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapViewDelegate zzDH() {
            return this.zzaZB;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzaZB.getMapAsync(new zzo.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        onMapReadyCallback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            try {
                this.zzaZB.onEnterAmbient(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.zzaZB.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

