/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.zza;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final zza CREATOR = new zza();
    private final int mVersionCode;
    private Boolean zzaZf;
    private Boolean zzaZg;
    private int zzaZh = -1;
    private CameraPosition zzaZi;
    private Boolean zzaZj;
    private Boolean zzaZk;
    private Boolean zzaZl;
    private Boolean zzaZm;
    private Boolean zzaZn;
    private Boolean zzaZo;
    private Boolean zzaZp;
    private Boolean zzaZq;
    private Boolean zzaZr;

    GoogleMapOptions(int n, byte by, byte by2, int n2, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11) {
        this.mVersionCode = n;
        this.zzaZf = com.google.android.gms.maps.internal.zza.zza(by);
        this.zzaZg = com.google.android.gms.maps.internal.zza.zza(by2);
        this.zzaZh = n2;
        this.zzaZi = cameraPosition;
        this.zzaZj = com.google.android.gms.maps.internal.zza.zza(by3);
        this.zzaZk = com.google.android.gms.maps.internal.zza.zza(by4);
        this.zzaZl = com.google.android.gms.maps.internal.zza.zza(by5);
        this.zzaZm = com.google.android.gms.maps.internal.zza.zza(by6);
        this.zzaZn = com.google.android.gms.maps.internal.zza.zza(by7);
        this.zzaZo = com.google.android.gms.maps.internal.zza.zza(by8);
        this.zzaZp = com.google.android.gms.maps.internal.zza.zza(by9);
        this.zzaZq = com.google.android.gms.maps.internal.zza.zza(by10);
        this.zzaZr = com.google.android.gms.maps.internal.zza.zza(by11);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    byte zzDt() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaZf);
    }

    byte zzDu() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaZg);
    }

    byte zzDv() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaZj);
    }

    byte zzDw() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaZk);
    }

    byte zzDx() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaZl);
    }

    byte zzDy() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaZm);
    }

    byte zzDz() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaZn);
    }

    byte zzDA() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaZo);
    }

    byte zzDB() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaZp);
    }

    byte zzDC() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaZq);
    }

    byte zzDD() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaZr);
    }

    public GoogleMapOptions() {
        this.mVersionCode = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzaZf = bl;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzaZg = bl;
        return this;
    }

    public GoogleMapOptions mapType(int n) {
        this.zzaZh = n;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzaZi = cameraPosition;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zzaZj = bl;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean bl) {
        this.zzaZk = bl;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzaZl = bl;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzaZm = bl;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzaZn = bl;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzaZo = bl;
        return this;
    }

    public GoogleMapOptions liteMode(boolean bl) {
        this.zzaZp = bl;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzaZq = bl;
        return this;
    }

    public GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzaZr = bl;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.zzaZf;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.zzaZg;
    }

    public int getMapType() {
        return this.zzaZh;
    }

    public CameraPosition getCamera() {
        return this.zzaZi;
    }

    public Boolean getZoomControlsEnabled() {
        return this.zzaZj;
    }

    public Boolean getCompassEnabled() {
        return this.zzaZk;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.zzaZl;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.zzaZm;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.zzaZn;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.zzaZo;
    }

    public Boolean getLiteMode() {
        return this.zzaZp;
    }

    public Boolean getMapToolbarEnabled() {
        return this.zzaZq;
    }

    public Boolean getAmbientEnabled() {
        return this.zzaZr;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

