/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzd;

public final class LatLngBounds
implements SafeParcelable {
    public static final zzd CREATOR = new zzd();
    private final int mVersionCode;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int n, LatLng latLng, LatLng latLng2) {
        zzaa.zzb((Object)latLng, (Object)"null southwest");
        zzaa.zzb((Object)latLng2, (Object)"null northeast");
        zzaa.zzb((latLng2.latitude >= latLng.latitude ? 1 : 0) != 0, (String)"southern latitude exceeds northern latitude (%s > %s)", (Object[])new Object[]{latLng.latitude, latLng2.latitude});
        this.mVersionCode = n;
        this.southwest = latLng;
        this.northeast = latLng2;
    }

    public LatLngBounds(LatLng latLng, LatLng latLng2) {
        this(1, latLng, latLng2);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public int describeContents() {
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng latLng) {
        LatLng latLng2 = latLng;
        return this.zzi(latLng2.latitude) && this.zzj(latLng2.longitude);
    }

    public LatLngBounds including(LatLng latLng) {
        LatLng latLng2 = latLng;
        double d = Math.min(this.southwest.latitude, latLng2.latitude);
        double d2 = Math.max(this.northeast.latitude, latLng2.latitude);
        double d3 = this.northeast.longitude;
        double d4 = this.southwest.longitude;
        double d5 = latLng2.longitude;
        if (!this.zzj(d5)) {
            if (LatLngBounds.zzb(d4, d5) < LatLngBounds.zzc(d3, d5)) {
                d4 = d5;
            } else {
                d3 = d5;
            }
        }
        return new LatLngBounds(new LatLng(d, d4), new LatLng(d2, d3));
    }

    public LatLng getCenter() {
        double d = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d2 = this.southwest.longitude;
        double d3 = this.northeast.longitude;
        double d4 = d2 <= d3 ? (d3 + d2) / 2.0 : (d3 + 360.0 + d2) / 2.0;
        return new LatLng(d, d4);
    }

    private static double zzb(double d, double d2) {
        return (d - d2 + 360.0) % 360.0;
    }

    private static double zzc(double d, double d2) {
        return (d2 - d + 360.0) % 360.0;
    }

    private boolean zzi(double d) {
        return this.southwest.latitude <= d && d <= this.northeast.latitude;
    }

    private boolean zzj(double d) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d && d <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d || d <= this.northeast.longitude;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.southwest, this.northeast});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)object;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return zzz.zzy((Object)this).zzg("southwest", (Object)this.southwest).zzg("northeast", (Object)this.northeast).toString();
    }

    public static final class Builder {
        private double zzbaK = Double.POSITIVE_INFINITY;
        private double zzbaL = Double.NEGATIVE_INFINITY;
        private double zzbaM = Double.NaN;
        private double zzbaN = Double.NaN;

        public Builder include(LatLng latLng) {
            this.zzbaK = Math.min(this.zzbaK, latLng.latitude);
            this.zzbaL = Math.max(this.zzbaL, latLng.latitude);
            double d = latLng.longitude;
            if (Double.isNaN(this.zzbaM)) {
                this.zzbaM = d;
                this.zzbaN = d;
            } else if (!this.zzj(d)) {
                if (LatLngBounds.zzb(this.zzbaM, d) < LatLngBounds.zzc(this.zzbaN, d)) {
                    this.zzbaM = d;
                } else {
                    this.zzbaN = d;
                }
            }
            return this;
        }

        private boolean zzj(double d) {
            if (this.zzbaM <= this.zzbaN) {
                return this.zzbaM <= d && d <= this.zzbaN;
            }
            return this.zzbaM <= d || d <= this.zzbaN;
        }

        public LatLngBounds build() {
            zzaa.zza((!Double.isNaN(this.zzbaM) ? 1 : 0) != 0, (Object)"no included points");
            return new LatLngBounds(new LatLng(this.zzbaK, this.zzbaM), new LatLng(this.zzbaL, this.zzbaN));
        }
    }
}

