/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzc;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final zzc CREATOR = new zzc();
    public static final float NO_DIMENSION = -1.0f;
    private final int mVersionCode;
    private BitmapDescriptor zzbaA;
    private LatLng zzbaB;
    private float zzbaC;
    private float zzbaD;
    private LatLngBounds zzaYA;
    private float zzbaq;
    private float zzbax;
    private boolean zzbay = true;
    private float zzbaE = 0.0f;
    private float zzbaF = 0.5f;
    private float zzbaG = 0.5f;
    private boolean zzbaH = false;

    GroundOverlayOptions(int n, IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.mVersionCode = n;
        this.zzbaA = new BitmapDescriptor(zzd.zza.zzbz((IBinder)iBinder));
        this.zzbaB = latLng;
        this.zzbaC = f;
        this.zzbaD = f2;
        this.zzaYA = latLngBounds;
        this.zzbaq = f3;
        this.zzbax = f4;
        this.zzbay = bl;
        this.zzbaE = f5;
        this.zzbaF = f6;
        this.zzbaG = f7;
        this.zzbaH = bl2;
    }

    public GroundOverlayOptions() {
        this.mVersionCode = 1;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public int describeContents() {
        return 0;
    }

    IBinder zzDT() {
        return this.zzbaA.zzDq().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor bitmapDescriptor) {
        this.zzbaA = bitmapDescriptor;
        return this;
    }

    public GroundOverlayOptions anchor(float f, float f2) {
        this.zzbaF = f;
        this.zzbaG = f2;
        return this;
    }

    public GroundOverlayOptions position(LatLng latLng, float f) {
        zzaa.zza((this.zzaYA == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzaa.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzaa.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzaa.zza((this.zzaYA == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzaa.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzaa.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzaa.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzbaB = latLng;
        this.zzbaC = f;
        this.zzbaD = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf(this.zzbaB);
        zzaa.zza((this.zzbaB == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zzaYA = latLngBounds;
        return this;
    }

    public GroundOverlayOptions bearing(float f) {
        this.zzbaq = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float f) {
        this.zzbax = f;
        return this;
    }

    public GroundOverlayOptions visible(boolean bl) {
        this.zzbay = bl;
        return this;
    }

    public GroundOverlayOptions transparency(float f) {
        zzaa.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzbaE = f;
        return this;
    }

    public GroundOverlayOptions clickable(boolean bl) {
        this.zzbaH = bl;
        return this;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public BitmapDescriptor getImage() {
        return this.zzbaA;
    }

    public LatLng getLocation() {
        return this.zzbaB;
    }

    public float getWidth() {
        return this.zzbaC;
    }

    public float getHeight() {
        return this.zzbaD;
    }

    public LatLngBounds getBounds() {
        return this.zzaYA;
    }

    public float getBearing() {
        return this.zzbaq;
    }

    public float getZIndex() {
        return this.zzbax;
    }

    public float getTransparency() {
        return this.zzbaE;
    }

    public float getAnchorU() {
        return this.zzbaF;
    }

    public float getAnchorV() {
        return this.zzbaG;
    }

    public boolean isVisible() {
        return this.zzbay;
    }

    public boolean isClickable() {
        return this.zzbaH;
    }
}

