/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import com.google.android.gms.maps.model.Tile;
import com.google.android.gms.maps.model.TileProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public abstract class UrlTileProvider
implements TileProvider {
    private final int zzoG;
    private final int zzoH;

    public UrlTileProvider(int width, int height) {
        this.zzoG = width;
        this.zzoH = height;
    }

    public abstract URL getTileUrl(int var1, int var2, int var3);

    @Override
    public final Tile getTile(int x, int y, int zoom) {
        Tile tile;
        URL uRL = this.getTileUrl(x, y, zoom);
        if (uRL == null) {
            return NO_TILE;
        }
        try {
            tile = new Tile(this.zzoG, this.zzoH, UrlTileProvider.zzl(uRL.openStream()));
        }
        catch (IOException iOException) {
            tile = null;
        }
        return tile;
    }

    private static byte[] zzl(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        UrlTileProvider.zza(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static long zza(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }
}

