/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzc;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final zzc CREATOR = new zzc();
    public static final float NO_DIMENSION = -1.0f;
    private final int mVersionCode;
    private BitmapDescriptor zzaTk;
    private LatLng zzaTl;
    private float zzaTm;
    private float zzaTn;
    private LatLngBounds zzaRk;
    private float zzaTa;
    private float zzaTh;
    private boolean zzaTi = true;
    private float zzaTo = 0.0f;
    private float zzaTp = 0.5f;
    private float zzaTq = 0.5f;
    private boolean zzaTr = false;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV, boolean clickable) {
        this.mVersionCode = versionCode;
        this.zzaTk = new BitmapDescriptor(zzd.zza.zzbs((IBinder)wrappedImage));
        this.zzaTl = location;
        this.zzaTm = width;
        this.zzaTn = height;
        this.zzaRk = bounds;
        this.zzaTa = bearing;
        this.zzaTh = zIndex;
        this.zzaTi = visible;
        this.zzaTo = transparency;
        this.zzaTp = anchorU;
        this.zzaTq = anchorV;
        this.zzaTr = clickable;
    }

    public GroundOverlayOptions() {
        this.mVersionCode = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzc.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    IBinder zzAj() {
        return this.zzaTk.zzzH().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.zzaTk = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u, float v) {
        this.zzaTp = u;
        this.zzaTq = v;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        zzx.zza((this.zzaRk == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzx.zzb((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzx.zzb((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        zzx.zza((this.zzaRk == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzx.zzb((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzx.zzb((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzx.zzb((height >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(location, width, height);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzaTl = latLng;
        this.zzaTm = f;
        this.zzaTn = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        zzx.zza((this.zzaTl == null ? 1 : 0) != 0, (Object)("Position has already been set using position: " + this.zzaTl));
        this.zzaRk = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.zzaTa = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.zzaTh = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.zzaTi = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        zzx.zzb((transparency >= 0.0f && transparency <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzaTo = transparency;
        return this;
    }

    public GroundOverlayOptions clickable(boolean clickable) {
        this.zzaTr = clickable;
        return this;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public BitmapDescriptor getImage() {
        return this.zzaTk;
    }

    public LatLng getLocation() {
        return this.zzaTl;
    }

    public float getWidth() {
        return this.zzaTm;
    }

    public float getHeight() {
        return this.zzaTn;
    }

    public LatLngBounds getBounds() {
        return this.zzaRk;
    }

    public float getBearing() {
        return this.zzaTa;
    }

    public float getZIndex() {
        return this.zzaTh;
    }

    public float getTransparency() {
        return this.zzaTo;
    }

    public float getAnchorU() {
        return this.zzaTp;
    }

    public float getAnchorV() {
        return this.zzaTq;
    }

    public boolean isVisible() {
        return this.zzaTi;
    }

    public boolean isClickable() {
        return this.zzaTr;
    }
}

