/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.zza;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final zza CREATOR = new zza();
    private final int mVersionCode;
    private Boolean zzaOR;
    private Boolean zzaOS;
    private int zzaOT = -1;
    private CameraPosition zzaOU;
    private Boolean zzaOV;
    private Boolean zzaOW;
    private Boolean zzaOX;
    private Boolean zzaOY;
    private Boolean zzaOZ;
    private Boolean zzaPa;
    private Boolean zzaPb;
    private Boolean zzaPc;
    private Boolean zzaPd;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled, byte liteMode, byte mapToolbarEnabled, byte ambientEnabled) {
        this.mVersionCode = versionCode;
        this.zzaOR = com.google.android.gms.maps.internal.zza.zza(zOrderOnTop);
        this.zzaOS = com.google.android.gms.maps.internal.zza.zza(useViewLifecycleInFragment);
        this.zzaOT = mapType;
        this.zzaOU = camera;
        this.zzaOV = com.google.android.gms.maps.internal.zza.zza(zoomControlsEnabled);
        this.zzaOW = com.google.android.gms.maps.internal.zza.zza(compassEnabled);
        this.zzaOX = com.google.android.gms.maps.internal.zza.zza(scrollGesturesEnabled);
        this.zzaOY = com.google.android.gms.maps.internal.zza.zza(zoomGesturesEnabled);
        this.zzaOZ = com.google.android.gms.maps.internal.zza.zza(tiltGesturesEnabled);
        this.zzaPa = com.google.android.gms.maps.internal.zza.zza(rotateGesturesEnabled);
        this.zzaPb = com.google.android.gms.maps.internal.zza.zza(liteMode);
        this.zzaPc = com.google.android.gms.maps.internal.zza.zza(mapToolbarEnabled);
        this.zzaPd = com.google.android.gms.maps.internal.zza.zza(ambientEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    byte zzyV() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaOR);
    }

    byte zzyW() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaOS);
    }

    byte zzyX() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaOV);
    }

    byte zzyY() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaOW);
    }

    byte zzyZ() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaOX);
    }

    byte zzza() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaOY);
    }

    byte zzzb() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaOZ);
    }

    byte zzzc() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaPa);
    }

    byte zzzd() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaPb);
    }

    byte zzze() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaPc);
    }

    byte zzzf() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaPd);
    }

    public GoogleMapOptions() {
        this.mVersionCode = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.zzaOR = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.zzaOS = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.zzaOT = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.zzaOU = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.zzaOV = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.zzaOW = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.zzaOX = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.zzaOY = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.zzaOZ = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.zzaPa = enabled;
        return this;
    }

    public GoogleMapOptions liteMode(boolean enabled) {
        this.zzaPb = enabled;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean enabled) {
        this.zzaPc = enabled;
        return this;
    }

    public GoogleMapOptions ambientEnabled(boolean enabled) {
        this.zzaPd = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.zzaOR;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.zzaOS;
    }

    public int getMapType() {
        return this.zzaOT;
    }

    public CameraPosition getCamera() {
        return this.zzaOU;
    }

    public Boolean getZoomControlsEnabled() {
        return this.zzaOV;
    }

    public Boolean getCompassEnabled() {
        return this.zzaOW;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.zzaOX;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.zzaOY;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.zzaOZ;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.zzaPa;
    }

    public Boolean getLiteMode() {
        return this.zzaPb;
    }

    public Boolean getMapToolbarEnabled() {
        return this.zzaPc;
    }

    public Boolean getAmbientEnabled() {
        return this.zzaPd;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

