/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzc;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final zzc CREATOR = new zzc();
    public static final float NO_DIMENSION = -1.0f;
    private final int mVersionCode;
    private BitmapDescriptor zzaJV;
    private LatLng zzaJW;
    private float zzaJX;
    private float zzaJY;
    private LatLngBounds zzaJZ;
    private float zzaJL;
    private float zzaJS;
    private boolean zzaJT = true;
    private float zzaKa = 0.0f;
    private float zzaKb = 0.5f;
    private float zzaKc = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.mVersionCode = versionCode;
        this.zzaJV = new BitmapDescriptor(zzd.zza.zzbk((IBinder)wrappedImage));
        this.zzaJW = location;
        this.zzaJX = width;
        this.zzaJY = height;
        this.zzaJZ = bounds;
        this.zzaJL = bearing;
        this.zzaJS = zIndex;
        this.zzaJT = visible;
        this.zzaKa = transparency;
        this.zzaKb = anchorU;
        this.zzaKc = anchorV;
    }

    public GroundOverlayOptions() {
        this.mVersionCode = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzc.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    IBinder zzxY() {
        return this.zzaJV.zzxw().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.zzaJV = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u, float v) {
        this.zzaKb = u;
        this.zzaKc = v;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        zzx.zza((this.zzaJZ == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzx.zzb((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzx.zzb((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        zzx.zza((this.zzaJZ == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzx.zzb((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzx.zzb((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzx.zzb((height >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(location, width, height);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzaJW = latLng;
        this.zzaJX = f;
        this.zzaJY = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        zzx.zza((this.zzaJW == null ? 1 : 0) != 0, (Object)("Position has already been set using position: " + this.zzaJW));
        this.zzaJZ = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.zzaJL = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.zzaJS = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.zzaJT = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        zzx.zzb((transparency >= 0.0f && transparency <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzaKa = transparency;
        return this;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public BitmapDescriptor getImage() {
        return this.zzaJV;
    }

    public LatLng getLocation() {
        return this.zzaJW;
    }

    public float getWidth() {
        return this.zzaJX;
    }

    public float getHeight() {
        return this.zzaJY;
    }

    public LatLngBounds getBounds() {
        return this.zzaJZ;
    }

    public float getBearing() {
        return this.zzaJL;
    }

    public float getZIndex() {
        return this.zzaJS;
    }

    public float getTransparency() {
        return this.zzaKa;
    }

    public float getAnchorU() {
        return this.zzaKb;
    }

    public float getAnchorV() {
        return this.zzaKc;
    }

    public boolean isVisible() {
        return this.zzaJT;
    }
}

