/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;

public interface ICameraUpdateFactoryDelegate
extends IInterface {
    public zzd zoomIn() throws RemoteException;

    public zzd zoomOut() throws RemoteException;

    public zzd scrollBy(float var1, float var2) throws RemoteException;

    public zzd zoomTo(float var1) throws RemoteException;

    public zzd zoomBy(float var1) throws RemoteException;

    public zzd zoomByWithFocus(float var1, int var2, int var3) throws RemoteException;

    public zzd newCameraPosition(CameraPosition var1) throws RemoteException;

    public zzd newLatLng(LatLng var1) throws RemoteException;

    public zzd newLatLngZoom(LatLng var1, float var2) throws RemoteException;

    public zzd newLatLngBounds(LatLngBounds var1, int var2) throws RemoteException;

    public zzd newLatLngBoundsWithSize(LatLngBounds var1, int var2, int var3, int var4) throws RemoteException;

    public static abstract class com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate$zza
    extends Binder
    implements ICameraUpdateFactoryDelegate {
        public static ICameraUpdateFactoryDelegate zzcj(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
            if (iInterface != null && iInterface instanceof ICameraUpdateFactoryDelegate) {
                return (ICameraUpdateFactoryDelegate)iInterface;
            }
            return new zza(iBinder);
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    return true;
                }
                case 1: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    zzd zzd2 = this.zoomIn();
                    reply.writeNoException();
                    reply.writeStrongBinder(zzd2 != null ? zzd2.asBinder() : null);
                    return true;
                }
                case 2: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    zzd zzd3 = this.zoomOut();
                    reply.writeNoException();
                    reply.writeStrongBinder(zzd3 != null ? zzd3.asBinder() : null);
                    return true;
                }
                case 3: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f = data.readFloat();
                    float f2 = data.readFloat();
                    zzd zzd4 = this.scrollBy(f, f2);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzd4 != null ? zzd4.asBinder() : null);
                    return true;
                }
                case 4: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f = data.readFloat();
                    zzd zzd5 = this.zoomTo(f);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzd5 != null ? zzd5.asBinder() : null);
                    return true;
                }
                case 5: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f = data.readFloat();
                    zzd zzd6 = this.zoomBy(f);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzd6 != null ? zzd6.asBinder() : null);
                    return true;
                }
                case 6: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f = data.readFloat();
                    int n = data.readInt();
                    int n2 = data.readInt();
                    zzd zzd7 = this.zoomByWithFocus(f, n, n2);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzd7 != null ? zzd7.asBinder() : null);
                    return true;
                }
                case 7: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    CameraPosition cameraPosition = 0 != data.readInt() ? CameraPosition.CREATOR.zzfh(data) : null;
                    zzd zzd8 = this.newCameraPosition(cameraPosition);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzd8 != null ? zzd8.asBinder() : null);
                    return true;
                }
                case 8: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLng latLng = 0 != data.readInt() ? LatLng.CREATOR.zzfl(data) : null;
                    zzd zzd9 = this.newLatLng(latLng);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzd9 != null ? zzd9.asBinder() : null);
                    return true;
                }
                case 9: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLng latLng = 0 != data.readInt() ? LatLng.CREATOR.zzfl(data) : null;
                    float f = data.readFloat();
                    zzd zzd10 = this.newLatLngZoom(latLng, f);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzd10 != null ? zzd10.asBinder() : null);
                    return true;
                }
                case 10: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLngBounds latLngBounds = 0 != data.readInt() ? LatLngBounds.CREATOR.zzfk(data) : null;
                    int n = data.readInt();
                    zzd zzd11 = this.newLatLngBounds(latLngBounds, n);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzd11 != null ? zzd11.asBinder() : null);
                    return true;
                }
                case 11: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLngBounds latLngBounds = 0 != data.readInt() ? LatLngBounds.CREATOR.zzfk(data) : null;
                    int n = data.readInt();
                    int n3 = data.readInt();
                    int n4 = data.readInt();
                    zzd zzd12 = this.newLatLngBoundsWithSize(latLngBounds, n, n3, n4);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzd12 != null ? zzd12.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class zza
        implements ICameraUpdateFactoryDelegate {
            private IBinder zznJ;

            zza(IBinder iBinder) {
                this.zznJ = iBinder;
            }

            public IBinder asBinder() {
                return this.zznJ;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzd zoomIn() throws RemoteException {
                zzd zzd2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    this.zznJ.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    zzd2 = zzd.zza.zzbk((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzd2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzd zoomOut() throws RemoteException {
                zzd zzd2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    this.zznJ.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    zzd2 = zzd.zza.zzbk((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzd2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzd scrollBy(float xPixel, float yPixel) throws RemoteException {
                zzd zzd2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(xPixel);
                    parcel.writeFloat(yPixel);
                    this.zznJ.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    zzd2 = zzd.zza.zzbk((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzd2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzd zoomTo(float zoom) throws RemoteException {
                zzd zzd2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(zoom);
                    this.zznJ.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    zzd2 = zzd.zza.zzbk((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzd2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzd zoomBy(float amount) throws RemoteException {
                zzd zzd2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(amount);
                    this.zznJ.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    zzd2 = zzd.zza.zzbk((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzd2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzd zoomByWithFocus(float amount, int screenFocusX, int screenFocusY) throws RemoteException {
                zzd zzd2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(amount);
                    parcel.writeInt(screenFocusX);
                    parcel.writeInt(screenFocusY);
                    this.zznJ.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    zzd2 = zzd.zza.zzbk((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzd2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzd newCameraPosition(CameraPosition cameraPosition) throws RemoteException {
                zzd zzd2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (cameraPosition != null) {
                        parcel.writeInt(1);
                        cameraPosition.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznJ.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    zzd2 = zzd.zza.zzbk((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzd2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzd newLatLng(LatLng latLng) throws RemoteException {
                zzd zzd2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (latLng != null) {
                        parcel.writeInt(1);
                        latLng.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznJ.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    zzd2 = zzd.zza.zzbk((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzd2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzd newLatLngZoom(LatLng latLng, float zoom) throws RemoteException {
                zzd zzd2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (latLng != null) {
                        parcel.writeInt(1);
                        latLng.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeFloat(zoom);
                    this.zznJ.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    zzd2 = zzd.zza.zzbk((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzd2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzd newLatLngBounds(LatLngBounds bounds, int padding) throws RemoteException {
                zzd zzd2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (bounds != null) {
                        parcel.writeInt(1);
                        bounds.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(padding);
                    this.zznJ.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    zzd2 = zzd.zza.zzbk((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzd2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzd newLatLngBoundsWithSize(LatLngBounds bounds, int width, int height, int padding) throws RemoteException {
                zzd zzd2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (bounds != null) {
                        parcel.writeInt(1);
                        bounds.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(width);
                    parcel.writeInt(height);
                    parcel.writeInt(padding);
                    this.zznJ.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    zzd2 = zzd.zza.zzbk((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzd2;
            }
        }
    }
}

