/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.zzaa;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzm;
import com.google.android.gms.maps.model.zzn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
implements SafeParcelable {
    public static final zzm CREATOR = new zzm();
    private final int zzFG;
    private final List<LatLng> zzarB;
    private final List<List<LatLng>> zzarC;
    private float zzaqY = 10.0f;
    private int zzaqZ = -16777216;
    private int zzara = 0;
    private float zzarb = 0.0f;
    private boolean zzarc = true;
    private boolean zzarD = false;

    public PolygonOptions() {
        this.zzFG = 1;
        this.zzarB = new ArrayList<LatLng>();
        this.zzarC = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.zzFG = versionCode;
        this.zzarB = points;
        this.zzarC = holes;
        this.zzaqY = strokeWidth;
        this.zzaqZ = strokeColor;
        this.zzara = fillColor;
        this.zzarb = zIndex;
        this.zzarc = visible;
        this.zzarD = geodesic;
    }

    int getVersionCode() {
        return this.zzFG;
    }

    List zzqJ() {
        return this.zzarC;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (zzaa.zzqF()) {
            zzn.zza(this, out, flags);
        } else {
            zzm.zza(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.zzarB.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.zzarB.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.zzarB.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.zzarC.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.zzaqY = width;
        return this;
    }

    public PolygonOptions strokeColor(int color) {
        this.zzaqZ = color;
        return this;
    }

    public PolygonOptions fillColor(int color) {
        this.zzara = color;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.zzarb = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.zzarc = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.zzarD = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.zzarB;
    }

    public List<List<LatLng>> getHoles() {
        return this.zzarC;
    }

    public float getStrokeWidth() {
        return this.zzaqY;
    }

    public int getStrokeColor() {
        return this.zzaqZ;
    }

    public int getFillColor() {
        return this.zzara;
    }

    public float getZIndex() {
        return this.zzarb;
    }

    public boolean isVisible() {
        return this.zzarc;
    }

    public boolean isGeodesic() {
        return this.zzarD;
    }
}

