/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.maps.internal.zzaa;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzg;
import com.google.android.gms.maps.model.zzh;

public final class LatLngBounds
implements SafeParcelable {
    public static final zzg CREATOR = new zzg();
    private final int zzFG;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int versionCode, LatLng southwest, LatLng northeast) {
        zzx.zzb((Object)southwest, (Object)"null southwest");
        zzx.zzb((Object)northeast, (Object)"null northeast");
        zzx.zzb((northeast.latitude >= southwest.latitude ? 1 : 0) != 0, (String)"southern latitude exceeds northern latitude (%s > %s)", (Object[])new Object[]{southwest.latitude, northeast.latitude});
        this.zzFG = versionCode;
        this.southwest = southwest;
        this.northeast = northeast;
    }

    public LatLngBounds(LatLng southwest, LatLng northeast) {
        this(1, southwest, northeast);
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (zzaa.zzqF()) {
            zzh.zza(this, out, flags);
        } else {
            zzg.zza(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng point) {
        LatLng latLng = point;
        return this.zzc(latLng.latitude) && this.zzd(latLng.longitude);
    }

    public LatLngBounds including(LatLng point) {
        LatLng latLng = point;
        double d = Math.min(this.southwest.latitude, latLng.latitude);
        double d2 = Math.max(this.northeast.latitude, latLng.latitude);
        double d3 = this.northeast.longitude;
        double d4 = this.southwest.longitude;
        double d5 = latLng.longitude;
        if (!this.zzd(d5)) {
            if (LatLngBounds.zzb(d4, d5) < LatLngBounds.zzc(d3, d5)) {
                d4 = d5;
            } else {
                d3 = d5;
            }
        }
        return new LatLngBounds(new LatLng(d, d4), new LatLng(d2, d3));
    }

    public LatLng getCenter() {
        double d = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d2 = this.southwest.longitude;
        double d3 = this.northeast.longitude;
        double d4 = d2 <= d3 ? (d3 + d2) / 2.0 : (d3 + 360.0 + d2) / 2.0;
        return new LatLng(d, d4);
    }

    private static double zzb(double d, double d2) {
        return (d - d2 + 360.0) % 360.0;
    }

    private static double zzc(double d, double d2) {
        return (d2 - d + 360.0) % 360.0;
    }

    private boolean zzc(double d) {
        return this.southwest.latitude <= d && d <= this.northeast.latitude;
    }

    private boolean zzd(double d) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d && d <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d || d <= this.northeast.longitude;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.southwest, this.northeast});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)o;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("southwest", (Object)this.southwest).zza("northeast", (Object)this.northeast).toString();
    }

    public static final class Builder {
        private double zzaro = Double.POSITIVE_INFINITY;
        private double zzarp = Double.NEGATIVE_INFINITY;
        private double zzarq = Double.NaN;
        private double zzarr = Double.NaN;

        public Builder include(LatLng point) {
            this.zzaro = Math.min(this.zzaro, point.latitude);
            this.zzarp = Math.max(this.zzarp, point.latitude);
            double d = point.longitude;
            if (Double.isNaN(this.zzarq)) {
                this.zzarq = d;
                this.zzarr = d;
            } else if (!this.zzd(d)) {
                if (LatLngBounds.zzb(this.zzarq, d) < LatLngBounds.zzc(this.zzarr, d)) {
                    this.zzarq = d;
                } else {
                    this.zzarr = d;
                }
            }
            return this;
        }

        private boolean zzd(double d) {
            if (this.zzarq <= this.zzarr) {
                return this.zzarq <= d && d <= this.zzarr;
            }
            return this.zzarq <= d || d <= this.zzarr;
        }

        public LatLngBounds build() {
            zzx.zza((!Double.isNaN(this.zzarq) ? 1 : 0) != 0, (Object)"no included points");
            return new LatLngBounds(new LatLng(this.zzaro, this.zzarq), new LatLng(this.zzarp, this.zzarr));
        }
    }
}

