/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.maps.internal.zzaa;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zza;
import com.google.android.gms.maps.model.zzb;

public final class CameraPosition
implements SafeParcelable {
    public static final zza CREATOR = new zza();
    private final int zzFG;
    public final LatLng target;
    public final float zoom;
    public final float tilt;
    public final float bearing;

    CameraPosition(int versionCode, LatLng target, float zoom, float tilt, float bearing) {
        zzx.zzb((Object)target, (Object)"null camera target");
        zzx.zzb((0.0f <= tilt && tilt <= 90.0f ? 1 : 0) != 0, (Object)"Tilt needs to be between 0 and 90 inclusive");
        this.zzFG = versionCode;
        this.target = target;
        this.zoom = zoom;
        this.tilt = tilt + 0.0f;
        this.bearing = ((double)bearing <= 0.0 ? bearing % 360.0f + 360.0f : bearing) % 360.0f;
    }

    public CameraPosition(LatLng target, float zoom, float tilt, float bearing) {
        this(1, target, zoom, tilt, bearing);
    }

    public void writeToParcel(Parcel out, int flags) {
        if (zzaa.zzqF()) {
            zzb.zza(this, out, flags);
        } else {
            zza.zza(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.target, Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public static final CameraPosition fromLatLngZoom(LatLng target, float zoom) {
        return new CameraPosition(target, zoom, 0.0f, 0.0f);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CameraPosition camera) {
        return new Builder(camera);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CameraPosition)) {
            return false;
        }
        CameraPosition cameraPosition = (CameraPosition)o;
        return this.target.equals(cameraPosition.target) && Float.floatToIntBits(this.zoom) == Float.floatToIntBits(cameraPosition.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(cameraPosition.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(cameraPosition.bearing);
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("target", (Object)this.target).zza("zoom", (Object)Float.valueOf(this.zoom)).zza("tilt", (Object)Float.valueOf(this.tilt)).zza("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    public static CameraPosition createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        float f = 0.0f;
        float f2 = 0.0f;
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLat)) {
            f = typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLat, 0.0f);
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLng)) {
            f2 = typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLng, 0.0f);
        }
        LatLng latLng = new LatLng(f, f2);
        Builder builder = CameraPosition.builder();
        builder.target(latLng);
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraZoom)) {
            builder.zoom(typedArray.getFloat(R.styleable.MapAttrs_cameraZoom, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraBearing)) {
            builder.bearing(typedArray.getFloat(R.styleable.MapAttrs_cameraBearing, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTilt)) {
            builder.tilt(typedArray.getFloat(R.styleable.MapAttrs_cameraTilt, 0.0f));
        }
        return builder.build();
    }

    public static final class Builder {
        private LatLng zzaqR;
        private float zzaqS;
        private float zzaqT;
        private float zzaqU;

        public Builder() {
        }

        public Builder(CameraPosition previous) {
            CameraPosition cameraPosition = previous;
            this.zzaqR = cameraPosition.target;
            this.zzaqS = cameraPosition.zoom;
            this.zzaqT = cameraPosition.tilt;
            this.zzaqU = cameraPosition.bearing;
        }

        public Builder target(LatLng location) {
            this.zzaqR = location;
            return this;
        }

        public Builder zoom(float zoom) {
            this.zzaqS = zoom;
            return this;
        }

        public Builder tilt(float tilt) {
            this.zzaqT = tilt;
            return this;
        }

        public Builder bearing(float bearing) {
            this.zzaqU = bearing;
            return this;
        }

        public CameraPosition build() {
            return new CameraPosition(this.zzaqR, this.zzaqS, this.zzaqT, this.zzaqU);
        }
    }
}

