/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzm;
import com.google.android.gms.maps.internal.zzx;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzaqc;
    private GoogleMap zzapW;

    public MapView(Context context) {
        super(context);
        this.zzaqc = new zzb((ViewGroup)this, context, null);
    }

    public MapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.zzaqc = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
    }

    public MapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.zzaqc = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
    }

    public MapView(Context context, GoogleMapOptions options) {
        super(context);
        this.zzaqc = new zzb((ViewGroup)this, context, options);
    }

    @Deprecated
    public final GoogleMap getMap() {
        if (this.zzapW != null) {
            return this.zzapW;
        }
        this.zzaqc.zzqs();
        if (this.zzaqc.zzlg() == null) {
            return null;
        }
        try {
            this.zzapW = new GoogleMap(((zza)this.zzaqc.zzlg()).zzqt().getMap());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this.zzapW;
    }

    public final void onCreate(Bundle savedInstanceState) {
        this.zzaqc.onCreate(savedInstanceState);
        if (this.zzaqc.zzlg() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.zzaqc.onResume();
    }

    public final void onPause() {
        this.zzaqc.onPause();
    }

    public final void onDestroy() {
        this.zzaqc.onDestroy();
    }

    public final void onLowMemory() {
        this.zzaqc.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle outState) {
        this.zzaqc.onSaveInstanceState(outState);
    }

    public void getMapAsync(OnMapReadyCallback callback) {
        com.google.android.gms.common.internal.zzx.zzbd((String)"getMapAsync() must be called on the main thread");
        this.zzaqc.getMapAsync(callback);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzaqh;
        private final Context mContext;
        protected zzf<zza> zzaqa;
        private final GoogleMapOptions zzaqi;
        private final List<OnMapReadyCallback> zzaqb = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzaqh = viewGroup;
            this.mContext = context;
            this.zzaqi = googleMapOptions;
        }

        protected void zza(zzf<zza> zzf2) {
            this.zzaqa = zzf2;
            this.zzqs();
        }

        public void zzqs() {
            if (this.zzaqa != null && this.zzlg() == null) {
                try {
                    IMapViewDelegate iMapViewDelegate = zzx.zzac(this.mContext).zza(zze.zzn((Object)this.mContext), this.zzaqi);
                    this.zzaqa.zza((LifecycleDelegate)new zza(this.zzaqh, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaqb) {
                        ((zza)this.zzlg()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaqb.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        public void getMapAsync(OnMapReadyCallback callback) {
            if (this.zzlg() != null) {
                ((zza)this.zzlg()).getMapAsync(callback);
            } else {
                this.zzaqb.add(callback);
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzaqd;
        private final IMapViewDelegate zzaqe;
        private View zzaqf;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzaqe = (IMapViewDelegate)com.google.android.gms.common.internal.zzx.zzl((Object)iMapViewDelegate);
            this.zzaqd = (ViewGroup)com.google.android.gms.common.internal.zzx.zzl((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzaqe.onCreate(savedInstanceState);
                this.zzaqf = (View)zze.zzf((zzd)this.zzaqe.getView());
                this.zzaqd.removeAllViews();
                this.zzaqd.addView(this.zzaqf);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.zzaqe.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaqe.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public void onDestroy() {
            try {
                this.zzaqe.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzaqe.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaqe.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapViewDelegate zzqt() {
            return this.zzaqe;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback callback) {
            try {
                this.zzaqe.getMapAsync(new zzm.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        callback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

