/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.internal.zzaa;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.zzb;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final com.google.android.gms.maps.zza CREATOR = new com.google.android.gms.maps.zza();
    private final int zzFG;
    private Boolean zzapJ;
    private Boolean zzapK;
    private int zzapL = -1;
    private CameraPosition zzapM;
    private Boolean zzapN;
    private Boolean zzapO;
    private Boolean zzapP;
    private Boolean zzapQ;
    private Boolean zzapR;
    private Boolean zzapS;
    private Boolean zzapT;
    private Boolean zzapU;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled, byte liteMode, byte mapToolbarEnabled) {
        this.zzFG = versionCode;
        this.zzapJ = zza.zza(zOrderOnTop);
        this.zzapK = zza.zza(useViewLifecycleInFragment);
        this.zzapL = mapType;
        this.zzapM = camera;
        this.zzapN = zza.zza(zoomControlsEnabled);
        this.zzapO = zza.zza(compassEnabled);
        this.zzapP = zza.zza(scrollGesturesEnabled);
        this.zzapQ = zza.zza(zoomGesturesEnabled);
        this.zzapR = zza.zza(tiltGesturesEnabled);
        this.zzapS = zza.zza(rotateGesturesEnabled);
        this.zzapT = zza.zza(liteMode);
        this.zzapU = zza.zza(mapToolbarEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (zzaa.zzqF()) {
            zzb.zza(this, out, flags);
        } else {
            com.google.android.gms.maps.zza.zza(this, out, flags);
        }
    }

    int getVersionCode() {
        return this.zzFG;
    }

    byte zzqh() {
        return zza.zzd(this.zzapJ);
    }

    byte zzqi() {
        return zza.zzd(this.zzapK);
    }

    byte zzqj() {
        return zza.zzd(this.zzapN);
    }

    byte zzqk() {
        return zza.zzd(this.zzapO);
    }

    byte zzql() {
        return zza.zzd(this.zzapP);
    }

    byte zzqm() {
        return zza.zzd(this.zzapQ);
    }

    byte zzqn() {
        return zza.zzd(this.zzapR);
    }

    byte zzqo() {
        return zza.zzd(this.zzapS);
    }

    byte zzqp() {
        return zza.zzd(this.zzapT);
    }

    byte zzqq() {
        return zza.zzd(this.zzapU);
    }

    public GoogleMapOptions() {
        this.zzFG = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.zzapJ = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.zzapK = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.zzapL = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.zzapM = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.zzapN = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.zzapO = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.zzapP = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.zzapQ = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.zzapR = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.zzapS = enabled;
        return this;
    }

    public GoogleMapOptions liteMode(boolean enabled) {
        this.zzapT = enabled;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean enabled) {
        this.zzapU = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.zzapJ;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.zzapK;
    }

    public int getMapType() {
        return this.zzapL;
    }

    public CameraPosition getCamera() {
        return this.zzapM;
    }

    public Boolean getZoomControlsEnabled() {
        return this.zzapN;
    }

    public Boolean getCompassEnabled() {
        return this.zzapO;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.zzapP;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.zzapQ;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.zzapR;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.zzapS;
    }

    public Boolean getLiteMode() {
        return this.zzapT;
    }

    public Boolean getMapToolbarEnabled() {
        return this.zzapU;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

