/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.zzn;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="LatLngCreator")
public final class LatLng
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<LatLng> CREATOR = new zzn();
    @SafeParcelable.Field(id=2)
    public final double latitude;
    @SafeParcelable.Field(id=3)
    public final double longitude;

    public int hashCode() {
        long l = Double.doubleToLongBits(this.latitude);
        long l2 = Double.doubleToLongBits(this.longitude);
        long l3 = l2 ^ l2 >>> 32;
        return ((int)(l ^ l >>> 32) + 31) * 31 + (int)l3;
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("lat/lng: (");
        stringBuilder.append(this.latitude);
        stringBuilder.append(",");
        stringBuilder.append(this.longitude);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public LatLng(@SafeParcelable.Param(id=2) double latitude, @SafeParcelable.Param(id=3) double longitude) {
        void var1_1;
        void var3_2;
        this.longitude = !(var3_2 < -180.0) && var3_2 < 180.0 ? var3_2 : ((var3_2 + -180.0) % 360.0 + 360.0) % 360.0 + -180.0;
        this.latitude = Math.max(-90.0, Math.min(90.0, (double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        double d = this.latitude;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeDouble((Parcel)var1_1, (int)2, (double)d);
        void v1 = var1_1;
        SafeParcelWriter.writeDouble((Parcel)v1, (int)3, (double)this.longitude);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@Nullable Object o) {
        LatLng latLng;
        if (this == latLng) {
            return true;
        }
        if (!(latLng instanceof LatLng)) {
            return false;
        }
        latLng = latLng;
        return Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(latLng.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(latLng.longitude);
    }
}

