/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.zzh;
import com.google.android.gms.maps.model.zzi;

@SafeParcelable.Class(creator="FeatureStyleCreator")
public final class FeatureStyle
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<FeatureStyle> CREATOR = new zzi();
    @Nullable
    @SafeParcelable.Field(id=1, getter="getFillColor")
    private final Integer zza;
    @Nullable
    @SafeParcelable.Field(id=2, getter="getStrokeColor")
    private final Integer zzb;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getStrokeWidth")
    private final Float zzc;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getPointRadius")
    private final Float zzd;

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public Float getPointRadius() {
        return this.zzd;
    }

    @Nullable
    public Float getStrokeWidth() {
        return this.zzc;
    }

    @Nullable
    public Integer getFillColor() {
        return this.zza;
    }

    @Nullable
    public Integer getStrokeColor() {
        return this.zzb;
    }

    @SafeParcelable.Constructor
    FeatureStyle(@SafeParcelable.Param(id=1) @Nullable Integer n, @SafeParcelable.Param(id=2) @Nullable Integer n2, @SafeParcelable.Param(id=3) @Nullable Float f, @SafeParcelable.Param(id=4) @Nullable Float f2) {
        this.zza = n;
        this.zzb = n2;
        this.zzc = f;
        this.zzd = f2;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeIntegerObject((Parcel)parcel, (int)1, (Integer)this.getFillColor(), (boolean)false);
        SafeParcelWriter.writeIntegerObject((Parcel)parcel, (int)2, (Integer)this.getStrokeColor(), (boolean)false);
        SafeParcelWriter.writeFloatObject((Parcel)parcel, (int)3, (Float)this.getStrokeWidth(), (boolean)false);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeFloatObject((Parcel)parcel2, (int)4, (Float)this.getPointRadius(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ FeatureStyle(Builder builder, zzh zzh2) {
        this.zza = builder.zza;
        this.zzb = builder.zzb;
        this.zzc = builder.zzc;
        this.zzd = builder.zzd;
    }

    public static final class Builder {
        private Integer zza;
        private Integer zzb;
        private Float zzc;
        private Float zzd;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder fillColor(int fillColor) {
            void var1_1;
            this.zza = (int)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder pointRadius(float pointRadius) {
            void var1_1;
            boolean bl = pointRadius >= 0.0f;
            Preconditions.checkArgument((boolean)bl, (Object)"Point radius cannot be negative.");
            bl = var1_1 <= 128.0f;
            Preconditions.checkArgument((boolean)bl, (Object)"The max allowed pointRadius value is 128px.");
            this.zzd = Float.valueOf((float)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder strokeColor(int strokeColor) {
            void var1_1;
            this.zzb = (int)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder strokeWidth(float strokeWidth) {
            void var1_1;
            boolean bl = strokeWidth >= 0.0f;
            Preconditions.checkArgument((boolean)bl, (Object)"Stroke width cannot be negative.");
            this.zzc = Float.valueOf((float)var1_1);
            return this;
        }

        @NonNull
        public FeatureStyle build() {
            return new FeatureStyle(this, null);
        }
    }
}

