/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Point;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.StreetViewPanoramaCamera;
import com.google.android.gms.maps.model.StreetViewPanoramaLocation;
import com.google.android.gms.maps.model.StreetViewPanoramaOrientation;
import com.google.android.gms.maps.model.StreetViewSource;
import com.google.android.gms.maps.zzaj;
import com.google.android.gms.maps.zzak;
import com.google.android.gms.maps.zzal;
import com.google.android.gms.maps.zzam;

public class StreetViewPanorama {
    private final IStreetViewPanoramaDelegate zza;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Point orientationToPoint(@NonNull StreetViewPanoramaOrientation orientation) {
        StreetViewPanorama this_;
        block3: {
            try {
                void var1_2;
                this_ = this_.zza.orientationToPoint((StreetViewPanoramaOrientation)var1_2);
                if (this_ != null) break block3;
                return null;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
        this_ = (Point)ObjectWrapper.unwrap((IObjectWrapper)this_);
        return this_;
    }

    @NonNull
    public StreetViewPanoramaCamera getPanoramaCamera() {
        try {
            Object this_ = this_.zza.getPanoramaCamera();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this_;
    }

    @NonNull
    public StreetViewPanoramaLocation getLocation() {
        try {
            Object this_ = this_.zza.getStreetViewPanoramaLocation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public StreetViewPanoramaOrientation pointToOrientation(@NonNull Point point) {
        try {
            void var1_2;
            Object this_ = this_.zza.pointToOrientation(ObjectWrapper.wrap((Object)var1_2));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this_;
    }

    public StreetViewPanorama(@NonNull IStreetViewPanoramaDelegate iStreetViewPanoramaDelegate) {
        this.zza = (IStreetViewPanoramaDelegate)Preconditions.checkNotNull((Object)iStreetViewPanoramaDelegate, (Object)"delegate");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void animateTo(@NonNull StreetViewPanoramaCamera camera, long duration) {
        Preconditions.checkNotNull((Object)((Object)camera));
        try {
            void var2_3;
            void var1_2;
            this.zza.animateTo((StreetViewPanoramaCamera)var1_2, (long)var2_3);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnStreetViewPanoramaCameraChangeListener(@Nullable OnStreetViewPanoramaCameraChangeListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnStreetViewPanoramaCameraChangeListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnStreetViewPanoramaCameraChangeListener(new zzak(this, (OnStreetViewPanoramaCameraChangeListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnStreetViewPanoramaChangeListener(@Nullable OnStreetViewPanoramaChangeListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnStreetViewPanoramaChangeListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnStreetViewPanoramaChangeListener(new zzaj(this, (OnStreetViewPanoramaChangeListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnStreetViewPanoramaClickListener(@Nullable OnStreetViewPanoramaClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnStreetViewPanoramaClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnStreetViewPanoramaClickListener(new zzal(this, (OnStreetViewPanoramaClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnStreetViewPanoramaLongClickListener(@Nullable OnStreetViewPanoramaLongClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnStreetViewPanoramaLongClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnStreetViewPanoramaLongClickListener(new zzam(this, (OnStreetViewPanoramaLongClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPanningGesturesEnabled(boolean enablePanning) {
        try {
            void var1_2;
            this.zza.enablePanning((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPosition(@NonNull LatLng position) {
        try {
            void var1_2;
            this.zza.setPosition((LatLng)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPosition(@NonNull String panoId) {
        try {
            void var1_2;
            this.zza.setPositionWithID((String)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPosition(@NonNull LatLng position, int radius) {
        try {
            void var2_3;
            void var1_2;
            this.zza.setPositionWithRadius((LatLng)var1_2, (int)var2_3);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPosition(@NonNull LatLng position, @Nullable StreetViewSource source) {
        try {
            void var2_3;
            void var1_2;
            this.zza.setPositionWithSource((LatLng)var1_2, (StreetViewSource)var2_3);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPosition(@NonNull LatLng position, int radius, @Nullable StreetViewSource source) {
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            this.zza.setPositionWithRadiusAndSource((LatLng)var1_2, (int)var2_3, (StreetViewSource)var3_4);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStreetNamesEnabled(boolean enableStreetNames) {
        try {
            void var1_2;
            this.zza.enableStreetNames((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUserNavigationEnabled(boolean enableUserNavigation) {
        try {
            void var1_2;
            this.zza.enableUserNavigation((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setZoomGesturesEnabled(boolean enableZoom) {
        try {
            void var1_2;
            this.zza.enableZoom((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public boolean isPanningGesturesEnabled() {
        boolean bl;
        try {
            bl = this.zza.isPanningGesturesEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public boolean isStreetNamesEnabled() {
        boolean bl;
        try {
            bl = this.zza.isStreetNamesEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public boolean isUserNavigationEnabled() {
        boolean bl;
        try {
            bl = this.zza.isUserNavigationEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public boolean isZoomGesturesEnabled() {
        boolean bl;
        try {
            bl = this.zza.isZoomGesturesEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public static interface OnStreetViewPanoramaChangeListener {
        public void onStreetViewPanoramaChange(@NonNull StreetViewPanoramaLocation var1);
    }

    public static interface OnStreetViewPanoramaCameraChangeListener {
        public void onStreetViewPanoramaCameraChange(@NonNull StreetViewPanoramaCamera var1);
    }

    public static interface OnStreetViewPanoramaClickListener {
        public void onStreetViewPanoramaClick(@NonNull StreetViewPanoramaOrientation var1);
    }

    public static interface OnStreetViewPanoramaLongClickListener {
        public void onStreetViewPanoramaLongClick(@NonNull StreetViewPanoramaOrientation var1);
    }
}

