/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Point;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public final class CameraUpdateFactory {
    private static ICameraUpdateFactoryDelegate zza;

    @NonNull
    public static CameraUpdate newCameraPosition(@NonNull CameraPosition cameraPosition) {
        CameraUpdate cameraUpdate;
        Preconditions.checkNotNull((Object)((Object)cameraPosition), (Object)"cameraPosition must not be null");
        try {
            CameraPosition cameraPosition2;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().newCameraPosition(cameraPosition2));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return cameraUpdate;
    }

    @NonNull
    public static CameraUpdate newLatLng(@NonNull LatLng latLng) {
        CameraUpdate cameraUpdate;
        Preconditions.checkNotNull((Object)((Object)latLng), (Object)"latLng must not be null");
        try {
            LatLng latLng2;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().newLatLng(latLng2));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return cameraUpdate;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static CameraUpdate newLatLngBounds(@NonNull LatLngBounds bounds, int padding) {
        CameraUpdate cameraUpdate;
        Preconditions.checkNotNull((Object)((Object)bounds), (Object)"bounds must not be null");
        try {
            void var1_2;
            LatLngBounds latLngBounds;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().newLatLngBounds(latLngBounds, (int)var1_2));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return cameraUpdate;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static CameraUpdate newLatLngBounds(@NonNull LatLngBounds bounds, int width, int height, int padding) {
        CameraUpdate cameraUpdate;
        Preconditions.checkNotNull((Object)((Object)bounds), (Object)"bounds must not be null");
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            LatLngBounds latLngBounds;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().newLatLngBoundsWithSize(latLngBounds, (int)var1_2, (int)var2_3, (int)var3_4));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return cameraUpdate;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static CameraUpdate newLatLngZoom(@NonNull LatLng latLng, float zoom) {
        CameraUpdate cameraUpdate;
        Preconditions.checkNotNull((Object)((Object)latLng), (Object)"latLng must not be null");
        try {
            void var1_2;
            LatLng latLng2;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().newLatLngZoom(latLng2, (float)var1_2));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return cameraUpdate;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static CameraUpdate scrollBy(float xPixel, float yPixel) {
        CameraUpdate cameraUpdate;
        try {
            void var1_2;
            float f;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().scrollBy(f, (float)var1_2));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return cameraUpdate;
    }

    @NonNull
    public static CameraUpdate zoomBy(float amount) {
        CameraUpdate cameraUpdate;
        try {
            float f;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().zoomBy(f));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return cameraUpdate;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static CameraUpdate zoomBy(float amount, @NonNull Point focus) {
        CameraUpdate cameraUpdate;
        Preconditions.checkNotNull((Object)focus, (Object)"focus must not be null");
        try {
            void var1_2;
            float f;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().zoomByWithFocus(f, var1_2.x, var1_2.y));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return cameraUpdate;
    }

    @NonNull
    public static CameraUpdate zoomIn() {
        CameraUpdate cameraUpdate;
        try {
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().zoomIn());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return cameraUpdate;
    }

    @NonNull
    public static CameraUpdate zoomOut() {
        CameraUpdate cameraUpdate;
        try {
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().zoomOut());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return cameraUpdate;
    }

    @NonNull
    public static CameraUpdate zoomTo(float zoom) {
        CameraUpdate cameraUpdate;
        try {
            float f;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().zoomTo(f));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return cameraUpdate;
    }

    private CameraUpdateFactory() {
    }

    private static ICameraUpdateFactoryDelegate zzb() {
        return (ICameraUpdateFactoryDelegate)Preconditions.checkNotNull((Object)zza, (Object)"CameraUpdateFactory is not initialized");
    }

    public static void zza(@NonNull ICameraUpdateFactoryDelegate iCameraUpdateFactoryDelegate) {
        zza = (ICameraUpdateFactoryDelegate)Preconditions.checkNotNull((Object)iCameraUpdateFactoryDelegate);
    }
}

