/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.os.RemoteException;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.DeferredLifecycleHelper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.zzca;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzag;
import java.util.ArrayList;
import java.util.List;

@VisibleForTesting
final class zzah
extends DeferredLifecycleHelper<zzag> {
    private final ViewGroup zzb;
    private final Context zzc;
    protected OnDelegateCreatedListener<zzag> zza;
    @Nullable
    private final GoogleMapOptions zzd;
    private final List<OnMapReadyCallback> zze;

    @VisibleForTesting
    zzah(ViewGroup viewGroup, Context context, @Nullable GoogleMapOptions googleMapOptions) {
        ArrayList<OnMapReadyCallback> arrayList = new ArrayList<OnMapReadyCallback>();
        this.zze = arrayList;
        this.zzb = viewGroup;
        this.zzc = context;
        this.zzd = googleMapOptions;
    }

    protected final void createDelegate(OnDelegateCreatedListener<zzag> onDelegateCreatedListener) {
        this.zza = onDelegateCreatedListener;
        this.zzb();
    }

    public final void zza(OnMapReadyCallback onMapReadyCallback) {
        if (this.getDelegate() != null) {
            ((zzag)this.getDelegate()).getMapAsync(onMapReadyCallback);
            return;
        }
        this.zze.add(onMapReadyCallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public final void zzb() {
        if (this.zza == null) return;
        if (this.getDelegate() != null) return;
        try {
            MapsInitializer.initialize(this.zzc);
            Object object = this.zzc;
            object = zzca.zza((Context)object, null);
            object = object.zzg(ObjectWrapper.wrap((Object)this.zzc), this.zzd);
            if (object == null) {
                return;
            }
            Object object2 = this.zza;
            zzag zzag2 = new zzag(this.zzb, (IMapViewDelegate)object);
            object2.onDelegateCreated((LifecycleDelegate)zzag2);
            object = this.zze.iterator();
            while (true) {
                boolean bl;
                if (!(bl = object.hasNext())) {
                    this.zze.clear();
                    return;
                }
                object2 = object.next();
                object2 = (OnMapReadyCallback)object2;
                ((zzag)this.getDelegate()).getMapAsync((OnMapReadyCallback)object2);
            }
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            return;
        }
    }
}

