/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.OnMapsSdkInitializedCallback;
import com.google.android.gms.maps.internal.zzca;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import javax.annotation.concurrent.GuardedBy;

public final class MapsInitializer {
    private static final String zza = MapsInitializer.class.getSimpleName();
    @GuardedBy(value="MapsInitializer.class")
    private static boolean zzb = false;
    @GuardedBy(value="MapsInitializer.class")
    private static Renderer zzc = Renderer.LEGACY;

    public static synchronized int initialize(@NonNull Context context) {
        return MapsInitializer.initialize(context, null, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized int initialize(@NonNull Context context, @Nullable Renderer preferredRenderer, @Nullable OnMapsSdkInitializedCallback callback) {
        int n;
        Object object;
        void var2_7;
        Object object2;
        block15: {
            block14: {
                RuntimeRemoteException runtimeRemoteException;
                Preconditions.checkNotNull((Object)context, (Object)"Context is null");
                object2 = zza;
                String string = String.valueOf(runtimeRemoteException);
                String.valueOf(string).length();
                Log.d((String)object2, (String)"preferredRenderer: ".concat(String.valueOf(string)));
                if (zzb) {
                    if (var2_7 != null) {
                        var2_7.onMapsSdkInitialized(zzc);
                    }
                    return 0;
                }
                try {
                    object2 = zzca.zza(object, (Renderer)((Object)runtimeRemoteException));
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return googlePlayServicesNotAvailableException.errorCode;
                }
                try {
                    CameraUpdateFactory.zza(object2.zze());
                    BitmapDescriptorFactory.zza(object2.zzj());
                    zzb = true;
                    if (runtimeRemoteException == null) break block14;
                }
                catch (RemoteException remoteException) {
                    runtimeRemoteException = new RuntimeRemoteException(remoteException);
                    throw runtimeRemoteException;
                }
                switch (((Enum)((Object)runtimeRemoteException)).ordinal()) {
                    default: {
                        n = 0;
                        break;
                    }
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                }
                break block15;
            }
            n = 0;
        }
        try {
            int n2 = object2.zzd();
            if (n2 == 2) {
                zzc = Renderer.LATEST;
            }
            object2.zzl(ObjectWrapper.wrap((Object)object), n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)zza, (String)"Failed to retrieve renderer type or log initialization.", (Throwable)remoteException);
        }
        object = zza;
        String string = String.valueOf((Object)zzc);
        String.valueOf(string).length();
        Log.d((String)object, (String)"loadedRenderer: ".concat(String.valueOf(string)));
        if (var2_7 != null) {
            var2_7.onMapsSdkInitialized(zzc);
        }
        return 0;
    }

    private MapsInitializer() {
    }

    public static final class Renderer
    extends Enum<Renderer> {
        @NonNull
        public static final /* enum */ Renderer LEGACY;
        @NonNull
        public static final /* enum */ Renderer LATEST;
        private static final /* synthetic */ Renderer[] zza;

        @NonNull
        public static Renderer valueOf(@NonNull String name) {
            String string;
            return Enum.valueOf(Renderer.class, string);
        }

        static {
            Renderer[] rendererArray = new Renderer();
            LEGACY = rendererArray;
            rendererArray = new Renderer();
            LATEST = rendererArray;
            rendererArray = new Renderer[]{LEGACY, LATEST};
            zza = rendererArray;
        }

        @NonNull
        public static Renderer[] values() {
            return (Renderer[])zza.clone();
        }
    }
}

