/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzm;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PolylineOptionsCreator")
public final class PolylineOptions
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<PolylineOptions> CREATOR;
    @SafeParcelable.Field(id=2, getter="getPoints")
    private final List<LatLng> zza;
    @SafeParcelable.Field(id=3, getter="getWidth")
    private float zzb = 10.0f;
    @SafeParcelable.Field(id=4, getter="getColor")
    private int zzc = -16777216;
    @SafeParcelable.Field(id=5, getter="getZIndex")
    private float zzd = 0.0f;
    @SafeParcelable.Field(id=6, getter="isVisible")
    private boolean zze = true;
    @SafeParcelable.Field(id=7, getter="isGeodesic")
    private boolean zzf = false;
    @SafeParcelable.Field(id=8, getter="isClickable")
    private boolean zzg = false;
    @SafeParcelable.Field(id=9, getter="getStartCap")
    private Cap zzh;
    @SafeParcelable.Field(id=10, getter="getEndCap")
    private Cap zzi;
    @SafeParcelable.Field(id=11, getter="getJointType")
    private int zzj;
    @Nullable
    @SafeParcelable.Field(id=12, getter="getPattern")
    private List<PatternItem> zzk;

    public PolylineOptions() {
        Object object = new ButtCap();
        this.zzh = object;
        object = new ButtCap();
        this.zzi = object;
        this.zzj = 0;
        this.zzk = null;
        this.zza = object;
    }

    @SafeParcelable.Constructor
    PolylineOptions(@SafeParcelable.Param(id=2) List list, @SafeParcelable.Param(id=3) float f, @SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=5) float f2, @SafeParcelable.Param(id=6) boolean bl, @SafeParcelable.Param(id=7) boolean bl2, @SafeParcelable.Param(id=8) boolean bl3, @SafeParcelable.Param(id=9) @Nullable Cap cap, @SafeParcelable.Param(id=10) @Nullable Cap cap2, @SafeParcelable.Param(id=11) int n2, @SafeParcelable.Param(id=12) @Nullable List<PatternItem> list2) {
        ButtCap buttCap = new ButtCap();
        this.zzh = buttCap;
        buttCap = new ButtCap();
        this.zzi = buttCap;
        this.zza = list;
        this.zzb = f;
        this.zzc = n;
        this.zzd = f2;
        this.zze = bl;
        this.zzf = bl2;
        this.zzg = bl3;
        if (cap != null) {
            this.zzh = cap;
        }
        if (cap2 != null) {
            this.zzi = cap2;
        }
        this.zzj = n2;
        this.zzk = list2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@RecentlyNonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)2, this.getPoints(), (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)3, (float)this.getWidth());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.getColor());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)5, (float)this.getZIndex());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)6, (boolean)this.isVisible());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)7, (boolean)this.isGeodesic());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)8, (boolean)this.isClickable());
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)9, (Parcelable)this.getStartCap(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)10, (Parcelable)this.getEndCap(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)11, (int)this.getJointType());
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)12, this.getPattern(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolylineOptions add(@RecentlyNonNull LatLng point) {
        void var1_1;
        Preconditions.checkNotNull(this.zza, (Object)"point must not be null.");
        this.zza.add((LatLng)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolylineOptions add(LatLng ... points) {
        void var1_1;
        Preconditions.checkNotNull((Object)points, (Object)"points must not be null.");
        this.zza.addAll(Arrays.asList(var1_1));
        return this;
    }

    @RecentlyNonNull
    public PolylineOptions addAll(@RecentlyNonNull Iterable<LatLng> points) {
        Iterator iterator;
        Preconditions.checkNotNull(points, (Object)"points must not be null.");
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            object = (LatLng)((Object)object);
            this.zza.add((LatLng)((Object)object));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolylineOptions width(float width) {
        void var1_1;
        this.zzb = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolylineOptions color(int color) {
        void var1_1;
        this.zzc = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolylineOptions startCap(@RecentlyNonNull Cap startCap) {
        void var1_1;
        this.zzh = (Cap)((Object)Preconditions.checkNotNull((Object)var1_1, (Object)"startCap must not be null"));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolylineOptions endCap(@RecentlyNonNull Cap endCap) {
        void var1_1;
        this.zzi = (Cap)((Object)Preconditions.checkNotNull((Object)var1_1, (Object)"endCap must not be null"));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolylineOptions jointType(int jointType) {
        void var1_1;
        this.zzj = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolylineOptions pattern(@Nullable List<PatternItem> pattern) {
        void var1_1;
        this.zzk = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolylineOptions zIndex(float zIndex) {
        void var1_1;
        this.zzd = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolylineOptions visible(boolean visible) {
        void var1_1;
        this.zze = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolylineOptions geodesic(boolean geodesic) {
        void var1_1;
        this.zzf = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolylineOptions clickable(boolean clickable) {
        void var1_1;
        this.zzg = var1_1;
        return this;
    }

    @RecentlyNonNull
    public List<LatLng> getPoints() {
        return this.zza;
    }

    public float getWidth() {
        return this.zzb;
    }

    public int getColor() {
        return this.zzc;
    }

    @RecentlyNonNull
    public Cap getStartCap() {
        return this.zzh;
    }

    @RecentlyNonNull
    public Cap getEndCap() {
        return this.zzi;
    }

    public int getJointType() {
        return this.zzj;
    }

    @RecentlyNullable
    public List<PatternItem> getPattern() {
        return this.zzk;
    }

    public float getZIndex() {
        return this.zzd;
    }

    public boolean isVisible() {
        return this.zze;
    }

    public boolean isGeodesic() {
        return this.zzf;
    }

    public boolean isClickable() {
        return this.zzg;
    }

    static {
        zzm zzm2;
        CREATOR = zzm2 = new zzm();
    }
}

